/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.annotation.metrics.linkcoverage;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import net.bpelunit.framework.coverage.annotation.MetricsManager;
import net.bpelunit.framework.coverage.annotation.metrics.IMetric;
import net.bpelunit.framework.coverage.annotation.metrics.IMetricHandler;
import net.bpelunit.framework.coverage.annotation.metrics.linkcoverage.LinkMetricHandler;
import net.bpelunit.framework.coverage.exceptions.BpelException;
import net.bpelunit.framework.coverage.receiver.MarkerState;
import net.bpelunit.framework.coverage.receiver.MarkersRegisterForArchive;
import net.bpelunit.framework.coverage.result.statistic.IStatistic;
import net.bpelunit.framework.coverage.result.statistic.impl.Statistic;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkMetric
implements IMetric {
    public static final String METRIC_NAME = "LinkCoverage";
    private IMetricHandler metricHandler;
    private List<Element> elementsOfBPEL = null;

    public LinkMetric(MarkersRegisterForArchive markersRegistry) {
        this.metricHandler = new LinkMetricHandler(markersRegistry);
    }

    @Override
    public String getName() {
        return METRIC_NAME;
    }

    @Override
    public List<String> getMarkersId() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("positivLinks");
        list.add("negativLinks");
        return list;
    }

    public IMetricHandler getHandler() {
        return this.metricHandler;
    }

    @Override
    public IStatistic createStatistic(Hashtable<String, Hashtable<String, MarkerState>> allMarkers) {
        Statistic statistic = new Statistic(METRIC_NAME);
        statistic.addSubStatistic(this.createSubstatistic("positivLinks", allMarkers));
        statistic.addSubStatistic(this.createSubstatistic("negativLinks", allMarkers));
        return statistic;
    }

    private IStatistic createSubstatistic(String name, Hashtable<String, Hashtable<String, MarkerState>> allLabels) {
        Statistic subStatistic = new Statistic("LinkCoverage: " + name);
        List<MarkerState> statusListe = MetricsManager.getStatus(name, allLabels);
        subStatistic.setStateList(statusListe);
        return subStatistic;
    }

    @Override
    public void setOriginalBPELProcess(Element process) {
        this.elementsOfBPEL = new ArrayList<Element>();
        Iterator iter = process.getDescendants((Filter)new ElementFilter("link", process.getNamespace()));
        while (iter.hasNext()) {
            this.elementsOfBPEL.add((Element)iter.next());
        }
    }

    @Override
    public void insertMarkers() throws BpelException {
        if (this.elementsOfBPEL != null) {
            this.metricHandler.insertMarkersForMetric(this.elementsOfBPEL);
            this.elementsOfBPEL = null;
        }
    }
}

