/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.annotation.metrics.fhcoverage;

import java.util.Iterator;
import java.util.List;
import net.bpelunit.framework.coverage.annotation.metrics.IMetricHandler;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.BpelXMLTools;
import net.bpelunit.framework.coverage.exceptions.BpelException;
import net.bpelunit.framework.coverage.receiver.MarkersRegisterForArchive;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultMetricHandler
implements IMetricHandler {
    public static final String METRIC_NAME = "FaultHandlerMetric";
    public static final String FAULT_HANDLER_LABEL = "catchBlock";
    private MarkersRegisterForArchive markersRegistry;

    public static String getNextMarker() {
        return "catchBlock_" + BpelXMLTools.count++;
    }

    public FaultMetricHandler(MarkersRegisterForArchive markersRegistry) {
        this.markersRegistry = markersRegistry;
    }

    @Override
    public void insertMarkersForMetric(List<Element> processElements) throws BpelException {
        Iterator<Element> iter = processElements.iterator();
        while (iter.hasNext()) {
            this.insertCoverageLabelsForCatchBlock(iter.next());
        }
    }

    private void insertCoverageLabelsForCatchBlock(Element catchBlock) {
        Element child = BpelXMLTools.getFirstEnclosedActivity(catchBlock);
        if (!BpelXMLTools.isSequence(child)) {
            child = BpelXMLTools.ensureElementIsInSequence(child);
        }
        String marker = FaultMetricHandler.getNextMarker();
        this.markersRegistry.registerMarker(marker);
        Comment comment = new Comment("@coverageLabel" + marker);
        child.addContent(0, (Content)comment);
    }
}

