/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.annotation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.bpelunit.framework.control.util.JDomHelper;
import net.bpelunit.framework.coverage.annotation.MetricsManager;
import net.bpelunit.framework.coverage.annotation.metrics.IMetric;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.BasicActivities;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.BpelXMLTools;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.CMServiceFactory;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.StructuredActivities;
import net.bpelunit.framework.coverage.exceptions.BpelException;
import net.bpelunit.framework.coverage.exceptions.BpelVersionException;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.filter.ElementFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instrumenter {
    public static final String COVERAGE_LABEL_IDENTIFIER = "@coverageLabel";
    public static final char COVERAGE_LABEL_INNER_SEPARATOR = '_';
    public static final String SEPARATOR = "#";
    private CMServiceFactory cmServiceFactory;
    private String assignVariable = BpelXMLTools.createVariableName();

    public Document insertAnnotations(Document document, MetricsManager metricManager) throws BpelException {
        Element process_element = document.getRootElement();
        this.checkVersion(process_element);
        this.initializeBPELTools(process_element);
        if (metricManager.hasMetric("FaultHandlerCoverage") || metricManager.hasMetric("CompensationHandlerCoverage")) {
            this.replaceInlineHandler(process_element);
        }
        List<IMetric> metrics = metricManager.getMetrics();
        this.saveOriginalBPELElements(metrics, process_element);
        this.executeInstrumentation(metrics);
        this.createReportInvokesFromCoverageLabels(process_element);
        return document;
    }

    private void replaceInlineHandler(Element process_element) {
        Iterator<Element> iter = JDomHelper.getDescendants(process_element, new ElementFilter("invoke", process_element.getNamespace()){

            public boolean matches(Object o) {
                if (super.matches(o)) {
                    Element invoke = (Element)o;
                    List<Element> children = JDomHelper.getChildren(invoke, "catch");
                    if (children.size() > 0) {
                        return true;
                    }
                    children = JDomHelper.getChildren(invoke, "catchAll");
                    if (children.size() > 0) {
                        return true;
                    }
                    children = JDomHelper.getChildren(invoke, "compensationHandler");
                    if (children.size() > 0) {
                        return true;
                    }
                }
                return false;
            }
        });
        while (iter.hasNext()) {
            this.replaceInlineHandlerForInvoke(iter.next());
        }
    }

    private void replaceInlineHandlerForInvoke(Element element) {
        Element scope = null;
        List<Element> inlineElements = JDomHelper.getChildren(element, "catch");
        List<Element> inlineElements2 = JDomHelper.getChildren(element, "catchAll");
        if (inlineElements.size() > 0 || inlineElements2.size() > 0) {
            scope = BpelXMLTools.createBPELElement("scope");
            Element faultHandler = BpelXMLTools.createBPELElement("faultHandlers");
            scope.addContent((Content)faultHandler);
            Iterator<Element> iter = inlineElements.iterator();
            while (iter.hasNext()) {
                faultHandler.addContent(iter.next().detach());
            }
            if (inlineElements2.size() > 0) {
                faultHandler.addContent(inlineElements2.get(0).detach());
            }
        }
        if ((inlineElements = JDomHelper.getChildren(element, "compensationHandler")).size() > 0) {
            if (scope == null) {
                scope = BpelXMLTools.createBPELElement("scope");
            }
            scope.addContent(inlineElements.get(0).detach());
        }
        if (scope != null) {
            int i = element.getParentElement().indexOf((Content)element);
            scope.setContent(i, (Content)scope);
            scope.addContent((Content)element);
        }
    }

    private void saveOriginalBPELElements(List<IMetric> metrics, Element process_element) {
        for (IMetric metric : metrics) {
            metric.setOriginalBPELProcess(process_element);
        }
    }

    private void checkVersion(Element process_element) throws BpelVersionException {
        Namespace processNamespace = process_element.getNamespace();
        if (!processNamespace.equals((Object)BpelXMLTools.NAMESPACE_BPEL_1_1) && !processNamespace.equals((Object)BpelXMLTools.NAMESPACE_BPEL_2_0)) {
            throw new BpelVersionException("Wrong version. Version " + processNamespace.getURI() + "is not supported. Expected " + BpelXMLTools.NAMESPACE_BPEL_1_1.getURI() + " or " + BpelXMLTools.NAMESPACE_BPEL_2_0.getURI());
        }
    }

    private void initializeBPELTools(Element process_element) throws BpelVersionException {
        BpelXMLTools.process_element = process_element;
        BasicActivities.initialize();
        StructuredActivities.initialize();
    }

    private void executeInstrumentation(List<IMetric> metrics) throws BpelException {
        for (IMetric metric : metrics) {
            metric.insertMarkers();
        }
    }

    private void createReportInvokesFromCoverageLabels(Element process_element) {
        this.cmServiceFactory = CMServiceFactory.getInstance();
        this.cmServiceFactory.prepareBPELFile(process_element);
        this.handleCoverageLabelsInElement(process_element, null);
    }

    private void handleCoverageLabelsInElement(Element element, String variable) {
        ArrayList<Element> childElements = new ArrayList<Element>();
        List<Element> children = JDomHelper.getElementsInContent(element);
        for (int i = 0; i < children.size(); ++i) {
            childElements.add(children.get(i));
        }
        this.replaceCoverageLabelsWithReportInvokes(element, variable);
        boolean isFlow = element.getName().equals("flow");
        for (int i = 0; i < childElements.size(); ++i) {
            if (isFlow) {
                this.handleCoverageLabelsInElement((Element)childElements.get(i), BpelXMLTools.createVariableName());
                continue;
            }
            this.handleCoverageLabelsInElement((Element)childElements.get(i), null);
        }
    }

    private void replaceCoverageLabelsWithReportInvokes(Element element, String variable) {
        List<Comment> children = JDomHelper.getCommentsInContent(element);
        int indexOfLastMarker = -1;
        String marker = "";
        for (int i = children.size() - 1; i > -1; --i) {
            Comment comment = children.get(i);
            int index = element.indexOf((Content)comment);
            String commentText = comment.getText();
            if (this.isCoverageLabel(commentText)) {
                if (indexOfLastMarker - 1 == index) {
                    marker = marker + this.getMarker(commentText, COVERAGE_LABEL_IDENTIFIER) + SEPARATOR;
                } else {
                    if (marker.length() > 0) {
                        this.insertInvokeForLabels(marker, indexOfLastMarker, element, variable);
                    }
                    marker = this.getMarker(commentText, COVERAGE_LABEL_IDENTIFIER) + SEPARATOR;
                }
                comment.detach();
            }
            indexOfLastMarker = index;
            if (i != 0 || marker.length() <= 0) continue;
            this.insertInvokeForLabels(marker, indexOfLastMarker, element, variable);
        }
    }

    private void insertInvokeForLabels(String marker, int index, Element element, String variable) {
        try {
            if (variable == null) {
                variable = this.assignVariable;
            }
            Element assign = this.cmServiceFactory.createAssignElement(marker, variable);
            Element invoke = this.cmServiceFactory.createInvokeElementForLoggingService(variable);
            element.addContent(index, (Content)invoke);
            element.addContent(index, (Content)assign);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private String getMarker(String complettLabel, String identifier) {
        int startIndex = complettLabel.indexOf(identifier) + identifier.length();
        return complettLabel.substring(startIndex);
    }

    private boolean isCoverageLabel(String label) {
        return label.startsWith(COVERAGE_LABEL_IDENTIFIER);
    }
}

