/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.bpelunit.framework.control.ext.IBPELDeployer;
import net.bpelunit.framework.control.ext.IDeployment;
import net.bpelunit.framework.control.ext.ISOAPEncoder;
import net.bpelunit.framework.control.util.ParseUtil;
import net.bpelunit.framework.coverage.ArchiveUtil;
import net.bpelunit.framework.coverage.CoverageConstants;
import net.bpelunit.framework.coverage.ICoverageMeasurementTool;
import net.bpelunit.framework.coverage.annotation.Instrumenter;
import net.bpelunit.framework.coverage.annotation.MetricsManager;
import net.bpelunit.framework.coverage.annotation.metrics.IMetric;
import net.bpelunit.framework.coverage.annotation.metrics.activitycoverage.ActivityMetricHandler;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.BpelXMLTools;
import net.bpelunit.framework.coverage.exceptions.ArchiveFileException;
import net.bpelunit.framework.coverage.exceptions.BpelException;
import net.bpelunit.framework.coverage.exceptions.CoverageMeasurementException;
import net.bpelunit.framework.coverage.receiver.CoverageMessageReceiver;
import net.bpelunit.framework.coverage.receiver.MarkersRegisterForArchive;
import net.bpelunit.framework.coverage.result.statistic.IFileStatistic;
import net.bpelunit.framework.exception.ConfigurationException;
import net.bpelunit.framework.exception.DeploymentException;
import net.bpelunit.framework.model.ProcessUnderTest;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageMeasurementTool
implements ICoverageMeasurementTool {
    private Logger logger = Logger.getLogger(this.getClass());
    private boolean error;
    private CoverageMessageReceiver messageReceiver = null;
    private MarkersRegisterForArchive markersRegistry = null;
    private MetricsManager metricManager = new MetricsManager();
    private String pathToWSDL = null;
    private String errorStatus = null;

    public CoverageMeasurementTool() {
        this.markersRegistry = new MarkersRegisterForArchive(this.metricManager);
        this.messageReceiver = new CoverageMessageReceiver(this.markersRegistry);
    }

    @Override
    public void configureMetrics(Map<String, List<String>> configMap) throws ConfigurationException {
        if (configMap == null) {
            this.setErrorStatus("Configuration error.");
            throw new ConfigurationException("Coverage metrics are not configured.");
        }
        for (String key : configMap.keySet()) {
            IMetric metric = MetricsManager.createMetric(key, configMap.get(key), this.markersRegistry);
            if (metric == null) continue;
            this.metricManager.addMetric(metric);
        }
    }

    @Override
    public void setSOAPEncoder(ISOAPEncoder encoder) {
        this.messageReceiver.setSOAPEncoder(encoder);
    }

    @Override
    public void setPathToWSDL(String wsdl) {
        this.logger.info((Object)("PATHTOWSDL=" + wsdl));
        this.pathToWSDL = wsdl;
        this.messageReceiver.setPathToWSDL(wsdl);
    }

    @Override
    public String getEncodingStyle() {
        return this.messageReceiver.getEncodingStyle();
    }

    @Override
    public String prepareArchiveForCoverageMeasurement(String archive, ProcessUnderTest put, IBPELDeployer deployer) throws CoverageMeasurementException {
        this.logger.info((Object)"Instrumentation started.");
        if (this.pathToWSDL == null) {
            String errorMsg = "No path for a WSDL file for coverage measurment set";
            this.setErrorStatus(errorMsg);
            throw new CoverageMeasurementException(errorMsg);
        }
        String newArchiveFile = ArchiveUtil.createArchivecopy(archive);
        deployer.setArchiveLocation(newArchiveFile);
        IDeployment deployment = null;
        try {
            deployment = deployer.getDeployment(put);
        }
        catch (DeploymentException e) {
            throw new CoverageMeasurementException("Failed to get the IDeployment required to handle archive", e);
        }
        this.prepareLoggingService(deployment);
        this.executeInstrumentationOfBPEL(deployment);
        ArchiveUtil.closeArchives();
        this.logger.info((Object)"Instrumentation is complete.");
        return newArchiveFile;
    }

    private void executeInstrumentationOfBPEL(IDeployment deployment) throws BpelException, ArchiveFileException {
        Instrumenter instrumenter = new Instrumenter();
        BpelXMLTools.count = 0;
        int count = 0;
        ActivityMetricHandler.targetscount = 0;
        try {
            for (String bpelFile : ArchiveUtil.getBPELFileList(deployment.getArchive())) {
                this.markersRegistry.addRegistryForFile(bpelFile);
                Document doc = ParseUtil.getJDOMDocument(bpelFile);
                this.addImports(doc);
                Iterator iter2 = doc.getDescendants((Filter)new ElementFilter("link", doc.getRootElement().getNamespace()));
                while (iter2.hasNext()) {
                    iter2.next();
                    ++count;
                }
                doc = instrumenter.insertAnnotations(doc, this.metricManager);
                ParseUtil.writeDocument(doc, bpelFile);
                this.logger.info((Object)("Instrumentation of BPEL-File " + bpelFile + " is copmplete."));
            }
        }
        catch (IOException e) {
            throw new ArchiveFileException("Instrumentation of bpel archive failed", e);
        }
    }

    private void addImports(Document doc) {
        Element process = doc.getRootElement();
        Element importElem = new Element("import", "http://docs.oasis-open.org/wsbpel/2.0/process/executable");
        importElem.setAttribute("namespace", CoverageConstants.COVERAGETOOL_NAMESPACE.getURI());
        importElem.setAttribute("location", "CoverageReportingService.wsdl");
        importElem.setAttribute("importType", "http://schemas.xmlsoap.org/wsdl/");
        process.addContent((Content)importElem);
    }

    private void prepareLoggingService(IDeployment deployment) throws ArchiveFileException {
        deployment.addLoggingService(this.pathToWSDL);
    }

    @Override
    public void setErrorStatus(String message) {
        this.logger.info((Object)message);
        this.errorStatus = message;
        this.error = true;
    }

    @Override
    public void setCurrentTestCase(String testCase) {
        this.messageReceiver.setCurrentTestcase(testCase);
    }

    @Override
    public synchronized void putMessage(String body) {
        this.messageReceiver.putMessage(body);
        this.notifyAll();
    }

    @Override
    public List<IFileStatistic> getStatistics() {
        if (this.error) {
            return null;
        }
        return this.markersRegistry.getStatistics();
    }

    @Override
    public String getErrorStatus() {
        return this.errorStatus;
    }
}

