/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.deploy.ode;

import de.schlichtherle.io.FileOutputStream;
import de.schlichtherle.io.FileWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import net.bpelunit.framework.control.ext.GenericDeployment;
import net.bpelunit.framework.control.ext.PartnerLink;
import net.bpelunit.framework.control.util.JDomHelper;
import net.bpelunit.framework.control.util.ParseUtil;
import net.bpelunit.framework.coverage.CoverageConstants;
import net.bpelunit.framework.coverage.exceptions.ArchiveFileException;
import net.bpelunit.framework.exception.DeploymentException;
import net.bpelunit.framework.model.Partner;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ODEDeployment
extends GenericDeployment {
    private static final String DESCRIPTOR_NS = "http://www.apache.org/ode/schemas/dd/2007/03";
    private static final String DESCRIPTOR = "deploy.xml";
    private static final String PROCESS_ELEMENT = "process";
    private static final String INVOKE_ATTR = "invoke";
    private static final String NAME_ATTR = "name";
    private static final String PARTNERLINK_ATTR = "partnerLink";
    private static final String SERVICE_ATTR = "service";
    private static final String PORT_ATTR = "port";
    private Document fDescriptorDocument;
    private Logger fLogger = Logger.getLogger(this.getClass());
    private String fDescriptorPath;

    public ODEDeployment(Partner[] partners, String archive) throws DeploymentException {
        super(partners, archive);
        this.fDescriptorDocument = this.getDescriptorDocument();
    }

    public void addLoggingService(String wsdl) throws ArchiveFileException {
        this.addWSDL(wsdl);
        this.prepareDeploymentDescriptor();
    }

    public PartnerLink[] getPartnerLinks() throws DeploymentException {
        ArrayList<PartnerLink> links = new ArrayList<PartnerLink>();
        Element envelope = this.fDescriptorDocument.getRootElement();
        Iterator<Element> processes = JDomHelper.getDescendants(envelope, new ElementFilter(PROCESS_ELEMENT));
        while (processes.hasNext()) {
            Element process = processes.next();
            String processName = process.getAttributeValue(NAME_ATTR);
            if (!processName.contains(this.getProcessUnderTest().getName())) continue;
            Iterator<Element> invokes = JDomHelper.getDescendants(process, new ElementFilter(INVOKE_ATTR));
            while (invokes.hasNext()) {
                Element invoke = invokes.next();
                Element serviceElement = (Element)invoke.getChildren().iterator().next();
                String serviceName = serviceElement.getAttributeValue(NAME_ATTR);
                QName service = this.extractQName(serviceName, serviceElement);
                String port = serviceElement.getAttributeValue(PORT_ATTR);
                String partnerLink = invoke.getAttributeValue(PARTNERLINK_ATTR);
                PartnerLink pl = new PartnerLink(partnerLink, service, port);
                links.add(pl);
            }
            return links.toArray(new PartnerLink[0]);
        }
        throw new DeploymentException("Could not find the process with the specified name in the deployment: " + this.getProcessUnderTest().getName());
    }

    private Document getDescriptorDocument() throws DeploymentException {
        de.schlichtherle.io.File archive = new de.schlichtherle.io.File(this.getArchive());
        Document document = null;
        for (de.schlichtherle.io.File file : (de.schlichtherle.io.File[])archive.listFiles()) {
            if (!file.getName().equals(DESCRIPTOR)) continue;
            try {
                document = ParseUtil.getJDOMDocument(file.getAbsolutePath());
                this.fDescriptorPath = file.getAbsolutePath();
                break;
            }
            catch (IOException e) {
                throw new DeploymentException("Error while reading deployment descriptor from file \"" + file.getAbsolutePath() + "\".", e);
            }
        }
        return document;
    }

    private void addWSDL(String wsdlPath) throws ArchiveFileException {
        File wsdl = new File(wsdlPath);
        this.fLogger.info((Object)("CoverageTool: Adding WSDL-file " + wsdl.getPath() + " for CoverageLogging in ode-archive"));
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.getArchive() + de.schlichtherle.io.File.separator + FilenameUtils.getName((String)wsdl.getAbsolutePath()));
            out.write(FileUtils.readFileToByteArray((File)wsdl));
            this.fLogger.info((Object)"CoverageTool: WSDL-file sucessfull added.");
        }
        catch (IOException e) {
            throw new ArchiveFileException("Could not add WSDL file for coverage measurement tool (" + wsdl.getName() + ") in deployment archive ", e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void prepareDeploymentDescriptor() throws ArchiveFileException {
        InputStream is = null;
        FileWriter writer = null;
        try {
            Element deploy = this.fDescriptorDocument.getRootElement();
            Iterator<Element> processes = JDomHelper.getDescendants(deploy, new ElementFilter(PROCESS_ELEMENT));
            deploy.addNamespaceDeclaration(CoverageConstants.COVERAGETOOL_NAMESPACE);
            while (processes.hasNext()) {
                Element process = processes.next();
                String processName = process.getAttributeValue(NAME_ATTR);
                if (!processName.contains(this.getProcessUnderTest().getName())) continue;
                Element invoke = this.constructInvokeElement();
                process.addContent((Content)invoke);
                writer = new FileWriter(this.fDescriptorPath);
                XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
                xmlOutputter.output(this.fDescriptorDocument, (Writer)writer);
                break;
            }
        }
        catch (IOException e) {
            throw new ArchiveFileException("An I/O error occurred when writing deployment descriptor: " + this.fDescriptorPath, e);
        }
        finally {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(writer);
        }
    }

    private Element constructInvokeElement() {
        Element invoke = new Element(INVOKE_ATTR, DESCRIPTOR_NS);
        invoke.setAttribute(PARTNERLINK_ATTR, "PL_CoverageReportingService_");
        Element service = new Element(SERVICE_ATTR, DESCRIPTOR_NS);
        String serviceName = CoverageConstants.COVERAGETOOL_NAMESPACE.getPrefix() + ":" + "_CoverageReportingService_";
        service.setAttribute(NAME_ATTR, serviceName);
        service.setAttribute(PORT_ATTR, "Soap_service_port");
        invoke.addContent((Content)service);
        return invoke;
    }

    private QName extractQName(String serviceName, Element service) {
        boolean NS_URI = false;
        boolean LOCALNAME = true;
        if (serviceName.contains(":")) {
            String[] tokens = serviceName.split(":");
            if (this.isUri(tokens[0]) && !this.isPrefix(tokens[0], service)) {
                return new QName(tokens[0], tokens[1]);
            }
            String namespace = this.getPrefixValue(tokens[0], service);
            return new QName(namespace, tokens[1]);
        }
        return new QName(null, serviceName);
    }

    private boolean isUri(String uriStr) {
        try {
            new URI(uriStr);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    private boolean isPrefix(String uriStr, Element service) {
        return service != null && service.getNamespace(uriStr) != null;
    }

    private String getPrefixValue(String prefix, Element service) {
        if (service != null && service.getNamespace(prefix) != null) {
            return service.getNamespace(prefix).getURI();
        }
        return null;
    }
}

