/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.test.util;

import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.bpelunit.framework.control.result.XMLResultProducer;
import net.bpelunit.framework.control.soap.NamespaceContextImpl;
import net.bpelunit.framework.exception.ConfigurationException;
import net.bpelunit.framework.exception.DeploymentException;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.model.Partner;
import net.bpelunit.framework.model.test.TestSuite;
import net.bpelunit.framework.model.test.data.SOAPOperationCallIdentifier;
import net.bpelunit.framework.model.test.data.SOAPOperationDirectionIdentifier;
import net.bpelunit.framework.xml.result.XMLTestResultDocument;
import net.bpelunit.test.util.TestTestRunner;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.xmlbeans.XmlOptions;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class TestUtil {
    public static Element parse(String toEncode) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader("<dummy>" + toEncode + "</dummy>")));
        Element dummy = (Element)document.getChildNodes().item(0);
        return dummy;
    }

    public static Element readLiteralData(String fileName) throws Exception {
        String str = IOUtils.toString((InputStream)TestUtil.class.getResourceAsStream(fileName));
        return TestUtil.parse(str);
    }

    public static SOAPOperationCallIdentifier getCall(String path, String wsdl, String operationName) throws SpecificationException {
        String abspath = FileUtils.toFile((URL)TestUtil.class.getResource(path)).getAbsolutePath() + File.separator;
        Partner p = new Partner("MyPartner", abspath, wsdl, "");
        QName service = new QName("http://www.example.org/MyPartner/", "MyPartner");
        SOAPOperationCallIdentifier operation = p.getOperation(service, "MyPartnerSOAP", operationName, SOAPOperationDirectionIdentifier.INPUT);
        return operation;
    }

    public static Node getNode(Element literalData, NamespaceContextImpl context, String string) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext((NamespaceContext)context);
        return (Node)xpath.evaluate(string, literalData, XPathConstants.NODE);
    }

    public static void assertSameAndSuccessfulResults(String msg, File bptsOriginal, File bptsNew) throws Exception {
        XmlOptions options = new XmlOptions();
        options.setSavePrettyPrint();
        String xmlTextA = TestUtil.getXMLResults(bptsOriginal).xmlText(options);
        String xmlTextB = TestUtil.getXMLResults(bptsNew).xmlText(options);
        Assert.assertEquals((String)msg, (Object)xmlTextA, (Object)xmlTextB);
    }

    public static void assertDifferentResults(String msg, File bptsOriginal, File bptsNew) throws Exception {
        XmlOptions options = new XmlOptions();
        options.setSavePrettyPrint();
        String xmlTextA = TestUtil.getXMLResults(bptsOriginal).xmlText(options);
        String xmlTextB = TestUtil.getXMLResults(bptsNew).xmlText(options);
        Assert.assertFalse((String)msg, (boolean)xmlTextA.equals(xmlTextB));
    }

    public static XMLTestResultDocument getXMLResults(File bpts) throws Exception {
        return XMLResultProducer.getXMLResults((TestSuite)TestUtil.getResults(bpts));
    }

    public static TestSuite getResults(File bpts) throws ConfigurationException, DeploymentException, SpecificationException {
        TestTestRunner runner = new TestTestRunner(bpts.getParent(), bpts.getName());
        runner.testRun();
        Assert.assertTrue((String)"Test suites should pass all tests", (boolean)runner.getTestSuite().getStatus().isPassed());
        return runner.getTestSuite();
    }
}

