/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.test.util;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import net.bpelunit.framework.base.BPELUnitBaseRunner;
import net.bpelunit.framework.control.result.ITestResultListener;
import net.bpelunit.framework.exception.ConfigurationException;
import net.bpelunit.framework.exception.DeploymentException;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.model.test.TestCase;
import net.bpelunit.framework.model.test.TestSuite;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import org.apache.commons.io.FileUtils;

public class TestTestRunner
extends BPELUnitBaseRunner
implements ITestResultListener {
    private int fProblems = 0;
    private int fPassed = 0;
    private TestSuite fSuite;

    public void configureInit() throws ConfigurationException {
        this.setHomeDirectory(FileUtils.toFile((URL)BPELUnitBaseRunner.class.getClass().getResource("/")).getAbsolutePath());
    }

    public TestTestRunner(File fBPTS) throws ConfigurationException, SpecificationException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("SKIP_UNKNOWN_EXTENSIONS", "true");
        options.put("GLOBAL_TIMEOUT", "10000");
        this.initialize(options);
        this.fSuite = this.loadTestSuite(fBPTS);
        this.fSuite.addResultListener((ITestResultListener)this);
    }

    public TestTestRunner(String path, String bpts) throws ConfigurationException, SpecificationException {
        this(new File(path, bpts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRun() throws DeploymentException {
        try {
            this.fSuite.setUp();
            this.fSuite.run();
        }
        finally {
            this.fSuite.shutDown();
        }
    }

    public int getProblems() {
        return this.fProblems;
    }

    public int getPassed() {
        return this.fPassed;
    }

    public void progress(ITestArtefact test) {
    }

    public void testCaseEnded(TestCase test) {
        if (test.hasProblems()) {
            ++this.fProblems;
        } else {
            ++this.fPassed;
        }
    }

    public void testCaseStarted(TestCase test) {
    }

    public void configureLogging() throws ConfigurationException {
    }

    public TestSuite getTestSuite() {
        return this.fSuite;
    }
}

