/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.test.unit;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import net.bpelunit.framework.control.soap.DocumentLiteralEncoder;
import net.bpelunit.framework.control.soap.NamespaceContextImpl;
import net.bpelunit.framework.control.soap.RPCLiteralEncoder;
import net.bpelunit.framework.control.util.BPELUnitConstants;
import net.bpelunit.framework.exception.SOAPEncodingException;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.model.test.data.SOAPOperationCallIdentifier;
import net.bpelunit.test.unit.SimpleTest;
import net.bpelunit.test.util.StringOutputStream;
import net.bpelunit.test.util.TestUtil;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TestSOAPEncoder
extends SimpleTest {
    private static final String PATH_TO_FILES = "/soapencoder/";

    private String toString(SOAPMessage message) throws SOAPException, IOException {
        StringOutputStream sos = new StringOutputStream();
        message.writeTo((OutputStream)sos);
        String s = sos.getString();
        return s;
    }

    @Test
    public void testEncodeDocLit() throws SpecificationException, Exception {
        Element literal = TestUtil.readLiteralData("/soapencoder/doclit1.xmlfrag");
        SOAPOperationCallIdentifier operation = TestUtil.getCall(PATH_TO_FILES, "MyPartner.wsdl", "NewOperation");
        DocumentLiteralEncoder encoder = new DocumentLiteralEncoder();
        SOAPMessage message = encoder.construct(operation, literal, BPELUnitConstants.SOAP_FAULT_CODE_CLIENT, "BPELUnit Framework Generated Fault");
        String messageAsString = this.toString(message);
        Assert.assertEquals((Object)this.nl("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Header/><SOAP-ENV:Body><tns:about xmlns:tns=\"http://xxx\">\n  <tns:me name=\"Phil\"/>\n</tns:about></SOAP-ENV:Body></SOAP-ENV:Envelope>"), (Object)this.nl(messageAsString));
    }

    private String nl(String messageAsString) {
        return StringUtils.remove((String)messageAsString, (char)'\r');
    }

    private void testEncodeRPCLit(String fragmentPath) throws Exception, SpecificationException, SOAPEncodingException, SOAPException, IOException {
        Element literal = TestUtil.readLiteralData(PATH_TO_FILES + fragmentPath);
        SOAPOperationCallIdentifier operation = TestUtil.getCall(PATH_TO_FILES, "MyPartner.wsdl", "NewOperation");
        RPCLiteralEncoder encoder = new RPCLiteralEncoder();
        SOAPMessage message = encoder.construct(operation, literal, BPELUnitConstants.SOAP_FAULT_CODE_CLIENT, "BPELUnit Framework Generated Fault");
        String messageAsString = this.toString(message);
        Assert.assertEquals((Object)this.nl("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Header/><SOAP-ENV:Body><rpcwrappernsprefix:NewOperation xmlns:rpcwrappernsprefix=\"http://test.com/NewOperation\"><someFirstPart>\n\t<tns:me xmlns:tns=\"http://xxx\" name=\"Phil\"/>\n</someFirstPart><someSecondPart>directStringPart</someSecondPart></rpcwrappernsprefix:NewOperation></SOAP-ENV:Body></SOAP-ENV:Envelope>"), (Object)this.nl(messageAsString));
    }

    @Test
    public void testEncodeRPCLitUnwrapped() throws SpecificationException, Exception {
        this.testEncodeRPCLit("rpclit1.xmlfrag");
    }

    @Test
    public void testEncodeRPCLitWrapped() throws SpecificationException, Exception {
        this.testEncodeRPCLit("rpclit3.xmlfrag");
    }

    @Test
    public void testDecodeDocLit() throws SpecificationException, Exception {
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage rcvMessage = factory.createMessage(null, this.getClass().getResourceAsStream("/soapencoder/doclit2.xmlfrag"));
        SOAPOperationCallIdentifier operation = TestUtil.getCall(PATH_TO_FILES, "MyPartner.wsdl", "NewOperation");
        DocumentLiteralEncoder encoder = new DocumentLiteralEncoder();
        Element parent = encoder.deconstruct(operation, rcvMessage);
        NamespaceContextImpl nsi = new NamespaceContextImpl();
        nsi.setNamespace("tns", "http://xxx");
        Node node = TestUtil.getNode(parent, nsi, "tns:about");
        Assert.assertNotNull((Object)node);
        Node node2 = TestUtil.getNode(parent, nsi, "tns:about/tns:me");
        Assert.assertNotNull((Object)node2);
    }

    @Test
    public void testDecodeRPCLit() throws SpecificationException, Exception {
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage rcvMessage = factory.createMessage(null, this.getClass().getResourceAsStream("/soapencoder/rpclit2.xmlfrag"));
        SOAPOperationCallIdentifier operation = TestUtil.getCall(PATH_TO_FILES, "MyPartner.wsdl", "NewOperation");
        RPCLiteralEncoder encoder = new RPCLiteralEncoder();
        Element parent = encoder.deconstruct(operation, rcvMessage);
        NamespaceContextImpl nsi = new NamespaceContextImpl();
        nsi.setNamespace("tns", "http://xxx");
        Node node = TestUtil.getNode(parent, nsi, "someFirstPart");
        Assert.assertNotNull((Object)node);
        Node node2 = TestUtil.getNode(parent, nsi, "someFirstPart/tns:me");
        Assert.assertNotNull((Object)node2);
    }
}

