/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.soap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import net.bpelunit.framework.control.ext.IHeaderProcessor;
import net.bpelunit.framework.control.ext.SendPackage;
import net.bpelunit.framework.exception.HeaderProcessingException;
import net.bpelunit.framework.model.test.activity.ActivityContext;

public class WSAHeaderProcessor
implements IHeaderProcessor {
    private static final String WSA_TAG_RELATES_TO = "RelatesTo";
    private static final String WSA_TAG_ADDRESS = "Address";
    private static final String WSA_TAG_REPLY_TO = "ReplyTo";
    private static final String WSA_TAG_MESSAGE_ID = "MessageID";
    private static final String WSA_SENT_DEFAULT_ID = "WSA-838848474774-3883873747";
    private static final String WSA_NAMESPACE = "http://schemas.xmlsoap.org/ws/2003/03/addressing";
    private static final String WSA_RECEIVED = "WSA-Received";
    private static final String WSA_RECEIVED_ADDRESS = "WSA-Received-Address";
    private static final String WSA_RECEIVED_ID = "WSA-Received-ID";
    private static final String WSA_SENT = "WSA-Sent";
    private static final String WSA_SENT_ID = "WSA-Sent-ID";
    private Map<String, String> fProperties = new HashMap<String, String>();

    @Override
    public void processReceive(ActivityContext context, SOAPMessage message) throws HeaderProcessingException {
        if (!context.getUserData(WSA_SENT).equals("true")) {
            SOAPHeader header;
            try {
                header = message.getSOAPHeader();
            }
            catch (SOAPException e) {
                throw new HeaderProcessingException("Incoming SOAP message did not have a SOAP Header.", e);
            }
            String messageID = null;
            Iterator i = header.getChildElements(new QName(WSA_NAMESPACE, WSA_TAG_MESSAGE_ID));
            while (i.hasNext()) {
                SOAPElement soapElement = (SOAPElement)i.next();
                messageID = soapElement.getTextContent();
            }
            String replyTo = null;
            Iterator i2 = header.getChildElements(new QName(WSA_NAMESPACE, WSA_TAG_REPLY_TO));
            while (i2.hasNext()) {
                SOAPElement soapElement = (SOAPElement)i2.next();
                Iterator j = soapElement.getChildElements(new QName(WSA_NAMESPACE, WSA_TAG_ADDRESS));
                while (j.hasNext()) {
                    SOAPElement soapElement2 = (SOAPElement)j.next();
                    replyTo = soapElement2.getTextContent();
                }
            }
            if (messageID == null) {
                messageID = "";
            }
            if (replyTo == null) {
                throw new HeaderProcessingException("Reply-To address not found in incoming message.");
            }
            context.setUserData(WSA_RECEIVED, "true");
            context.setUserData(WSA_RECEIVED_ID, messageID);
            context.setUserData(WSA_RECEIVED_ADDRESS, replyTo);
        }
    }

    @Override
    public void processSend(ActivityContext context, SendPackage sendSpec) throws HeaderProcessingException {
        if (context.getUserData(WSA_RECEIVED).equals("true")) {
            SOAPHeader header;
            String targetURL = context.getUserData(WSA_RECEIVED_ADDRESS);
            String messageID = context.getUserData(WSA_RECEIVED_ID);
            if (targetURL == null) {
                throw new HeaderProcessingException("Target URL from presumed receive was empty.");
            }
            if (messageID == null) {
                throw new HeaderProcessingException("Message ID from presumed receive was empty.");
            }
            SOAPMessage msg = sendSpec.getSoapMessage();
            try {
                header = msg.getSOAPHeader();
            }
            catch (SOAPException e) {
                throw new HeaderProcessingException("No SOAP header in outgoing SOAP message.", e);
            }
            if (!messageID.equals("")) {
                SOAPElement msgId;
                try {
                    msgId = header.addChildElement(new QName(WSA_NAMESPACE, WSA_TAG_RELATES_TO));
                }
                catch (SOAPException e) {
                    throw new HeaderProcessingException("Could not add relatesTo child element to outgoing SOAP message.", e);
                }
                msgId.setTextContent(messageID);
            }
            sendSpec.setTargetURL(targetURL);
        } else {
            SOAPHeader header;
            SOAPMessage msg = sendSpec.getSoapMessage();
            try {
                header = msg.getSOAPHeader();
            }
            catch (SOAPException e) {
                throw new HeaderProcessingException("No SOAP header in outgoing SOAP message.", e);
            }
            try {
                String id = WSA_SENT_DEFAULT_ID;
                SOAPElement msgId = header.addChildElement(new QName(WSA_NAMESPACE, WSA_TAG_MESSAGE_ID));
                msgId.setTextContent(id);
                SOAPElement replyTo = header.addChildElement(new QName(WSA_NAMESPACE, WSA_TAG_REPLY_TO));
                SOAPElement address = replyTo.addChildElement(new QName(WSA_NAMESPACE, WSA_TAG_ADDRESS));
                address.setTextContent(context.getPartnerURL());
                context.setUserData(WSA_SENT, "true");
                context.setUserData(WSA_SENT_ID, id);
            }
            catch (SOAPException e) {
                throw new HeaderProcessingException("Could not add MessageID, ReplyTo or Address child element to outgoing SOAP message.", e);
            }
        }
    }

    @Override
    public void setProperty(String name, String stringValue) {
        this.fProperties.put(name, stringValue);
    }
}

