/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.datasource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bpelunit.framework.control.datasource.DataSourceConfigurationOption;
import net.bpelunit.framework.control.ext.IDataSource;

public class DataSourceHelper {
    private static Map<Class<?>, List<DataSourceConfigurationOption>> optionsForDataSource = new HashMap();

    public static List<DataSourceConfigurationOption> getConfigurationOptionsFor(Class<? extends IDataSource> dataSource) {
        List<DataSourceConfigurationOption> configurationOptions = optionsForDataSource.get(dataSource.getClass());
        if (configurationOptions == null) {
            configurationOptions = DataSourceHelper.extractConfigurationOptionsForClass(dataSource);
            optionsForDataSource.put(dataSource, configurationOptions);
        }
        return configurationOptions;
    }

    public static List<DataSourceConfigurationOption> getConfigurationOptionsFor(IDataSource dataSource) {
        return DataSourceHelper.getConfigurationOptionsFor(dataSource.getClass());
    }

    public static boolean isValidConfigurationOption(IDataSource dataSource, String propertyName) {
        List<DataSourceConfigurationOption> properties = DataSourceHelper.getConfigurationOptionsFor(dataSource);
        propertyName = DataSourceHelper.toFirstUpper(propertyName);
        for (DataSourceConfigurationOption p : properties) {
            if (!p.name.equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    public static void setConfigurationOption(IDataSource dataSource, String name, String value) {
        name = DataSourceHelper.toFirstUpper(name);
        try {
            Method m = dataSource.getClass().getMethod("set" + name, String.class);
            m.invoke((Object)dataSource, value);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Cannot access set" + name + ". Setting configuration option for data source failed!", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Data Source does not have any configuration option " + name + "!");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot access set" + name + ". Setting configuration option for data source failed!", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Error while setting option " + name + " on data source: " + e.getMessage(), e.getCause());
        }
    }

    private static void extractConfigurationOptionForMethod(Method m, List<DataSourceConfigurationOption> configurationOptions) {
        String configurationOptionName;
        IDataSource.ConfigurationOption annotation = m.getAnnotation(IDataSource.ConfigurationOption.class);
        if (annotation != null && (configurationOptionName = DataSourceHelper.extractConfigurationOptionName(m)) != null) {
            DataSourceConfigurationOption configurationOption = new DataSourceConfigurationOption(configurationOptionName, annotation.defaultValue(), annotation.description());
            configurationOptions.add(configurationOption);
        }
    }

    private static String extractConfigurationOptionName(Method m) {
        String name = m.getName();
        if (name.startsWith("set")) {
            return DataSourceHelper.toFirstUpper(name.substring("set".length()));
        }
        return null;
    }

    private static List<DataSourceConfigurationOption> extractConfigurationOptionsForClass(Class<? extends IDataSource> clazz) {
        ArrayList<DataSourceConfigurationOption> configurationOptions = new ArrayList();
        for (Method m : clazz.getMethods()) {
            DataSourceHelper.extractConfigurationOptionForMethod(m, configurationOptions);
        }
        configurationOptions = Collections.unmodifiableList(configurationOptions);
        return configurationOptions;
    }

    private static String toFirstUpper(String optionName) {
        if (optionName == null || optionName.length() == 0) {
            return "";
        }
        return optionName.substring(0, 1).toUpperCase() + optionName.substring(1);
    }

    static InputStream getInputStreamFromInlineData(String data) {
        return new ByteArrayInputStream(data.getBytes());
    }

    public static List<String> validateDataSourceAnnotation(Class<? extends IDataSource> ds) {
        ArrayList<String> validationMessages = new ArrayList<String>();
        IDataSource.DataSource annotation = ds.getAnnotation(IDataSource.DataSource.class);
        if (annotation == null) {
            validationMessages.add("A class implementing IDataSource must be annotated with @DataSource");
            return validationMessages;
        }
        if (annotation.name().equals("")) {
            validationMessages.add("DataSource.name() must not be null. This name is used in the UI.");
        }
        if (annotation.shortName().equals("")) {
            validationMessages.add("DataSource.shortName() must not be null. This name can be used in the test suite specification instead of a content type.");
        }
        for (String contentType : annotation.contentTypes()) {
            if (!contentType.equals("")) continue;
            validationMessages.add("DataSource.contentTypes() must not include a null nor an empty (\"\") value.");
        }
        return validationMessages;
    }

    public static List<String> validateMethodAnnotations(Class<? extends IDataSource> ds) {
        ArrayList<String> validationMessages = new ArrayList<String>();
        for (Method m : ds.getMethods()) {
            DataSourceHelper.validateMethodAnnotation(m, validationMessages);
        }
        return validationMessages;
    }

    private static void validateMethodAnnotation(Method m, List<String> validationMessages) {
        IDataSource.ConfigurationOption methodAnnotation = m.getAnnotation(IDataSource.ConfigurationOption.class);
        if (methodAnnotation != null) {
            Class<?>[] parameterTypes;
            String name = m.getName();
            if (!name.startsWith("set") | name.length() < 4) {
                validationMessages.add("Method " + name + " is annotated with @ConfigurationOption but must be named setXYZ.");
            }
            if (methodAnnotation.description() == null || methodAnnotation.description().equals("")) {
                validationMessages.add("Description for method " + name + " must not be empty.");
            }
            if ((parameterTypes = m.getParameterTypes()).length != 1 || parameterTypes[0] != String.class) {
                validationMessages.add("The method " + name + " must have the signature public void " + name + "(String) (wrong parameter list)");
            }
            if (m.getReturnType() != Void.TYPE) {
                validationMessages.add("The method " + name + " must have the signature public void " + name + "(String) (wrong return type)");
            }
        }
    }

    public static String getName(IDataSource ds) {
        IDataSource.DataSource annotation = ds.getClass().getAnnotation(IDataSource.DataSource.class);
        return annotation.name();
    }

    public static String getShortName(IDataSource ds) {
        IDataSource.DataSource annotation = ds.getClass().getAnnotation(IDataSource.DataSource.class);
        return annotation.shortName();
    }
}

