/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.data;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathVariableResolver;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.report.StateData;
import org.w3c.dom.Element;

public class ReceiveCondition
implements ITestArtefact {
    private String fExpression;
    private String fExpectedValue;
    private String fActualValue;
    private ITestArtefact fParent;
    private ArtefactStatus fStatus;

    public ReceiveCondition(ITestArtefact parent, String condition, String value) {
        this.fExpression = condition;
        this.fExpectedValue = value;
        this.fStatus = ArtefactStatus.createInitialStatus();
        this.fParent = parent;
        this.fActualValue = null;
    }

    public void evaluate(Element literalData, NamespaceContext context, XPathVariableResolver variableResolver) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(context);
        if (variableResolver != null) {
            xpath.setXPathVariableResolver(variableResolver);
        }
        try {
            String completeXPath = this.fExpression + "=" + this.fExpectedValue;
            if (!((Boolean)xpath.evaluate(completeXPath, literalData, XPathConstants.BOOLEAN)).booleanValue()) {
                String smartGuess = xpath.evaluate(this.fExpression, literalData);
                if (smartGuess != null) {
                    this.fActualValue = smartGuess;
                    if ("".equals(this.fActualValue)) {
                        this.fActualValue = "(no data)";
                    }
                }
                String sExpectedValue = xpath.evaluate(this.fExpectedValue, literalData);
                this.fStatus = ArtefactStatus.createFailedStatus(String.format("Condition failed. Obtained value was '%s', expected '%s'", smartGuess, sExpectedValue));
            } else {
                this.fStatus = ArtefactStatus.createPassedStatus();
            }
        }
        catch (Exception e) {
            Throwable root = BPELUnitUtil.findRootThrowable(e);
            this.fStatus = ArtefactStatus.createErrorStatus(root.getMessage());
        }
    }

    public String getExpression() {
        return this.fExpression;
    }

    public String getExpectedValue() {
        return this.fExpectedValue;
    }

    public String getActualValue() {
        return this.fActualValue;
    }

    public boolean isFailure() {
        return this.fStatus.isFailure();
    }

    public boolean isError() {
        return this.fStatus.isError();
    }

    @Override
    public String getName() {
        return "Receive Condition";
    }

    @Override
    public ITestArtefact getParent() {
        return this.fParent;
    }

    @Override
    public List<ITestArtefact> getChildren() {
        return new ArrayList<ITestArtefact>();
    }

    @Override
    public ArtefactStatus getStatus() {
        return this.fStatus;
    }

    @Override
    public List<StateData> getStateData() {
        ArrayList<StateData> stateData = new ArrayList<StateData>();
        stateData.addAll(this.fStatus.getAsStateData());
        stateData.add(new StateData("Expression", this.fExpression));
        stateData.add(new StateData("Value", this.fExpectedValue));
        if (this.fActualValue != null) {
            stateData.add(new StateData("Actual Data", this.fActualValue));
        }
        return stateData;
    }

    @Override
    public void reportProgress(ITestArtefact artefact) {
        this.fParent.reportProgress(artefact);
    }

    public String toString() {
        StringBuffer r = new StringBuffer();
        r.append(this.fExpression);
        r.append(" => Evaluation: " + this.fStatus);
        return r.toString();
    }
}

