/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.activity;

import java.util.ArrayList;
import java.util.List;
import net.bpelunit.framework.exception.SynchronousSendException;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.activity.ActivityContext;
import net.bpelunit.framework.model.test.activity.TwoWaySyncActivity;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.report.StateData;
import net.bpelunit.framework.model.test.wire.IncomingMessage;
import net.bpelunit.framework.model.test.wire.OutgoingMessage;

public class SendReceiveSync
extends TwoWaySyncActivity {
    private String fWrongReturnBody;

    public SendReceiveSync(PartnerTrack partnerTrack) {
        super(partnerTrack);
        this.fStatus = ArtefactStatus.createInitialStatus();
    }

    @Override
    public void run(ActivityContext context) {
        IncomingMessage returnMsg;
        this.fSendSpec.handle(context);
        if (this.fSendSpec.hasProblems()) {
            this.fStatus = this.fSendSpec.getStatus();
            return;
        }
        OutgoingMessage msg = new OutgoingMessage();
        msg.setTargetURL(this.fSendSpec.getTargetURL());
        msg.setSOAPAction(this.fSendSpec.getSOAPHTTPAction());
        msg.setBody(this.fSendSpec.getInWireFormat());
        try {
            this.fSendSpec.delay();
            returnMsg = context.sendMessage(msg);
        }
        catch (SynchronousSendException e) {
            this.fStatus = ArtefactStatus.createErrorStatus("HTTP Error while sending out synchronous message: " + e.getMessage(), e);
            return;
        }
        catch (InterruptedException e) {
            this.fStatus = ArtefactStatus.createAbortedStatus("Aborted due to error in other partner track", e);
            return;
        }
        if (returnMsg.getReturnCode() == 200) {
            this.fReceiveSpec.handle(context, returnMsg.getBody());
            this.fStatus = this.fReceiveSpec.getStatus();
        } else if (returnMsg.getReturnCode() >= 500 && returnMsg.getReturnCode() < 600) {
            this.fReceiveSpec.handle(context, returnMsg.getBody());
            this.fStatus = this.fReceiveSpec.getStatus();
        } else {
            this.fStatus = ArtefactStatus.createErrorStatus("Error: Answer from synchronous call had non-expected return code " + returnMsg.getReturnCode());
            this.fWrongReturnBody = returnMsg.getBody();
            if ("".equals(this.fWrongReturnBody)) {
                this.fWrongReturnBody = "(empty)";
            }
        }
    }

    @Override
    public String getActivityCode() {
        return "SendReceiveSync";
    }

    @Override
    public String getName() {
        return "Send/Receive Synchronous";
    }

    @Override
    public List<ITestArtefact> getChildren() {
        ArrayList<ITestArtefact> children = new ArrayList<ITestArtefact>();
        children.add(this.fSendSpec);
        children.add(this.fReceiveSpec);
        return children;
    }

    @Override
    public List<StateData> getStateData() {
        ArrayList<StateData> stateData = new ArrayList<StateData>();
        stateData.addAll(this.fStatus.getAsStateData());
        if (this.fWrongReturnBody != null) {
            stateData.add(new StateData("Return Body", this.fWrongReturnBody));
        }
        return stateData;
    }
}

