/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.activity;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.activity.ActivityContext;
import net.bpelunit.framework.model.test.activity.TwoWaySyncActivity;
import net.bpelunit.framework.model.test.data.DataCopyOperation;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.wire.IncomingMessage;
import net.bpelunit.framework.model.test.wire.OutgoingMessage;

public class ReceiveSendSync
extends TwoWaySyncActivity {
    public ReceiveSendSync(PartnerTrack partnerTrack) {
        super(partnerTrack);
        this.fStatus = ArtefactStatus.createInitialStatus();
    }

    @Override
    public void run(ActivityContext context) {
        IncomingMessage incoming;
        context.setHeaderProcessor(this.fHeaderProcessor);
        context.setMapping(this.fMapping);
        try {
            incoming = context.receiveMessage(this.getPartnerTrack());
        }
        catch (TimeoutException e) {
            this.fStatus = ArtefactStatus.createErrorStatus("Timeout while waiting for incoming synchronous message", e);
            return;
        }
        catch (InterruptedException e) {
            this.fStatus = ArtefactStatus.createAbortedStatus("Aborted while waiting for incoming synchronous message", e);
            return;
        }
        this.fReceiveSpec.handle(context, incoming.getBody());
        OutgoingMessage msg = new OutgoingMessage();
        if (!this.fReceiveSpec.hasProblems()) {
            this.fSendSpec.handle(context);
            if (!this.fSendSpec.hasProblems()) {
                if (this.fSendSpec.isFault()) {
                    msg.setCode(500);
                } else {
                    msg.setCode(200);
                }
                msg.setBody(this.fSendSpec.getInWireFormat());
            } else {
                msg.setCode(500);
                msg.setBody(BPELUnitUtil.generateGenericSOAPFault());
            }
        } else {
            msg.setCode(500);
            msg.setBody(BPELUnitUtil.generateGenericSOAPFault());
        }
        try {
            this.fSendSpec.delay();
            context.postAnswer(this.getPartnerTrack(), msg);
            this.fStatus = this.fReceiveSpec.hasProblems() ? this.fReceiveSpec.getStatus() : (this.fSendSpec.hasProblems() ? this.fSendSpec.getStatus() : ArtefactStatus.createPassedStatus());
        }
        catch (TimeoutException e) {
            this.fStatus = ArtefactStatus.createErrorStatus("Timeout occurred while waiting for synchronous answer to be sent.", e);
            return;
        }
        catch (InterruptedException e) {
            this.fStatus = ArtefactStatus.createAbortedStatus("Aborted while waiting for synchronous answer to be sent.", e);
            return;
        }
    }

    @Override
    public String getActivityCode() {
        return "ReceiveSendSync";
    }

    @Override
    public String getName() {
        return "Receive/Send Synchronous";
    }

    @Override
    public List<ITestArtefact> getChildren() {
        ArrayList<ITestArtefact> children = new ArrayList<ITestArtefact>();
        if (this.fMapping != null) {
            for (DataCopyOperation copy : this.fMapping) {
                children.add(copy);
            }
        }
        children.add(this.fReceiveSpec);
        children.add(this.fSendSpec);
        return children;
    }
}

