/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model;

import java.io.File;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.model.test.data.SOAPOperationCallIdentifier;
import net.bpelunit.framework.model.test.data.SOAPOperationDirectionIdentifier;

public class Partner {
    private String fName;
    private String fPathToWSDL;
    private String fSimulatedURL;
    private String fBasePath;
    private Definition fWSDLDefinition;

    public Partner(String name, String testBasePath, String wsdlName, String baseURL) throws SpecificationException {
        this.fName = name;
        this.fPathToWSDL = testBasePath + wsdlName;
        this.fBasePath = testBasePath;
        this.fSimulatedURL = baseURL;
        if (!this.fSimulatedURL.endsWith("/")) {
            this.fSimulatedURL = this.fSimulatedURL + "/";
        }
        this.fSimulatedURL = this.fSimulatedURL + this.fName;
        if (!new File(this.fPathToWSDL).exists()) {
            throw new SpecificationException("Cannot read WSDL file for partner " + this.getName() + ": File \"" + this.fPathToWSDL + "\" not found.");
        }
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            this.fWSDLDefinition = reader.readWSDL(this.fPathToWSDL);
        }
        catch (WSDLException e) {
            throw new SpecificationException("Error while reading WSDL for partner " + this.getName() + " from file \"" + this.fPathToWSDL + "\".", e);
        }
    }

    public String getName() {
        return this.fName;
    }

    public String getSimulatedURL() {
        return this.fSimulatedURL;
    }

    public String getBasePath() {
        return this.fBasePath;
    }

    public SOAPOperationCallIdentifier getOperation(QName service, String port, String operationName, SOAPOperationDirectionIdentifier direction) throws SpecificationException {
        return new SOAPOperationCallIdentifier(this.fWSDLDefinition, service, port, operationName, direction);
    }

    public Definition getWSDLDefinition() {
        return this.fWSDLDefinition;
    }

    public String toString() {
        return this.getName();
    }
}

