/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.result.statistic.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.bpelunit.framework.coverage.receiver.MarkerState;
import net.bpelunit.framework.coverage.result.statistic.IStatistic;

public class Statistic
implements IStatistic {
    private int totalNumber = 0;
    private String name;
    private List<IStatistic> subStatistics = null;
    private List<MarkerState> statusListe = null;

    public Statistic(String string) {
        this.name = string;
    }

    @Override
    public List<IStatistic> getSubStatistics() {
        return this.subStatistics;
    }

    @Override
    public void addSubStatistic(IStatistic statistic) {
        if (this.subStatistics == null) {
            this.subStatistics = new ArrayList<IStatistic>();
        }
        this.subStatistics.add(statistic);
    }

    @Override
    public int getTotalNumber() {
        int number = 0;
        if (this.subStatistics == null) {
            number = this.totalNumber;
        } else {
            Iterator<IStatistic> iter = this.subStatistics.iterator();
            while (iter.hasNext()) {
                number += iter.next().getTotalNumber();
            }
        }
        return number;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<MarkerState> getTestedItems(String testCase) {
        HashSet<MarkerState> set = new HashSet<MarkerState>();
        if (this.subStatistics == null) {
            for (MarkerState status : this.statusListe) {
                if (!status.isTestedWithTestcase(testCase)) continue;
                set.add(status);
            }
        } else {
            Iterator<IStatistic> iterator = this.subStatistics.iterator();
            while (iterator.hasNext()) {
                set.addAll(iterator.next().getTestedItems(testCase));
            }
        }
        return set;
    }

    @Override
    public int getTestedNumber(String testCase) {
        return this.getTestedItems(testCase).size();
    }

    @Override
    public int getTestedNumber(Set<String> testCases) {
        HashSet<MarkerState> set = new HashSet<MarkerState>();
        Iterator<String> iter = testCases.iterator();
        while (iter.hasNext()) {
            Set<MarkerState> items = this.getTestedItems(iter.next());
            set.addAll(items);
        }
        return set.size();
    }

    @Override
    public int getTestedNumber() {
        int number = 0;
        if (this.subStatistics == null && this.statusListe != null) {
            Iterator<MarkerState> iter = this.statusListe.iterator();
            while (iter.hasNext()) {
                if (!iter.next().isTested()) continue;
                ++number;
            }
        } else {
            Iterator<IStatistic> iter = this.subStatistics.iterator();
            while (iter.hasNext()) {
                number += iter.next().getTestedNumber();
            }
        }
        return number;
    }

    @Override
    public void setStateList(List<MarkerState> statusListe) {
        this.totalNumber = statusListe.size();
        this.statusListe = statusListe;
    }
}

