/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.annotation.metrics.chcoverage;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import net.bpelunit.framework.coverage.annotation.MetricsManager;
import net.bpelunit.framework.coverage.annotation.metrics.IMetric;
import net.bpelunit.framework.coverage.annotation.metrics.IMetricHandler;
import net.bpelunit.framework.coverage.annotation.metrics.chcoverage.CompensationMetricHandler;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.BpelXMLTools;
import net.bpelunit.framework.coverage.exceptions.BpelException;
import net.bpelunit.framework.coverage.receiver.MarkerState;
import net.bpelunit.framework.coverage.receiver.MarkersRegisterForArchive;
import net.bpelunit.framework.coverage.result.statistic.IStatistic;
import net.bpelunit.framework.coverage.result.statistic.impl.Statistic;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;

public class CompensationMetric
implements IMetric {
    public static final String METRIC_NAME = "CompensationHandlerCoverage";
    private IMetricHandler metricHandler;
    private ArrayList<Element> elementsOfBPEL = null;

    public CompensationMetric(MarkersRegisterForArchive markersRegistry) {
        this.metricHandler = new CompensationMetricHandler(markersRegistry);
    }

    @Override
    public String getName() {
        return METRIC_NAME;
    }

    @Override
    public List<String> getMarkersId() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("compHandler");
        return list;
    }

    public List<String> getConfigInfo() {
        return null;
    }

    public IMetricHandler getHandler() {
        return this.metricHandler;
    }

    @Override
    public IStatistic createStatistic(Hashtable<String, Hashtable<String, MarkerState>> allMarkers) {
        Statistic statistic = new Statistic(METRIC_NAME);
        statistic.setStateList(MetricsManager.getStatus("compHandler", allMarkers));
        return statistic;
    }

    @Override
    public void setOriginalBPELProcess(Element process) {
        Iterator compensHandlers = process.getDescendants((Filter)new ElementFilter("compensationHandler", BpelXMLTools.getProcessNamespace()));
        this.elementsOfBPEL = new ArrayList();
        while (compensHandlers.hasNext()) {
            this.elementsOfBPEL.add((Element)compensHandlers.next());
        }
    }

    @Override
    public void insertMarkers() throws BpelException {
        if (this.elementsOfBPEL != null) {
            this.metricHandler.insertMarkersForMetric(this.elementsOfBPEL);
            this.elementsOfBPEL = null;
        }
    }
}

