/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.ext;

import de.schlichtherle.io.File;
import de.schlichtherle.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import net.bpelunit.framework.control.ext.IDeployment;
import net.bpelunit.framework.control.ext.PartnerLink;
import net.bpelunit.framework.control.util.JDomHelper;
import net.bpelunit.framework.control.util.ParseUtil;
import net.bpelunit.framework.exception.DeploymentException;
import net.bpelunit.framework.exception.EndPointException;
import net.bpelunit.framework.model.Partner;
import net.bpelunit.framework.model.ProcessUnderTest;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public abstract class GenericDeployment
implements IDeployment {
    private static final String SERVICE_ELEMENT = "service";
    private static final String NAME_ATTR = "name";
    private static final String PORT_ELEMENT = "port";
    private static final String LOCATION_ATTR = "location";
    private Partner[] fPartners;
    private Partner fPut;
    private Map<QName, String> fServiceToWsdlMapping = new HashMap<QName, String>();
    private String fArchive;

    public GenericDeployment(Partner[] partners, String archive) throws DeploymentException {
        this.fPartners = partners;
        this.fArchive = archive;
        this.fPut = this.findPUT();
        try {
            this.populateServiceToWsdlMapping(new File(archive));
        }
        catch (IOException e) {
            throw new DeploymentException("Problem instantiating Deployment class", e);
        }
    }

    @Override
    public void replaceEndpoints(PartnerLink pl, Partner p) throws EndPointException {
        Document document;
        String simulatedURL = p.getSimulatedURL();
        QName partnerService = pl.getService();
        String partnerPort = pl.getPort();
        String serviceWsdl = this.fServiceToWsdlMapping.get(partnerService);
        try {
            document = ParseUtil.getJDOMDocument(serviceWsdl);
        }
        catch (IOException e) {
            throw new EndPointException("An I/O error occurred when reading the WSDL.", e);
        }
        Element definition = document.getRootElement();
        Iterator<Element> services = JDomHelper.getDescendants(definition, new ElementFilter(SERVICE_ELEMENT));
        while (services.hasNext()) {
            Element port;
            Element service = services.next();
            Iterator<Element> ports = JDomHelper.getDescendants(service, new ElementFilter(PORT_ELEMENT));
            if (partnerPort != null) {
                while (ports.hasNext()) {
                    port = ports.next();
                    String portName = port.getAttributeValue(NAME_ATTR);
                    if (!portName.equals(partnerPort)) continue;
                    Element address = (Element)port.getChildren().iterator().next();
                    address.removeAttribute(LOCATION_ATTR);
                    address.setAttribute(LOCATION_ATTR, simulatedURL);
                }
                continue;
            }
            while (ports.hasNext()) {
                port = ports.next();
                Element address = (Element)port.getChildren().iterator().next();
                address.removeAttribute(LOCATION_ATTR);
                address.setAttribute(LOCATION_ATTR, simulatedURL);
            }
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(serviceWsdl);
            XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
            xmlOutputter.output(document, (Writer)writer);
        }
        catch (IOException e) {
            throw new EndPointException("An I/O error occurred when writing the WSDL.", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public String getArchive() {
        return this.fArchive;
    }

    @Override
    public Partner[] getPartners() {
        return this.fPartners;
    }

    protected Partner getProcessUnderTest() {
        return this.fPut;
    }

    protected Map<QName, String> getServiceToWsdlMapping() {
        return this.fServiceToWsdlMapping;
    }

    private ProcessUnderTest findPUT() {
        for (Partner p : this.fPartners) {
            if (!(p instanceof ProcessUnderTest)) continue;
            return (ProcessUnderTest)p;
        }
        return null;
    }

    private void populateServiceToWsdlMapping(File dir) throws IOException {
        if (dir == null) {
            return;
        }
        if (!dir.exists()) {
            throw new IOException("Could not find directory: " + dir.toString());
        }
        for (File file : (File[])dir.listFiles()) {
            if (file.isDirectory()) {
                this.populateServiceToWsdlMapping(file);
                continue;
            }
            if (!file.getName().endsWith(".wsdl")) continue;
            Definition definition = ParseUtil.getWsdlDefinition(file.getAbsolutePath(), true, true);
            Map<QName, Service> services = this.getDefinitions(definition);
            for (QName service : services.keySet()) {
                this.fServiceToWsdlMapping.put(service, file.getAbsolutePath());
            }
        }
    }

    private Map<QName, Service> getDefinitions(Definition definition) {
        return definition.getServices();
    }
}

