/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.deploy.activebpel;

import java.io.File;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import net.bpelunit.framework.control.deploy.activebpel.ActiveBPELRequestEntityBase;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.DOMException;

public class BPRDeployRequestEntity
extends ActiveBPELRequestEntityBase {
    private static final String ACTIVEBPEL_ELEMENT_ABASE64FILE = "aBase64File";
    private static final String ACTIVEBPEL_ELEMENT_ABPRFILENAME = "aBprFilename";
    private static final String ACTIVEBPEL_ELEMENT_DEPLOYBPR = "deployBpr";
    private static final String XSD_STRING = "xsd:string";
    private File file;

    public BPRDeployRequestEntity(File file) throws IOException, SOAPException {
        this.file = file;
        this.createMessage();
    }

    @Override
    protected void populateMessage(SOAPMessage message) throws SOAPException, DOMException, IOException {
        SOAPElement xmlDeployBpr = this.addRootElement(message, new QName(ACTIVEBPEL_ELEMENT_DEPLOYBPR));
        SOAPElement xmlBprFilename = xmlDeployBpr.addChildElement(ACTIVEBPEL_ELEMENT_ABPRFILENAME);
        xmlBprFilename.addAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "type"), XSD_STRING);
        xmlBprFilename.setTextContent(FilenameUtils.getName((String)this.file.toString()));
        SOAPElement xmlBase64File = xmlDeployBpr.addChildElement(ACTIVEBPEL_ELEMENT_ABASE64FILE);
        xmlBase64File.addAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "type"), XSD_STRING);
        StringBuilder content = new StringBuilder();
        byte[] arr = FileUtils.readFileToByteArray((File)this.file);
        byte[] encoded = Base64.encodeBase64Chunked((byte[])arr);
        for (int i = 0; i < encoded.length; ++i) {
            content.append((char)encoded[i]);
        }
        xmlBase64File.setTextContent(content.toString());
    }
}

