/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.bpelunit.framework.BPELUnitRunner;
import net.bpelunit.framework.control.datasource.DataSourceUtil;
import net.bpelunit.framework.control.ext.IBPELDeployer;
import net.bpelunit.framework.control.ext.IDataSource;
import net.bpelunit.framework.control.ext.IHeaderProcessor;
import net.bpelunit.framework.control.ext.ISOAPEncoder;
import net.bpelunit.framework.control.soap.NamespaceContextImpl;
import net.bpelunit.framework.control.util.ActivityUtil;
import net.bpelunit.framework.control.util.BPELUnitConstants;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.coverage.ICoverageMeasurementTool;
import net.bpelunit.framework.exception.DataSourceException;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.model.Partner;
import net.bpelunit.framework.model.ProcessUnderTest;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.TestCase;
import net.bpelunit.framework.model.test.TestSuite;
import net.bpelunit.framework.model.test.activity.Activity;
import net.bpelunit.framework.model.test.activity.ReceiveAsync;
import net.bpelunit.framework.model.test.activity.ReceiveSendAsync;
import net.bpelunit.framework.model.test.activity.ReceiveSendSync;
import net.bpelunit.framework.model.test.activity.SendAsync;
import net.bpelunit.framework.model.test.activity.SendReceiveAsync;
import net.bpelunit.framework.model.test.activity.SendReceiveSync;
import net.bpelunit.framework.model.test.activity.TwoWayAsyncActivity;
import net.bpelunit.framework.model.test.activity.Wait;
import net.bpelunit.framework.model.test.data.DataCopyOperation;
import net.bpelunit.framework.model.test.data.DataSpecification;
import net.bpelunit.framework.model.test.data.ReceiveCondition;
import net.bpelunit.framework.model.test.data.ReceiveDataSpecification;
import net.bpelunit.framework.model.test.data.SOAPOperationCallIdentifier;
import net.bpelunit.framework.model.test.data.SOAPOperationDirectionIdentifier;
import net.bpelunit.framework.model.test.data.SendDataSpecification;
import net.bpelunit.framework.xml.suite.XMLActivity;
import net.bpelunit.framework.xml.suite.XMLAnyElement;
import net.bpelunit.framework.xml.suite.XMLCondition;
import net.bpelunit.framework.xml.suite.XMLCopy;
import net.bpelunit.framework.xml.suite.XMLDeploymentSection;
import net.bpelunit.framework.xml.suite.XMLHeaderProcessor;
import net.bpelunit.framework.xml.suite.XMLMapping;
import net.bpelunit.framework.xml.suite.XMLPUTDeploymentInformation;
import net.bpelunit.framework.xml.suite.XMLPartnerDeploymentInformation;
import net.bpelunit.framework.xml.suite.XMLPartnerTrack;
import net.bpelunit.framework.xml.suite.XMLProperty;
import net.bpelunit.framework.xml.suite.XMLReceiveActivity;
import net.bpelunit.framework.xml.suite.XMLSendActivity;
import net.bpelunit.framework.xml.suite.XMLSetUp;
import net.bpelunit.framework.xml.suite.XMLSoapActivity;
import net.bpelunit.framework.xml.suite.XMLTestCase;
import net.bpelunit.framework.xml.suite.XMLTestCasesSection;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.framework.xml.suite.XMLTestSuiteDocument;
import net.bpelunit.framework.xml.suite.XMLTrack;
import net.bpelunit.framework.xml.suite.XMLTwoWayActivity;
import net.bpelunit.framework.xml.suite.XMLWaitActivity;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpecificationLoader {
    private Logger fLogger;
    private BPELUnitRunner fRunner;

    protected SpecificationLoader(BPELUnitRunner runner) {
        this.fRunner = runner;
        this.fLogger = Logger.getLogger(this.getClass());
    }

    protected TestSuite loadTestSuite(File suite) throws SpecificationException {
        try {
            this.fLogger.info((Object)("Loading test suite from file " + suite));
            String path = suite.getCanonicalFile().getParent() + File.separator;
            this.fLogger.info((Object)("Using base path: " + path));
            XMLTestSuiteDocument doc = XMLTestSuiteDocument.Factory.parse(suite);
            this.validateTestSuite(doc);
            TestSuite testSuite = this.parseSuite(path, doc);
            this.fLogger.info((Object)("Loaded test suite with name \"" + testSuite.getName() + "\" and " + testSuite.getTestCaseCount() + " test cases."));
            if (BPELUnitRunner.measureTestCoverage()) {
                ICoverageMeasurementTool tool = BPELUnitRunner.getCoverageMeasurmentTool();
                try {
                    String encodingStyle = tool.getEncodingStyle();
                    if (encodingStyle != null) {
                        tool.setSOAPEncoder(this.fRunner.createNewSOAPEncoder(encodingStyle));
                    }
                }
                catch (Exception e) {
                    tool.setErrorStatus("CoverageTool: " + e.getMessage());
                }
            }
            return testSuite;
        }
        catch (XmlException e) {
            throw new SpecificationException("An XML reading error occurred when reading the test suite file.", e);
        }
        catch (IOException e) {
            throw new SpecificationException("An I/O error occurred when reading the test suite file.", e);
        }
    }

    private void validateTestSuite(XMLTestSuiteDocument doc) throws SpecificationException {
        ArrayList validationErrors = new ArrayList();
        XmlOptions options = new XmlOptions();
        options.setErrorListener(validationErrors);
        if (!doc.validate(options)) {
            StringWriter sW = new StringWriter();
            for (Object o : validationErrors) {
                sW.append(o + "\n");
            }
            throw new SpecificationException("BPTS is invalid:\n" + sW.toString());
        }
    }

    private TestSuite parseSuite(String testDirectory, XMLTestSuiteDocument xmlTestSuiteDocument) throws SpecificationException {
        XMLTestSuite xmlTestSuite = xmlTestSuiteDocument.getTestSuite();
        if (xmlTestSuite == null) {
            throw new SpecificationException("Could not find testSuite root element in the test suite XML file.");
        }
        String xmlSuiteName = xmlTestSuite.getName();
        if (xmlSuiteName == null) {
            throw new SpecificationException("No name found for the test suite.");
        }
        URL suiteBaseURL = this.getBaseURL(xmlTestSuite);
        XMLDeploymentSection xmlDeployment = xmlTestSuite.getDeployment();
        if (xmlDeployment == null) {
            throw new SpecificationException("Could not find deployment section inside test suite document.");
        }
        HashMap<String, Partner> suitePartners = new HashMap<String, Partner>();
        XMLPUTDeploymentInformation xmlPut = xmlDeployment.getPut();
        if (xmlPut == null) {
            throw new SpecificationException("Expected a Process Under Test (PUT) in the test suite.");
        }
        String xmlPutName = xmlPut.getName();
        String xmlPutWSDL = xmlPut.getWsdl();
        String xmlPutType = xmlPut.getType();
        if (xmlPutName == null || xmlPutWSDL == null || xmlPutType == null) {
            throw new SpecificationException("Process Under Test must have attributes name, type, wsdl, and a deployment section specified.");
        }
        ProcessUnderTest processUnderTest = new ProcessUnderTest(xmlPutName, testDirectory, xmlPutWSDL, suiteBaseURL.toString());
        for (XMLProperty property : xmlPut.getPropertyList()) {
            processUnderTest.setXMLDeploymentOption(property.getName(), property.getStringValue());
        }
        IBPELDeployer suitePutDeployer = this.fRunner.createNewDeployer(xmlPutType);
        processUnderTest.setDeployer(suitePutDeployer);
        processUnderTest.setGlobalConfiguration(this.fRunner.getGlobalConfigurationForDeployer(suitePutDeployer));
        suitePartners.put(processUnderTest.getName(), processUnderTest);
        processUnderTest.setPartners(suitePartners);
        Partner suiteClient = new Partner("client", testDirectory, xmlPutWSDL, suiteBaseURL.toString());
        for (XMLPartnerDeploymentInformation xmlPDI : xmlDeployment.getPartnerList()) {
            String name = xmlPDI.getName();
            String wsdl = xmlPDI.getWsdl();
            if (name == null || wsdl == null) {
                throw new SpecificationException("Name and WSDL attributes of a partner must not be empty.");
            }
            Partner p = new Partner(xmlPDI.getName(), testDirectory, xmlPDI.getWsdl(), suiteBaseURL.toString());
            suitePartners.put(p.getName(), p);
        }
        TestSuite suite = new TestSuite(xmlSuiteName, suiteBaseURL, processUnderTest);
        try {
            this.readTestSuiteSetUpBlock(suite, xmlTestSuite);
        }
        catch (Exception ex) {
            throw new SpecificationException("Error during test suite set up", ex);
        }
        XMLTestCasesSection xmlTestCases = xmlTestSuite.getTestCases();
        if (xmlTestCases == null) {
            throw new SpecificationException("No test case section found in test suite document.");
        }
        List<XMLTestCase> xmlTestCaseList = xmlTestCases.getTestCaseList();
        if (xmlTestCaseList == null || xmlTestCaseList.size() == 0) {
            throw new SpecificationException("No test cases found.");
        }
        int currentNumber = 0;
        for (XMLTestCase xmlTestCase : xmlTestCaseList) {
            IDataSource dataSource;
            String xmlTestCaseName = xmlTestCase.getName();
            if (xmlTestCaseName == null) {
                xmlTestCaseName = "Test Case " + currentNumber;
            }
            ++currentNumber;
            boolean isVary = xmlTestCase.getVary();
            int rounds = this.computeNumberOfRounds(xmlTestSuiteDocument, isVary);
            this.fLogger.info((Object)("Varying: " + isVary + " (Rounds: " + rounds + ")"));
            try {
                dataSource = DataSourceUtil.createDataSource(xmlTestSuite, xmlTestCase, new File(testDirectory), this.fRunner);
            }
            catch (DataSourceException e) {
                throw new SpecificationException("There was a problem while initializing the specified data source.", e);
            }
            int nRows = dataSource != null ? dataSource.getNumberOfRows() : 1;
            int nRounds = isVary && rounds > 0 ? rounds : 1;
            for (int iRow = 0; iRow < nRows; ++iRow) {
                for (int iRound = 0; iRound < nRounds; ++iRound) {
                    String currentTestCaseName = xmlTestCaseName;
                    if (dataSource != null) {
                        currentTestCaseName = currentTestCaseName + " (Row " + (iRow + 1) + ")";
                    }
                    if (isVary && rounds > 0) {
                        currentTestCaseName = currentTestCaseName + " (Round " + (iRound + 1) + ")";
                    }
                    if (xmlTestCase.getAbstract()) continue;
                    TestCase test = this.createTestCase(suitePartners, suiteClient, suite, xmlTestCase, currentTestCaseName, iRound);
                    test.setDataSource(dataSource);
                    test.setRowIndex(iRow);
                    suite.addTestCase(test);
                }
            }
        }
        return suite;
    }

    private URL getBaseURL(XMLTestSuite xmlTestSuite) throws SpecificationException {
        try {
            String path;
            URL suiteBaseURL;
            int port;
            String xmlUrl = xmlTestSuite.getBaseURL();
            if (xmlUrl == null) {
                xmlUrl = "http://localhost:7777/ws/";
            }
            if ((port = (suiteBaseURL = new URL(xmlUrl)).getPort()) == -1) {
                port = 80;
            }
            if (!(path = suiteBaseURL.getPath()).endsWith("/")) {
                path = path + "/";
            }
            suiteBaseURL = new URL(suiteBaseURL.getProtocol(), suiteBaseURL.getHost(), port, path);
            return suiteBaseURL;
        }
        catch (MalformedURLException e) {
            throw new SpecificationException("Could not create a valid URL from specified base URL.", e);
        }
    }

    private int computeNumberOfRounds(XMLTestSuiteDocument xmlTestSuiteDocument, boolean isVary) throws SpecificationException {
        int rounds = 0;
        if (isVary) {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NamespaceContextImpl nsContext = new NamespaceContextImpl();
            nsContext.setNamespace("ts", "http://www.bpelunit.org/schema/testSuite");
            xpath.setNamespaceContext(nsContext);
            try {
                NodeList set = (NodeList)xpath.evaluate("//@delaySequence", xmlTestSuiteDocument.getDomNode(), XPathConstants.NODESET);
                int currentMax = 0;
                for (int i = 0; i < set.getLength(); ++i) {
                    Attr attr;
                    List<Integer> ints;
                    if (!(set.item(i) instanceof Attr) || (ints = this.getRoundInformation((attr = (Attr)set.item(i)).getValue())) == null) continue;
                    currentMax = ints.size();
                }
                rounds = currentMax;
            }
            catch (XPathExpressionException e) {
                throw new SpecificationException("There was a problem finding delay sequences. This most likely indicates a bug in the framework.");
            }
        }
        return rounds;
    }

    private void readTestSuiteSetUpBlock(TestSuite testSuite, XMLTestSuite xmlTestSuite) throws Exception {
        if (!xmlTestSuite.isSetSetUp()) {
            return;
        }
        XMLSetUp xmlSetUp = xmlTestSuite.getSetUp();
        if (xmlSetUp.isSetScript()) {
            testSuite.setSetUpVelocityScript(xmlSetUp.getScript());
        }
    }

    private TestCase createTestCase(Map<String, Partner> suitePartners, Partner suiteClient, TestSuite suite, XMLTestCase xmlTestCase, String xmlTestCaseName, int round) throws SpecificationException {
        TestCase test = new TestCase(suite, xmlTestCaseName);
        for (XMLProperty data : xmlTestCase.getPropertyList()) {
            String xmlPropertyName = data.getName();
            String xmlPropertyData = data.getStringValue();
            if (xmlPropertyName == null || xmlPropertyData == null) {
                throw new SpecificationException("Metadata in Test Case " + xmlTestCaseName + " must have both property and value.");
            }
            test.addProperty(xmlPropertyName, xmlPropertyData);
        }
        this.readTestCaseSetUpBlock(test, xmlTestCase);
        XMLTrack xmlClientTrack = xmlTestCase.getClientTrack();
        if (xmlClientTrack == null) {
            throw new SpecificationException("Could not find clientTrack in test case " + xmlTestCase.getName());
        }
        PartnerTrack track = new PartnerTrack(test, suiteClient);
        this.readActivities(track, xmlTestCase, xmlClientTrack, round);
        track.setNamespaceContext(this.getNamespaceMap(xmlClientTrack.newCursor()));
        test.addPartnerTrack(track);
        List<XMLPartnerTrack> partnerTrackList = xmlTestCase.getPartnerTrackList();
        if (partnerTrackList != null) {
            for (XMLPartnerTrack xmlPartnerTrack : partnerTrackList) {
                String xmlPartnerTrackName = xmlPartnerTrack.getName();
                if (xmlPartnerTrackName == null) {
                    throw new SpecificationException("A partnertrack has been specified without a partner name.");
                }
                Partner realPartner = suitePartners.get(xmlPartnerTrackName);
                if (realPartner == null) {
                    throw new SpecificationException("Could not find partner or client with the name " + xmlPartnerTrack.getName());
                }
                PartnerTrack pTrack = new PartnerTrack(test, realPartner);
                this.readActivities(pTrack, xmlTestCase, xmlPartnerTrack, round);
                pTrack.setNamespaceContext(this.getNamespaceMap(xmlPartnerTrack.newCursor()));
                if (xmlPartnerTrack.isSetAssume()) {
                    pTrack.setAssumption(xmlPartnerTrack.getAssume());
                }
                test.addPartnerTrack(pTrack);
            }
        }
        return test;
    }

    private void readTestCaseSetUpBlock(TestCase test, XMLTestCase xmlTestCase) {
        if (!xmlTestCase.isSetSetUp()) {
            return;
        }
        XMLSetUp xmlSetUp = xmlTestCase.getSetUp();
        if (xmlSetUp.isSetScript()) {
            test.setSetUpVelocityScript(xmlSetUp.getScript());
        }
    }

    private void readActivities(PartnerTrack partnerTrack, XMLTestCase xmlTestCase, XMLTrack xmlTrack, int round) throws SpecificationException {
        List<XMLActivity> xmlActivities = ActivityUtil.getActivities(xmlTrack);
        if (xmlActivities.isEmpty()) {
            if (xmlTestCase.getBasedOn() != null && !"".equals(xmlTestCase.getBasedOn())) {
                XMLTrack trackInNewTestCase;
                String trackName = null;
                trackName = xmlTrack instanceof XMLPartnerTrack ? ((XMLPartnerTrack)xmlTrack).getName() : "client";
                XMLTestCase basedOnTestCase = this.findInHierarchy(xmlTestCase, trackName);
                if (basedOnTestCase != null && (trackInNewTestCase = this.getPartnerTrack(basedOnTestCase, trackName)) != null) {
                    this.readActivities(partnerTrack, basedOnTestCase, trackInNewTestCase, round);
                    return;
                }
            }
            partnerTrack.setActivities(new ArrayList<Activity>());
        } else {
            ArrayList<Activity> activities = new ArrayList<Activity>();
            for (XMLActivity event : xmlActivities) {
                DataSpecification spec;
                Activity activity;
                if (event instanceof XMLWaitActivity) {
                    XMLWaitActivity xmlWait = (XMLWaitActivity)event;
                    activity = new Wait(partnerTrack);
                    ((Wait)activity).setWaitDuration(xmlWait.getWaitForMilliseconds());
                    activity.setAssumption(event.getAssume());
                    activities.add(activity);
                    continue;
                }
                if (event instanceof XMLReceiveActivity) {
                    XMLReceiveActivity xmlReceive = (XMLReceiveActivity)event;
                    activity = new ReceiveAsync(partnerTrack);
                    spec = this.createReceiveSpecificationStandalone(activity, xmlReceive, SOAPOperationDirectionIdentifier.INPUT);
                    ((ReceiveAsync)activity).initialize((ReceiveDataSpecification)spec);
                    activity.setAssumption(event.getAssume());
                    activities.add(activity);
                    continue;
                }
                if (event instanceof XMLSendActivity) {
                    XMLSendActivity xmlSend = (XMLSendActivity)event;
                    activity = new SendAsync(partnerTrack);
                    spec = this.createSendSpecificationFromStandalone(activity, xmlSend, SOAPOperationDirectionIdentifier.INPUT, round);
                    ((SendAsync)activity).initialize((SendDataSpecification)spec);
                    activity.setAssumption(event.getAssume());
                    activities.add(activity);
                    continue;
                }
                if (event instanceof XMLTwoWayActivity) {
                    XMLTwoWayActivity op = (XMLTwoWayActivity)event;
                    if (ActivityUtil.isActivity(op, ActivityUtil.ActivityConstant.RECEIVE_SEND_SYNC)) {
                        activity = this.createReceiveSendSynchronous(op, partnerTrack, round);
                        activity.setAssumption(event.getAssume());
                        activities.add(activity);
                    }
                    if (ActivityUtil.isActivity(op, ActivityUtil.ActivityConstant.SEND_RECEIVE_SYNC)) {
                        activity = this.createSendReceiveSynchronous(op, partnerTrack, round);
                        activity.setAssumption(event.getAssume());
                        activities.add(activity);
                    }
                    if (ActivityUtil.isActivity(op, ActivityUtil.ActivityConstant.RECEIVE_SEND_ASYNC)) {
                        activity = new ReceiveSendAsync(partnerTrack);
                        this.fillAsyncTwoWay((TwoWayAsyncActivity)activity, op, round);
                        activity.setAssumption(event.getAssume());
                        activities.add(activity);
                    }
                    if (!ActivityUtil.isActivity(op, ActivityUtil.ActivityConstant.SEND_RECEIVE_ASYNC)) continue;
                    activity = new SendReceiveAsync(partnerTrack);
                    this.fillAsyncTwoWay((TwoWayAsyncActivity)activity, op, round);
                    activity.setAssumption(event.getAssume());
                    activities.add(activity);
                    continue;
                }
                throw new SpecificationException("No activity found when reading event list for " + partnerTrack);
            }
            partnerTrack.setActivities(activities);
        }
    }

    private Activity createSendReceiveSynchronous(XMLTwoWayActivity xmlSendReceiveSync, PartnerTrack partnerTrack, int round) throws SpecificationException {
        SendReceiveSync activity = new SendReceiveSync(partnerTrack);
        XMLSendActivity xmlSend = xmlSendReceiveSync.getSend();
        XMLReceiveActivity xmlReceive = xmlSendReceiveSync.getReceive();
        if (xmlSend == null || xmlReceive == null) {
            throw new SpecificationException("A synchronous send/receive activity must have both receive and send children.");
        }
        XMLHeaderProcessor xmlHeaderProcessor = xmlSendReceiveSync.getHeaderProcessor();
        SendDataSpecification sSpec = this.createSendSpecificationFromParent(activity, xmlSendReceiveSync, xmlSend, SOAPOperationDirectionIdentifier.INPUT, round);
        SOAPOperationDirectionIdentifier receiveDirection = SOAPOperationDirectionIdentifier.OUTPUT;
        if (xmlReceive.getFault()) {
            receiveDirection = SOAPOperationDirectionIdentifier.FAULT;
        }
        ReceiveDataSpecification rSpec = this.createReceiveSpecificationFromParent(activity, xmlSendReceiveSync, xmlReceive, receiveDirection);
        IHeaderProcessor proc = this.getHeaderProcessor(xmlHeaderProcessor);
        ArrayList<DataCopyOperation> mapping = this.getCopyOperations(activity, xmlSendReceiveSync);
        activity.initialize(sSpec, rSpec, proc, mapping);
        return activity;
    }

    private Activity createReceiveSendSynchronous(XMLTwoWayActivity xmlReceiveSendSync, PartnerTrack partnerTrack, int round) throws SpecificationException {
        ReceiveSendSync activity = new ReceiveSendSync(partnerTrack);
        activity.setAssumption(xmlReceiveSendSync.getAssume());
        XMLSendActivity xmlSend = xmlReceiveSendSync.getSend();
        XMLReceiveActivity xmlReceive = xmlReceiveSendSync.getReceive();
        if (xmlSend == null || xmlReceive == null) {
            throw new SpecificationException("A synchronous receive/send activity must have both receive and send children.");
        }
        XMLHeaderProcessor xmlHeaderProcessor = xmlReceiveSendSync.getHeaderProcessor();
        ReceiveDataSpecification rSpec = this.createReceiveSpecificationFromParent(activity, xmlReceiveSendSync, xmlReceive, SOAPOperationDirectionIdentifier.INPUT);
        SOAPOperationDirectionIdentifier sendDirection = SOAPOperationDirectionIdentifier.OUTPUT;
        if (xmlSend.getFault()) {
            sendDirection = SOAPOperationDirectionIdentifier.FAULT;
        }
        SendDataSpecification sSpec = this.createSendSpecificationFromParent(activity, xmlReceiveSendSync, xmlSend, sendDirection, round);
        IHeaderProcessor proc = this.getHeaderProcessor(xmlHeaderProcessor);
        ArrayList<DataCopyOperation> mapping = this.getCopyOperations(activity, xmlReceiveSendSync);
        activity.initialize(sSpec, rSpec, proc, mapping);
        return activity;
    }

    private void fillAsyncTwoWay(TwoWayAsyncActivity twoWayActivity, XMLTwoWayActivity xmlAsyncTwoWay, int round) throws SpecificationException {
        XMLSendActivity xmlSend = xmlAsyncTwoWay.getSend();
        XMLReceiveActivity xmlReceive = xmlAsyncTwoWay.getReceive();
        if (xmlSend == null || xmlReceive == null) {
            throw new SpecificationException("An asynchronous receive/send or send/receive activity must have both receive and send children.");
        }
        XMLHeaderProcessor xmlHeaderProcessor = xmlAsyncTwoWay.getHeaderProcessor();
        ArrayList<DataCopyOperation> mapping = this.getCopyOperations(twoWayActivity, xmlAsyncTwoWay);
        SendAsync sendAct = new SendAsync(twoWayActivity);
        SendDataSpecification sSpec = this.createSendSpecificationFromStandalone(sendAct, xmlSend, SOAPOperationDirectionIdentifier.INPUT, round);
        sendAct.initialize(sSpec);
        ReceiveAsync receiveAct = new ReceiveAsync(twoWayActivity);
        ReceiveDataSpecification rSpec = this.createReceiveSpecificationStandalone(receiveAct, xmlReceive, SOAPOperationDirectionIdentifier.INPUT);
        receiveAct.initialize(rSpec);
        IHeaderProcessor proc = this.getHeaderProcessor(xmlHeaderProcessor);
        twoWayActivity.initialize(sendAct, receiveAct, proc, mapping);
    }

    private SendDataSpecification createSendSpecificationFromStandalone(Activity parentActivity, XMLSendActivity xmlSend, SOAPOperationDirectionIdentifier direction, int round) throws SpecificationException {
        SOAPOperationCallIdentifier operation = this.getOperationCallIdentifier(parentActivity, this.getService(parentActivity, xmlSend), xmlSend.getPort(), xmlSend.getOperation(), direction);
        return this.createSendSpecification(parentActivity, operation, xmlSend, round);
    }

    private SendDataSpecification createSendSpecificationFromParent(Activity parentActivity, XMLTwoWayActivity xmlSendReceiveSync, XMLSendActivity xmlSend, SOAPOperationDirectionIdentifier direction, int round) throws SpecificationException {
        SOAPOperationCallIdentifier operation = this.getOperationCallIdentifier(parentActivity, this.getService(parentActivity, xmlSendReceiveSync), xmlSendReceiveSync.getPort(), xmlSendReceiveSync.getOperation(), direction);
        return this.createSendSpecification(parentActivity, operation, xmlSend, round);
    }

    private SendDataSpecification createSendSpecification(Activity activity, SOAPOperationCallIdentifier operation, XMLSendActivity xmlSend, int round) throws SpecificationException {
        String faultString;
        SendDataSpecification spec = new SendDataSpecification(activity);
        String encodingStyle = operation.getEncodingStyle();
        String targetURL = operation.getTargetURL();
        String soapAction = operation.getSOAPHTTPAction();
        ISOAPEncoder encoder = this.fRunner.createNewSOAPEncoder(encodingStyle);
        if (xmlSend.isSetData() == xmlSend.isSetTemplate()) {
            throw new SpecificationException("Send Element must have either a data or a template child, and not both.");
        }
        XMLAnyElement xmlData = xmlSend.getData();
        XMLAnyElement xmlTemplate = xmlSend.getTemplate();
        Element rawDataRoot = null;
        String templateText = null;
        try {
            if (xmlData != null) {
                rawDataRoot = this.copyAsRootWithNamespaces(xmlData);
            }
            if (xmlTemplate != null) {
                Element templateRoot = this.copyAsRootWithNamespaces(xmlTemplate);
                templateText = XmlObject.Factory.parse((Node)templateRoot).xmlText();
            }
        }
        catch (XmlException e) {
            throw new SpecificationException("An error occurred when reading the literal data or template of send for activity " + activity.getName() + ": " + e.getMessage(), e);
        }
        String delaySequence = xmlSend.getDelaySequence();
        List<Integer> sequence = this.getRoundInformation(delaySequence);
        int currentDelay = 0;
        if (sequence != null && sequence.size() > round) {
            currentDelay = sequence.get(round);
        }
        NamespaceContextImpl context = this.getNamespaceMap(xmlSend.newCursor());
        QName faultCode = xmlSend.isSetFaultcode() ? xmlSend.getFaultcode() : BPELUnitConstants.SOAP_FAULT_CODE_CLIENT;
        String string = faultString = xmlSend.isSetFaultstring() ? xmlSend.getFaultstring() : "BPELUnit Framework Generated Fault";
        if (activity instanceof ReceiveSendSync) {
            spec.initialize(operation, currentDelay, encodingStyle, delaySequence, delaySequence, encoder, rawDataRoot, templateText, context, faultCode, faultString);
        } else {
            spec.initialize(operation, currentDelay, targetURL, soapAction, encodingStyle, encoder, rawDataRoot, templateText, context, faultCode, faultString);
        }
        return spec;
    }

    private Element copyAsRootWithNamespaces(XMLAnyElement xmlData) throws XmlException, DOMException {
        Element rawDataRoot = BPELUnitUtil.generateDummyElementNode();
        XmlObject test = XmlObject.Factory.parse((String)xmlData.xmlText());
        NodeList cn = test.getDomNode().getChildNodes();
        for (int i = 0; i < cn.getLength(); ++i) {
            Node currentItem = cn.item(i);
            if (!(currentItem instanceof Element)) continue;
            Element element = (Element)currentItem;
            rawDataRoot.appendChild(rawDataRoot.getOwnerDocument().importNode(element, true));
        }
        return rawDataRoot;
    }

    private ReceiveDataSpecification createReceiveSpecificationStandalone(Activity parentActivity, XMLReceiveActivity xmlReceive, SOAPOperationDirectionIdentifier direction) throws SpecificationException {
        SOAPOperationCallIdentifier operation = this.getOperationCallIdentifier(parentActivity, this.getService(parentActivity, xmlReceive), xmlReceive.getPort(), xmlReceive.getOperation(), direction);
        return this.createReceiveSpecification(parentActivity, operation, xmlReceive);
    }

    private ReceiveDataSpecification createReceiveSpecificationFromParent(Activity parentActivity, XMLTwoWayActivity xmlReceiveSendSync, XMLReceiveActivity xmlReceive, SOAPOperationDirectionIdentifier direction) throws SpecificationException {
        SOAPOperationCallIdentifier operation = this.getOperationCallIdentifier(parentActivity, this.getService(parentActivity, xmlReceiveSendSync), xmlReceiveSendSync.getPort(), xmlReceiveSendSync.getOperation(), direction);
        return this.createReceiveSpecification(parentActivity, operation, xmlReceive);
    }

    private ReceiveDataSpecification createReceiveSpecification(Activity activity, SOAPOperationCallIdentifier operation, XMLReceiveActivity xmlReceive) throws SpecificationException {
        ReceiveDataSpecification spec = new ReceiveDataSpecification(activity);
        String encodingStyle = operation.getEncodingStyle();
        ISOAPEncoder encoder = this.fRunner.createNewSOAPEncoder(encodingStyle);
        List<XMLCondition> xmlConditionList = xmlReceive.getConditionList();
        ArrayList<ReceiveCondition> cList = new ArrayList<ReceiveCondition>();
        if (xmlConditionList != null) {
            for (XMLCondition xmlCondition : xmlConditionList) {
                cList.add(new ReceiveCondition(spec, xmlCondition.getExpression(), xmlCondition.getValue()));
            }
        }
        NamespaceContextImpl context = this.getNamespaceMap(xmlReceive.newCursor());
        QName faultCode = xmlReceive.getFaultcode();
        String faultString = xmlReceive.getFaultstring();
        spec.initialize(operation, encodingStyle, encoder, cList, context, faultCode, faultString);
        return spec;
    }

    private ArrayList<DataCopyOperation> getCopyOperations(Activity activity, XMLTwoWayActivity xmlTwoWayType) throws SpecificationException {
        List<XMLCopy> xmlCopyList;
        ArrayList<DataCopyOperation> copyDataOperations = new ArrayList<DataCopyOperation>();
        XMLMapping xmlMapping = xmlTwoWayType.getMapping();
        if (xmlMapping != null && (xmlCopyList = xmlMapping.getCopyList()) != null) {
            for (XMLCopy xmlCopy : xmlCopyList) {
                String xmlCopyFrom = xmlCopy.getFrom();
                String xmlCopyTo = xmlCopy.getTo();
                if (xmlCopyFrom == null || xmlCopyTo == null) {
                    throw new SpecificationException("Copy operations need both copy-from and copy-to specifications.");
                }
                copyDataOperations.add(new DataCopyOperation(activity, xmlCopyFrom, xmlCopyTo));
            }
        }
        return copyDataOperations;
    }

    private IHeaderProcessor getHeaderProcessor(XMLHeaderProcessor xmlHeaderProcessor) throws SpecificationException {
        if (xmlHeaderProcessor == null) {
            return null;
        }
        String xmlHeaderProcessorName = xmlHeaderProcessor.getName();
        if (xmlHeaderProcessorName == null) {
            throw new SpecificationException("Header Processor needs a name.");
        }
        List<XMLProperty> propertyList = xmlHeaderProcessor.getPropertyList();
        IHeaderProcessor proc = this.fRunner.createNewHeaderProcessor(xmlHeaderProcessorName);
        if (propertyList != null) {
            for (XMLProperty property : propertyList) {
                String xmlPropertyName = property.getName();
                String xmlPropertyData = property.getStringValue();
                if (xmlPropertyName == null || xmlPropertyData == null) {
                    throw new SpecificationException("Properties in Header Processor " + xmlHeaderProcessorName + " need both property name and value.");
                }
                proc.setProperty(xmlPropertyName, xmlPropertyData);
            }
        }
        return proc;
    }

    private SOAPOperationCallIdentifier getOperationCallIdentifier(Activity activity, QName service, String port, String operation, SOAPOperationDirectionIdentifier direction) throws SpecificationException {
        Partner partner = activity.getPartner();
        if (service == null) {
            throw new SpecificationException("Expected a service specification in activity " + activity.getName() + " (PartnerTrack for partner " + partner + ").");
        }
        if (port == null) {
            throw new SpecificationException("Expected a port specification in activity " + activity.getName() + " (PartnerTrack for partner " + partner + ").");
        }
        if (operation == null) {
            throw new SpecificationException("Expected a operation specification in activity " + activity.getName() + " (PartnerTrack for partner " + partner + ").");
        }
        return partner.getOperation(service, port, operation, direction);
    }

    private QName getService(Activity parentActivity, XMLSoapActivity xmlActivity) throws SpecificationException {
        QName service = null;
        try {
            service = xmlActivity.getService();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (service == null) {
            throw new SpecificationException("Could not find service for activity " + parentActivity.getName() + ": not specified or wrong prefix.");
        }
        return service;
    }

    private NamespaceContextImpl getNamespaceMap(XmlCursor newCursor) {
        HashMap namespaces = new HashMap();
        newCursor.getAllNamespaces(namespaces);
        NamespaceContextImpl context = new NamespaceContextImpl();
        for (String prefix : namespaces.keySet()) {
            context.setNamespace(prefix, (String)namespaces.get(prefix));
        }
        return context;
    }

    private XMLTestCase findInHierarchy(XMLTestCase xmlTestCase, String partnerTrackName) {
        XmlCursor cursor = xmlTestCase.newCursor();
        String basedOn = xmlTestCase.getBasedOn();
        if (cursor.toParent()) {
            XMLTestCasesSection section = (XMLTestCasesSection)cursor.getObject();
            for (XMLTestCase xmlTestCaseFor : section.getTestCaseList()) {
                if (!basedOn.equals(xmlTestCaseFor.getName())) continue;
                if (this.hasNonEmptyPartnerTrack(xmlTestCaseFor, partnerTrackName)) {
                    return xmlTestCaseFor;
                }
                if (xmlTestCaseFor.getBasedOn() == null || "".equals(xmlTestCaseFor.getBasedOn())) continue;
                return this.findInHierarchy(xmlTestCaseFor, partnerTrackName);
            }
        }
        return null;
    }

    private boolean hasNonEmptyPartnerTrack(XMLTestCase xmlTestCase, String partnerTrackName) {
        XMLTrack track = this.getPartnerTrack(xmlTestCase, partnerTrackName);
        if (track != null) {
            return !ActivityUtil.getActivities(track).isEmpty();
        }
        return false;
    }

    private XMLTrack getPartnerTrack(XMLTestCase xmlTestCase, String trackName) {
        XMLTrack track = null;
        if (trackName.equalsIgnoreCase("client")) {
            track = xmlTestCase.getClientTrack();
        } else {
            for (XMLPartnerTrack pTrack : xmlTestCase.getPartnerTrackList()) {
                if (!trackName.equals(pTrack.getName())) continue;
                track = pTrack;
                break;
            }
        }
        return track;
    }

    private List<Integer> getRoundInformation(String roundsAsText) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (roundsAsText != null && !"".equals(roundsAsText)) {
            String[] values = roundsAsText.split(",");
            for (int j = 0; j < values.length; ++j) {
                try {
                    list.add(Integer.parseInt(values[j].trim()));
                    continue;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return list;
        }
        return null;
    }
}

