/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.test.unit;

import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import net.bpelunit.framework.control.ext.SendPackage;
import net.bpelunit.framework.control.soap.NamespaceContextImpl;
import net.bpelunit.framework.control.soap.WSAHeaderProcessor;
import net.bpelunit.framework.model.test.activity.ActivityContext;
import net.bpelunit.test.unit.SimpleTest;
import net.bpelunit.test.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TestWSAHeaderProcessor
extends SimpleTest {
    private static final String PATH_TO_FILES = "/wsahp/";

    @Test
    public void testWSAHeadersReceiveSend() throws Exception {
        ActivityContext dummyContext = new ActivityContext("http://simulated.url");
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage rcvMessage = factory.createMessage(null, this.getClass().getResourceAsStream("/wsahp/incomingSOAP.xml"));
        WSAHeaderProcessor proc = new WSAHeaderProcessor();
        proc.processReceive(dummyContext, rcvMessage);
        Assert.assertEquals((Object)"true", (Object)dummyContext.getUserData("WSA-Received"));
        Assert.assertEquals((Object)"kjasdhfjsdbksjdgdsrhfdgjkdfjk", (Object)dummyContext.getUserData("WSA-Received-ID"));
        Assert.assertEquals((Object)"http://return.to.me/", (Object)dummyContext.getUserData("WSA-Received-Address"));
        SOAPMessage sendMessage = factory.createMessage(null, this.getClass().getResourceAsStream("/wsahp/outgoingSOAP.xml"));
        SendPackage p = new SendPackage("http://target.url", sendMessage);
        proc.processSend(dummyContext, p);
        Assert.assertEquals((Object)"http://return.to.me/", (Object)p.getTargetURL());
        SOAPHeader header = p.getSoapMessage().getSOAPHeader();
        NamespaceContextImpl ns = new NamespaceContextImpl();
        ns.setNamespace("wsa", "http://schemas.xmlsoap.org/ws/2003/03/addressing");
        Node msgId = TestUtil.getNode((Element)header, ns, "wsa:RelatesTo");
        Assert.assertEquals((Object)"kjasdhfjsdbksjdgdsrhfdgjkdfjk", (Object)msgId.getTextContent());
    }

    @Test
    public void testWSAHeadersSendReceive() throws Exception {
        ActivityContext dummyContext = new ActivityContext("http://simulated.url");
        WSAHeaderProcessor proc = new WSAHeaderProcessor();
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage sendMessage = factory.createMessage(null, this.getClass().getResourceAsStream("/wsahp/outgoingSOAP.xml"));
        SendPackage p = new SendPackage("http://target.url", sendMessage);
        proc.processSend(dummyContext, p);
        SOAPHeader header = p.getSoapMessage().getSOAPHeader();
        NamespaceContextImpl ns = new NamespaceContextImpl();
        ns.setNamespace("wsa", "http://schemas.xmlsoap.org/ws/2003/03/addressing");
        Node msgId = TestUtil.getNode((Element)header, ns, "wsa:MessageID");
        Assert.assertEquals((Object)"WSA-838848474774-3883873747", (Object)msgId.getTextContent());
        Node replyTo = TestUtil.getNode((Element)header, ns, "wsa:ReplyTo/wsa:Address");
        Assert.assertEquals((Object)"http://simulated.url", (Object)replyTo.getTextContent());
        Assert.assertEquals((Object)"true", (Object)dummyContext.getUserData("WSA-Sent"));
        Assert.assertEquals((Object)"WSA-838848474774-3883873747", (Object)dummyContext.getUserData("WSA-Sent-ID"));
        SOAPMessage rcvMessage = factory.createMessage(null, this.getClass().getResourceAsStream("/wsahp/incomingSOAP2.xml"));
        proc.processReceive(dummyContext, rcvMessage);
    }
}

