/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.utils.datasourceinliner;

import java.io.File;
import java.io.IOException;
import net.bpelunit.framework.BPELUnitRunner;
import net.bpelunit.framework.exception.ConfigurationException;
import net.bpelunit.framework.exception.DataSourceException;
import net.bpelunit.framework.xml.suite.XMLTestSuiteDocument;
import net.bpelunit.utils.datasourceinliner.DummyRunner;
import net.bpelunit.utils.datasourceinliner.Inliner;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class CLIRunner {
    public static void main(String[] args) throws IOException, DataSourceException, XmlException, ConfigurationException {
        if (args.length != 1) {
            System.err.println(String.format("Usage: dsexpand.sh (path to bpts)\n\nExpands the specified BPTS and dumps it to the standard output.", new Object[0]));
            System.exit(1);
        }
        System.out.println(CLIRunner.expandBPTS(args[0]));
    }

    static String expandBPTS(String sPath) throws IOException, DataSourceException, XmlException, ConfigurationException {
        File fBpts = new File(sPath);
        XMLTestSuiteDocument bptsDoc = XMLTestSuiteDocument.Factory.parse((File)fBpts);
        XMLTestSuiteDocument inlinedDoc = new Inliner().inlineDataSources(bptsDoc, fBpts.getParentFile(), (BPELUnitRunner)new DummyRunner());
        XmlOptions opts = new XmlOptions();
        opts.setSavePrettyPrint();
        opts.setSaveAggressiveNamespaces();
        return inlinedDoc.xmlText(opts);
    }
}

