/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.deploymentchanger.timemocking;

import java.util.List;
import javax.xml.namespace.QName;
import net.bpelunit.framework.control.deploy.IBPELProcess;
import net.bpelunit.framework.control.deploy.IDeployment;
import net.bpelunit.framework.control.ext.IDeploymentChanger;
import net.bpelunit.framework.exception.DeploymentException;
import net.bpelunit.framework.model.test.TestSuite;
import net.bpelunit.model.bpel.IBpelObject;
import net.bpelunit.model.bpel.IProcess;
import net.bpelunit.model.bpel.IWaitingActivity;
import net.bpelunit.util.QNameUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeMocking
implements IDeploymentChanger {
    private static final String DURATION_TEMPLATE = "'PT%dS'";
    private String duration;
    private String xpathToWait;
    private String bpelName;

    @IDeploymentChanger.DeploymentChangerOption(description="XPath expression that selects at least one wait activity. Please do not use any BPEL namespace prefix (e.g. //wait[@name='myWait']).")
    public void setActivityToMock(String xpath) {
        this.xpathToWait = xpath;
    }

    @IDeploymentChanger.DeploymentChangerOption(description="The new duration in seconds")
    public void setNewDuration(String newDurationInSeconds) {
        this.duration = String.format(DURATION_TEMPLATE, Integer.valueOf(newDurationInSeconds));
    }

    @IDeploymentChanger.DeploymentChangerOption
    public void setBPELName(String bpelToChange) {
        this.bpelName = bpelToChange;
    }

    @Override
    public void changeDeployment(IDeployment d, TestSuite testSuite) throws DeploymentException {
        List processes = d.getBPELProcesses();
        this.checkIsSet("Duration", this.duration);
        this.checkIsSet("WaitToMock", this.xpathToWait);
        IProcess process = null;
        if (processes.size() > 1) {
            this.checkIsSet("BPELName", this.bpelName);
            process = this.getProcessForConfiguredName(processes);
        } else {
            process = this.getFirstProcess(processes);
        }
        List objects = process.getElementsByXPath(this.xpathToWait);
        if (objects.size() == 0) {
            throw new DeploymentException("XPath does not reference BPEL Activities: " + this.xpathToWait);
        }
        for (IBpelObject n : objects) {
            if (n instanceof IWaitingActivity) {
                ((IWaitingActivity)n).setDuration(this.duration);
                continue;
            }
            throw new DeploymentException("XPath does not (only) reference BPEL Activities: " + this.xpathToWait);
        }
    }

    private IProcess getFirstProcess(List<? extends IBPELProcess> processes) throws DeploymentException {
        if (processes != null && processes.size() > 0) {
            return processes.get(0).getProcessModel();
        }
        throw new DeploymentException("There no processes in the deployment!");
    }

    private IProcess getProcessForConfiguredName(List<? extends IBPELProcess> processes) throws DeploymentException {
        if (QNameUtil.isQName((String)this.bpelName)) {
            return this.getProcessForConfiguredQName(processes, QNameUtil.parseQName((String)this.bpelName));
        }
        return this.getProcessForConfiguredLocalName(processes);
    }

    private IProcess getProcessForConfiguredLocalName(List<? extends IBPELProcess> processes) throws DeploymentException {
        for (IBPELProcess iBPELProcess : processes) {
            if (!this.bpelName.equals(iBPELProcess.getName().getLocalPart())) continue;
            return iBPELProcess.getProcessModel();
        }
        throw new DeploymentException("No BPEL Process with local-name '" + this.bpelName + "' found in deployment.");
    }

    private IProcess getProcessForConfiguredQName(List<? extends IBPELProcess> processes, QName qname) throws DeploymentException {
        for (IBPELProcess iBPELProcess : processes) {
            if (!qname.equals(iBPELProcess.getName())) continue;
            return iBPELProcess.getProcessModel();
        }
        throw new DeploymentException("No BPEL Process with qname '" + qname + "' found in deployment.");
    }

    private void checkIsSet(String option, String value) throws DeploymentException {
        if (value == null) {
            throw new DeploymentException("Option " + option + " is mandatory but not set for Wait Mocking");
        }
    }
}

