/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.deploy.activevos9;

import com.activeEndpoints.schemas.catalog.x2006.x07.catalog.CatalogDocument;
import com.activeEndpoints.schemas.catalog.x2006.x07.catalog.WsdlEntryType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.bpelunit.framework.control.deploy.AbstractDeployment;
import net.bpelunit.framework.control.deploy.IBPELProcess;
import net.bpelunit.framework.control.soap.NamespaceContextImpl;
import net.bpelunit.framework.control.util.XPathTool;
import net.bpelunit.framework.exception.DeploymentException;
import net.bpelunit.model.bpel.BpelFactory;
import net.bpelunit.model.bpel.IProcess;
import net.bpelunit.util.FileUtil;
import net.bpelunit.util.XMLUtil;
import net.bpelunit.util.ZipUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveVOS9Deployment
extends AbstractDeployment {
    private static final String CATALOG_FILENAME = "META-INF/catalog.xml";
    private File bpr;
    private File tempDirectory = null;
    private File tempBPR = null;
    CatalogDocument catalogDoc = null;
    private List<BPELInfo> allProcesses = new ArrayList<BPELInfo>();
    public static final String NAMESPACE_PDD = "http://schemas.active-endpoints.com/pdd/2006/08/pdd.xsd";

    public ActiveVOS9Deployment(File bpr) throws DeploymentException {
        if (!bpr.isFile() || !bpr.canRead()) {
            throw new DeploymentException("The given BPR does not exist or cannot be read:" + bpr.getAbsolutePath());
        }
        this.bpr = bpr;
    }

    public List<IBPELProcess> getBPELProcesses() throws DeploymentException {
        this.extractBPRIfNecessary();
        return new ArrayList<IBPELProcess>(this.allProcesses);
    }

    InputStream getUpdatedDeployment() throws DeploymentException {
        if (this.tempDirectory != null) {
            try {
                for (BPELInfo bpel : this.allProcesses) {
                    bpel.writeOut();
                }
                this.catalogDoc.save(new File(this.tempDirectory, CATALOG_FILENAME));
                this.tempBPR = File.createTempFile(this.bpr.getName(), ".bpr");
                ZipUtil.zipDirectory((File)this.tempDirectory, (File)this.tempBPR);
                return new FileInputStream(this.tempBPR);
            }
            catch (Exception e) {
                throw new DeploymentException("Error while repackaging BPR", e);
            }
        }
        try {
            return new FileInputStream(this.bpr);
        }
        catch (FileNotFoundException e) {
            throw new DeploymentException("BPR does not exist: " + this.bpr.getAbsolutePath(), (Exception)e);
        }
    }

    void cleanUp() throws DeploymentException {
        if (this.tempBPR != null) {
            this.tempBPR.delete();
            this.tempBPR = null;
        }
        if (this.tempDirectory != null) {
            try {
                FileUtils.deleteDirectory((File)this.tempDirectory);
                this.tempDirectory = null;
            }
            catch (IOException e) {
                throw new DeploymentException("Cannot delete temp directory: " + this.tempDirectory.getAbsolutePath(), (Exception)e);
            }
        }
    }

    private synchronized void extractBPRIfNecessary() throws DeploymentException {
        if (this.tempDirectory == null) {
            try {
                this.tempDirectory = FileUtil.createTempDirectory();
                ZipUtil.unzipFile((File)this.bpr, (File)this.tempDirectory);
                this.catalogDoc = CatalogDocument.Factory.parse(new File(this.tempDirectory, CATALOG_FILENAME));
                this.scanForBPELFiles();
            }
            catch (IOException e) {
                throw new DeploymentException("Error while temporarily extracting the BPR: " + e.getMessage(), (Exception)e);
            }
            catch (XmlException e) {
                throw new DeploymentException("Error while parsing XML (catalog.xml): " + e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    private void scanForBPELFiles() throws DeploymentException {
        Iterator pddFiles = FileUtils.iterateFiles((File)this.tempDirectory, (String[])new String[]{"pdd"}, (boolean)true);
        while (pddFiles.hasNext()) {
            File pddFile = (File)pddFiles.next();
            try {
                Document pddXml = XMLUtil.parseXML((InputStream)new FileInputStream(pddFile));
                Element pddRoot = pddXml.getDocumentElement();
                String locationInBPR = pddRoot.getAttribute("location");
                File bpelFile = new File(this.tempDirectory, locationInBPR);
                this.allProcesses.add(new BPELInfo(bpelFile, pddFile, pddXml));
            }
            catch (FileNotFoundException e) {
                throw new DeploymentException("File could not be read: " + e.getMessage(), (Exception)e);
            }
            catch (SAXException e) {
                throw new DeploymentException("XML file could not be parsed: " + e.getMessage(), (Exception)e);
            }
            catch (IOException e) {
                throw new DeploymentException("XML file could not be read: " + e.getMessage(), (Exception)e);
            }
            catch (ParserConfigurationException e) {
                throw new DeploymentException("XML file could not be parsed: " + e.getMessage(), (Exception)e);
            }
            catch (JAXBException e) {
                throw new DeploymentException("BPEL file could not be parsed: " + e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    XPathTool createXPathToolForPdd() {
        NamespaceContextImpl nsc = new NamespaceContextImpl();
        nsc.setNamespace("pdd", NAMESPACE_PDD);
        nsc.setNamespace("wsa", "http://www.w3.org/2005/08/addressing");
        XPathTool xpath = new XPathTool((NamespaceContext)nsc);
        return xpath;
    }

    final class BPELInfo
    implements IBPELProcess {
        private static final String PATH_TO_BPELUNIT_ADDED_FILES = "wsdl/bpelunit/";
        private File bpelFile;
        private File pddFile;
        private QName name;
        private IProcess bpelModel;
        private Document pddXml;
        private boolean pddHasChanged = false;
        private boolean bpelHasChanged = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        BPELInfo(File bpelFile, File pddFile, Document pdd) throws FileNotFoundException, JAXBException {
            this.bpelFile = bpelFile;
            this.pddFile = pddFile;
            FileInputStream in = null;
            try {
                in = new FileInputStream(bpelFile);
                this.bpelModel = BpelFactory.loadProcess((InputStream)in);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            this.name = new QName(this.bpelModel.getTargetNamespace(), this.bpelModel.getName());
            this.pddXml = pdd;
        }

        public QName getName() {
            return this.name;
        }

        public void addWSDLImport(String wsdlFileName, String namespace, InputStream contents) throws DeploymentException {
            String classpath = PATH_TO_BPELUNIT_ADDED_FILES + wsdlFileName;
            String catalogLocation = ActiveVOS9Deployment.this.catalogDoc.getCatalog().getURI() + "/" + PATH_TO_BPELUNIT_ADDED_FILES + wsdlFileName;
            this.addFileToExplodedBPR(wsdlFileName, contents);
            this.addCatalogEntryIfNecessary(catalogLocation, classpath);
        }

        String calculateRelativePathTo(String wsdlFileName) {
            int pathElementsInTempDirectory = StringUtils.countMatches((String)ActiveVOS9Deployment.this.tempDirectory.getAbsolutePath().replaceAll("\\\\", "/"), (String)"/");
            int pathElementsInBPELFile = StringUtils.countMatches((String)this.bpelFile.getAbsolutePath().replaceAll("\\\\", "/"), (String)"/");
            StringBuilder relativePath = new StringBuilder();
            for (int i = 0; i < pathElementsInBPELFile - pathElementsInTempDirectory - 1; ++i) {
                relativePath.append("../");
            }
            relativePath.append(PATH_TO_BPELUNIT_ADDED_FILES);
            relativePath.append(wsdlFileName);
            return relativePath.toString();
        }

        private void addFileToExplodedBPR(String wsdlFileName, InputStream contents) throws DeploymentException {
            File bpelUnitOutputDir = new File(ActiveVOS9Deployment.this.tempDirectory, PATH_TO_BPELUNIT_ADDED_FILES);
            bpelUnitOutputDir.mkdirs();
            File outputFile = new File(bpelUnitOutputDir, wsdlFileName);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(outputFile);
            }
            catch (FileNotFoundException e) {
                throw new DeploymentException("Could not write WSDL: " + e.getMessage(), (Exception)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)contents);
                IOUtils.closeQuietly((OutputStream)out);
            }
        }

        private void addCatalogEntryIfNecessary(String location, String classpath) {
            boolean found = false;
            for (WsdlEntryType w : ActiveVOS9Deployment.this.catalogDoc.getCatalog().getWsdlEntryArray()) {
                if (!location.equals(w.getLocation())) continue;
                found = true;
                break;
            }
            if (!found) {
                WsdlEntryType wsdlEntry = ActiveVOS9Deployment.this.catalogDoc.getCatalog().addNewWsdlEntry();
                wsdlEntry.setClasspath(classpath);
                wsdlEntry.setLocation(location);
            }
        }

        public void addXSDImport(String xsdFileName, String namespace, InputStream contents) {
        }

        public IProcess getProcessModel() {
            this.bpelHasChanged = true;
            return this.bpelModel;
        }

        Document getPddXml() {
            this.pddHasChanged = true;
            return this.pddXml;
        }

        public void addPartnerlink(String name, QName partnerlinkType, String processRole, String partnerRole, QName service, String port, String endpointURL) {
            this.getPddXml();
            this.getProcessModel();
        }

        public void changePartnerEndpoint(String partnerLinkName, String newEndpoint) throws DeploymentException {
            XPathTool xpathPdd = ActiveVOS9Deployment.this.createXPathToolForPdd();
            Element pddRoot = this.getPddXml().getDocumentElement();
            try {
                List address = xpathPdd.evaluateAsList("//pdd:partnerLinks/pdd:partnerLink[@name='" + partnerLinkName + "']/pdd:partnerRole/wsa:EndpointReference/wsa:Address", (Object)pddRoot);
                ((Node)address.get(0)).setTextContent(newEndpoint);
                List endpointReference = xpathPdd.evaluateAsList("//pdd:partnerLinks/pdd:partnerLink[@name='" + partnerLinkName + "']/pdd:partnerRole/@endpointReference", (Object)pddRoot);
                ((Node)endpointReference.get(0)).setNodeValue("static");
                List invokeHandler = xpathPdd.evaluateAsList("//pdd:partnerLinks/pdd:partnerLink[@name='" + partnerLinkName + "']/pdd:partnerRole/@invokeHandler", (Object)pddRoot);
                ((Node)invokeHandler.get(0)).setNodeValue("default:Address");
            }
            catch (Exception e) {
                throw new DeploymentException("Cannot change partner endpoint location for " + partnerLinkName, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeOut() throws IOException, TransformerException {
            if (this.bpelHasChanged) {
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(this.bpelFile);
                    this.bpelModel.save((OutputStream)out, new Class[0]);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
            if (this.pddHasChanged) {
                XMLUtil.writeXML((Node)this.getPddXml(), (File)this.pddFile);
            }
        }
    }
}

