/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.deploy.activevos9;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import net.bpelunit.framework.control.deploy.activevos9.IBPELProcess;
import net.bpelunit.framework.control.deploy.activevos9.IDeployment;
import net.bpelunit.framework.exception.DeploymentException;
import net.bpelunit.util.FileUtil;
import net.bpelunit.util.XMLUtil;
import net.bpelunit.util.ZipUtil;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActiveVOS9Deployment
implements IDeployment {
    private File bpr;
    private File tempDirectory = null;
    private File tempBPR = null;
    private Set<BPELInfo> checkedOutProcesses = new HashSet<BPELInfo>();
    private List<BPELInfo> allProcesses = new ArrayList<BPELInfo>();
    private List<QName> bpelNames = new ArrayList<QName>();

    public ActiveVOS9Deployment(File bpr) throws DeploymentException {
        if (!bpr.isFile() || !bpr.canRead()) {
            throw new DeploymentException("The given BPR does not exist or cannot be read:" + bpr.getAbsolutePath());
        }
        this.bpr = bpr;
    }

    public List<IBPELProcess> getBPELProcesses() {
        return new ArrayList<IBPELProcess>(this.allProcesses);
    }

    InputStream getUpdatedDeployment() throws DeploymentException {
        if (this.tempDirectory != null) {
            try {
                for (BPELInfo bpel : this.checkedOutProcesses) {
                    XMLUtil.writeXML(bpel.xml, bpel.bpelFile);
                }
                this.tempBPR = File.createTempFile(this.bpr.getName(), ".bpr");
                ZipUtil.zipDirectory(this.tempDirectory, this.tempBPR);
                return new FileInputStream(this.tempBPR);
            }
            catch (Exception e) {
                throw new DeploymentException("Error while repackaging BPR", e);
            }
        }
        try {
            return new FileInputStream(this.bpr);
        }
        catch (FileNotFoundException e) {
            throw new DeploymentException("BPR does not exist: " + this.bpr.getAbsolutePath(), (Exception)e);
        }
    }

    void cleanUp() throws DeploymentException {
        if (this.tempBPR != null) {
            this.tempBPR.delete();
        }
        if (this.tempDirectory != null) {
            try {
                FileUtils.deleteDirectory((File)this.tempDirectory);
            }
            catch (IOException e) {
                throw new DeploymentException("Cannot delete temp directory: " + this.tempDirectory.getAbsolutePath(), (Exception)e);
            }
        }
    }

    private synchronized void extractBPRIfNecessary() throws DeploymentException {
        if (this.tempDirectory != null) {
            try {
                this.tempDirectory = FileUtil.createTempDirectory();
                ZipUtil.unzipFile(this.bpr, this.tempDirectory);
                this.scanForBPELFiles();
            }
            catch (IOException e) {
                throw new DeploymentException("Error while temporarily extracting the BPR: " + e.getMessage(), (Exception)e);
            }
        }
    }

    private void scanForBPELFiles() throws DeploymentException {
        Iterator bpelFiles = FileUtils.iterateFiles((File)this.tempDirectory, (String[])new String[]{"bpel"}, (boolean)true);
        while (bpelFiles.hasNext()) {
            File bpelFile = (File)bpelFiles.next();
            try {
                Document d = XMLUtil.parseXML(new FileInputStream(bpelFile));
                Element root = d.getDocumentElement();
                QName name = new QName(root.getAttribute("targetNamespace"), root.getAttribute("name"));
                this.allProcesses.add(new BPELInfo(bpelFile, null, name, d));
            }
            catch (FileNotFoundException e) {
                throw new DeploymentException("File could not be read: " + bpelFile.getAbsolutePath(), (Exception)e);
            }
            catch (SAXException e) {
                throw new DeploymentException("BPEL file could not be parsed: " + bpelFile.getAbsolutePath(), (Exception)e);
            }
            catch (IOException e) {
                throw new DeploymentException("BPEL file could not be parsed: " + bpelFile.getAbsolutePath(), (Exception)e);
            }
            catch (ParserConfigurationException e) {
                throw new DeploymentException("BPEL file could not be parsed: " + bpelFile.getAbsolutePath(), (Exception)e);
            }
        }
    }

    private class BPELInfo
    implements IBPELProcess {
        File bpelFile;
        File pddFile;
        QName name;
        Document xml;

        BPELInfo(File bpelFile, File pddFile, QName name, Document xml) {
            this.bpelFile = bpelFile;
            this.pddFile = pddFile;
            this.name = name;
            this.xml = xml;
        }

        public QName getName() {
            return this.name;
        }

        public void addWSDLImport(String wsdlFileName, InputStream contents) {
        }

        public void addPartnerlink(String name, QName partnerlinkType, String processRole, String partnerRole) {
        }

        public Document getXML() {
            ActiveVOS9Deployment.this.checkedOutProcesses.add(this);
            return this.xml;
        }

        public void addPartnerlinkBinding(String partnerlinkName, QName service, String port, String endpointURL) {
        }
    }
}

