/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.test.unit;

import net.bpelunit.framework.control.soap.NamespaceContextImpl;
import net.bpelunit.framework.model.test.data.ReceiveCondition;
import net.bpelunit.test.unit.SimpleTest;
import net.bpelunit.test.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Element;

public class TestConditionChecker
extends SimpleTest {
    private static final String PATH_TO_FILES = "/condition/";

    private ReceiveCondition eval(String eval, String result) throws Exception {
        Element parent = TestUtil.readLiteralData("/condition/simple.xmlfrag");
        ReceiveCondition c = new ReceiveCondition(null, eval, null, result);
        NamespaceContextImpl ns = new NamespaceContextImpl();
        ns.setNamespace("soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
        ns.setNamespace("b", "http://xmlns.oracle.com/AirlineReservationSync");
        c.evaluate(null, parent, ns, null);
        return c;
    }

    @Test
    public void testBooleanOK() throws Exception {
        ReceiveCondition c = this.eval("b:AirlineReservationSyncProcessResponse/b:result/text()", "'false'");
        Assert.assertFalse((c.isError() || c.isFailure() ? 1 : 0) != 0);
    }

    @Test
    public void testTextNode() throws Exception {
        ReceiveCondition c = this.eval("b:AirlineReservationSyncProcessResponse/b:bookingNumber/text()", "'589588'");
        Assert.assertFalse((c.isError() || c.isFailure() ? 1 : 0) != 0);
    }

    @Test
    public void testAttribute() throws Exception {
        ReceiveCondition c = this.eval("b:AirlineReservationSyncProcessResponse/b:result/@some", "'Hallo'");
        Assert.assertFalse((c.isError() || c.isFailure() ? 1 : 0) != 0);
    }

    @Test
    public void testWrongXPath() throws Exception {
        ReceiveCondition c = this.eval("b:AirlineReservationSyncProcessResponse/b:result@some", "'Hallo'");
        Assert.assertTrue((boolean)c.isError());
    }

    @Test
    public void testFail() throws Exception {
        ReceiveCondition c = this.eval("b:AirlineReservationSyncProcessResponse/b:result/@some", "'Lulu'");
        Assert.assertTrue((boolean)c.isFailure());
    }
}

