/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.verify;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.verify.ITestSuiteValidator;
import net.bpelunit.framework.xml.suite.XMLConditionGroup;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.framework.xml.suite.XMLTestSuiteDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoCyclesInConditionGroupInheritanceValidator
implements ITestSuiteValidator {
    @Override
    public void validate(XMLTestSuiteDocument suite) throws SpecificationException {
        Map<String, XMLConditionGroup> conditionGroups = this.extractConditionGroups(suite.getTestSuite());
        this.findCyclesInConditionGroups(conditionGroups);
    }

    private Map<String, XMLConditionGroup> extractConditionGroups(XMLTestSuite suite) {
        HashMap<String, XMLConditionGroup> cgs = new HashMap<String, XMLConditionGroup>();
        if (suite.getConditionGroups() != null && suite.getConditionGroups().getConditionGroupList() != null) {
            for (XMLConditionGroup cg : suite.getConditionGroups().getConditionGroupList()) {
                cgs.put(cg.getName(), cg);
            }
        }
        return cgs;
    }

    private void findCyclesInConditionGroups(Map<String, XMLConditionGroup> conditionGroups) throws SpecificationException {
        for (XMLConditionGroup cg : conditionGroups.values()) {
            this.findCycleInConditionGroup(cg, conditionGroups);
        }
    }

    private void findCycleInConditionGroup(XMLConditionGroup cgToCheck, Map<String, XMLConditionGroup> conditionGroups) throws SpecificationException {
        HashSet<XMLConditionGroup> parents = new HashSet<XMLConditionGroup>();
        XMLConditionGroup cg = cgToCheck;
        while (cg.getInheritFrom() != null) {
            parents.add(cg);
            String cgName = cg.getName();
            String cgParentName = cg.getInheritFrom();
            cg = conditionGroups.get(cgParentName);
            if (cg == null) {
                throw new SpecificationException("Could not resolve condition group " + cgParentName + " that is referenced from condition group " + cgName);
            }
            if (!parents.contains(cg)) continue;
            throw new SpecificationException("The Condition Group " + cgToCheck.getName() + " has cyclic inheritance");
        }
    }
}

