/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model.test.data;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.bpelunit.framework.control.ext.ISOAPEncoder;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.exception.HeaderProcessingException;
import net.bpelunit.framework.exception.SOAPEncodingException;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.model.test.activity.Activity;
import net.bpelunit.framework.model.test.activity.ActivityContext;
import net.bpelunit.framework.model.test.data.ContextXPathVariableResolver;
import net.bpelunit.framework.model.test.data.DataCopyOperation;
import net.bpelunit.framework.model.test.data.DataSpecification;
import net.bpelunit.framework.model.test.data.SOAPOperationCallIdentifier;
import net.bpelunit.framework.model.test.data.XMLData;
import net.bpelunit.framework.model.test.report.ArtefactStatus;
import net.bpelunit.framework.model.test.report.ITestArtefact;
import net.bpelunit.framework.model.test.report.StateData;
import org.apache.log4j.Logger;
import org.apache.velocity.context.Context;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendDataSpecification
extends DataSpecification {
    private SOAPOperationCallIdentifier fOperation;
    private String fEncodingStyle;
    private ISOAPEncoder fEncoder;
    private String fPlainMessage;
    private SOAPMessage fSOAPMessage;
    private Element fLiteralData;
    private String fSOAPHTTPAction;
    private String fTargetURL;
    private int fDelay;
    private String fDelayExpression;
    private QName fFaultCode;
    private String fFaultString;
    private String fDataTemplate;
    private Map<String, String> protocolOptions = new HashMap<String, String>();

    public SendDataSpecification(Activity parent, NamespaceContext nsContext) throws SpecificationException {
        super(parent, nsContext);
    }

    public void initialize(SOAPOperationCallIdentifier operation, int delay, String delayExpression, String targetURL, String soapAction, String encodingStyle, ISOAPEncoder encoder, Element rawDataRoot, String dataTemplate, QName faultCode, String faultString) {
        this.fOperation = operation;
        this.fLiteralData = rawDataRoot;
        this.fDataTemplate = dataTemplate;
        this.fSOAPHTTPAction = soapAction;
        this.fTargetURL = targetURL;
        this.fEncodingStyle = encodingStyle;
        this.fEncoder = encoder;
        this.setDelay(delay);
        this.setDelayExpression(delayExpression);
        this.fFaultCode = faultCode;
        this.fFaultString = faultString;
    }

    public void handle(ActivityContext context) {
        if (this.fDataTemplate != null) {
            this.generateLiteralDataFromTemplate(context);
        }
        if (this.hasProblems()) {
            return;
        }
        this.insertMappingData(context);
        this.encodeMessage();
        if (this.hasProblems()) {
            return;
        }
        try {
            context.processHeaders(this);
        }
        catch (HeaderProcessingException e) {
            this.fStatus = ArtefactStatus.createErrorStatus("Header Processing Fault.", e);
            return;
        }
        if (this.hasProblems()) {
            return;
        }
        this.createWireFormat();
        if (this.hasProblems()) {
            return;
        }
        this.fStatus = ArtefactStatus.createPassedStatus();
    }

    private void generateLiteralDataFromTemplate(ActivityContext context) {
        try {
            String expandedTemplate = this.expandTemplateToString(context, this.fDataTemplate);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document docExpanded = dbf.newDocumentBuilder().parse(new InputSource(new StringReader(expandedTemplate)));
            this.fLiteralData = docExpanded.getDocumentElement();
            context.saveSentMessage(this.fLiteralData);
        }
        catch (Exception ex) {
            this.fStatus = ArtefactStatus.createErrorStatus("Template expansion fault: " + ex.getLocalizedMessage(), ex);
        }
    }

    public void delay(ActivityContext context) throws Exception {
        if (this.getDelay(context) > 0) {
            Logger.getLogger(this.getClass()).info("Delaying send for " + this.getDelay(context) + " seconds...");
            Thread.sleep(this.getDelay(context) * 1000);
        }
    }

    public String getTargetURL() {
        return this.fTargetURL;
    }

    public void setTargetURL(String targetURL) {
        this.fTargetURL = targetURL;
    }

    public String getSOAPHTTPAction() {
        return this.fSOAPHTTPAction;
    }

    public SOAPMessage getSOAPMessage() {
        return this.fSOAPMessage;
    }

    public String getInWireFormat() {
        return this.fPlainMessage;
    }

    public boolean isFault() {
        return this.fOperation.isFault();
    }

    public void setDelay(int fDelay) {
        this.fDelay = fDelay;
    }

    public int getDelay(ActivityContext activityContext) throws Exception {
        if (this.getDelayExpression() != null) {
            Context vtlContext = activityContext.createVelocityContext();
            ContextXPathVariableResolver xpathResolver = new ContextXPathVariableResolver(vtlContext);
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(this.fNamespaceContext);
            xpath.setXPathVariableResolver(xpathResolver);
            this.fDelay = ((Double)xpath.evaluate(this.getDelayExpression(), this.fLiteralData, XPathConstants.NUMBER)).intValue();
            this.setDelayExpression(null);
        }
        return this.fDelay;
    }

    public void setDelayExpression(String fDelayExpression) {
        this.fDelayExpression = fDelayExpression;
    }

    public String getDelayExpression() {
        return this.fDelayExpression;
    }

    private void insertMappingData(ActivityContext context) {
        List<DataCopyOperation> mapping = context.getMapping();
        if (mapping != null) {
            for (DataCopyOperation copy : mapping) {
                copy.setTextNodes(this.fLiteralData, this.fNamespaceContext);
                if (!copy.isError()) continue;
                this.fStatus = ArtefactStatus.createErrorStatus("An error occurred while evaluating Copy-To-XPath expression.");
                return;
            }
        }
    }

    private void encodeMessage() {
        try {
            this.fSOAPMessage = this.fEncoder.construct(this.fOperation, this.fLiteralData, this.fFaultCode, this.fFaultString);
        }
        catch (SOAPEncodingException e) {
            this.fStatus = ArtefactStatus.createErrorStatus("Encoding the message failed: " + e.getMessage(), e);
        }
    }

    private void createWireFormat() {
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            this.fSOAPMessage.writeTo((OutputStream)b);
            this.fPlainMessage = b.toString();
        }
        catch (Exception e) {
            this.fStatus = ArtefactStatus.createErrorStatus("Error serializing SOAP message: " + e.getMessage(), e);
        }
    }

    private String getWireFormatAsString() {
        if (this.fPlainMessage != null) {
            return this.fPlainMessage;
        }
        return "(no data)";
    }

    private String getLiteralDataAsString() {
        if (this.fLiteralData != null) {
            return BPELUnitUtil.toFormattedString(this.fLiteralData.getOwnerDocument());
        }
        return "(no data)";
    }

    private String getSOAPMessageDataAsString() {
        if (this.fSOAPMessage != null) {
            return BPELUnitUtil.toFormattedString((Document)this.fSOAPMessage.getSOAPPart());
        }
        return "(no message)";
    }

    @Override
    public String getName() {
        return "Send Data Package";
    }

    @Override
    public List<ITestArtefact> getChildren() {
        ArrayList<ITestArtefact> returner = new ArrayList<ITestArtefact>();
        returner.add(new XMLData(this, "Literal XML data", this.getLiteralDataAsString()));
        returner.add(new XMLData(this, "SOAP Message data", this.getSOAPMessageDataAsString()));
        returner.add(new XMLData(this, "Plain outgoing message", this.getWireFormatAsString()));
        return returner;
    }

    @Override
    public List<StateData> getStateData() {
        ArrayList<StateData> stateData = new ArrayList<StateData>();
        stateData.addAll(this.fStatus.getAsStateData());
        if (this.fTargetURL != null) {
            stateData.add(new StateData("Target URL", this.fTargetURL));
            stateData.add(new StateData("HTTP Action", this.fSOAPHTTPAction));
        }
        stateData.add(new StateData("Style/Encoding", this.fEncodingStyle));
        stateData.add(new StateData("Direction", this.fOperation.getDirection().name()));
        return stateData;
    }

    public void putProtocolOption(String name, String value) {
        this.protocolOptions.put(name, value);
    }

    public String getProtocolOption(String name) {
        return this.protocolOptions.get(name);
    }

    public String[] getProtocolOptionNames() {
        return this.protocolOptions.keySet().toArray(new String[this.protocolOptions.size()]);
    }
}

