/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bpelunit.framework.BPELUnitRunner;
import net.bpelunit.framework.control.ext.DeploymentOption;
import net.bpelunit.framework.control.ext.IBPELDeployer;
import net.bpelunit.framework.control.ext.IDeployment;
import net.bpelunit.framework.control.ext.PartnerLink;
import net.bpelunit.framework.control.util.ExtensionRegistry;
import net.bpelunit.framework.coverage.ArchiveUtil;
import net.bpelunit.framework.coverage.ICoverageMeasurementTool;
import net.bpelunit.framework.exception.DeploymentException;
import net.bpelunit.framework.exception.EndPointException;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.model.Partner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessUnderTest
extends Partner {
    private IBPELDeployer fDeployer;
    private List<DeploymentOption> fXMLDeploymentOptions;
    private boolean isDeployed;
    private Map<String, String> fGlobalConfiguration = new HashMap<String, String>();
    private Map<String, Partner> fPartners;
    private String fDeploymentURL;

    public ProcessUnderTest(String name, String testBasePath, String wsdlFile, String partnerWSDLFile, String baseURL) throws SpecificationException {
        super(name, testBasePath, wsdlFile, partnerWSDLFile, baseURL);
        this.fXMLDeploymentOptions = new ArrayList<DeploymentOption>();
    }

    public void setDeployer(IBPELDeployer deployer) {
        this.fDeployer = deployer;
    }

    public void deploy() throws DeploymentException {
        if (BPELUnitRunner.changeEndpoints()) {
            IDeployment deployment = this.fDeployer.getDeployment(this);
            PartnerLink[] partnerLinks = deployment.getPartnerLinks();
            Partner[] partners = this.fPartners.values().toArray(new Partner[0]);
            Map<Partner, PartnerLink> linkMap = this.getLinkMapping(partners, partnerLinks);
            try {
                for (Partner p : linkMap.keySet()) {
                    PartnerLink pl = linkMap.get(p);
                    deployment.replaceEndpoints(pl, p);
                }
            }
            catch (EndPointException e) {
                throw new DeploymentException("Error in changing endpoints.", e);
            }
        }
        boolean archiveCopied = false;
        String newFile = null;
        if (BPELUnitRunner.measureTestCoverage()) {
            ICoverageMeasurementTool coverageTool = BPELUnitRunner.getCoverageMeasurmentTool();
            try {
                newFile = coverageTool.prepareArchiveForCoverageMeasurement(this.fDeployer.getArchiveLocation(this.getBasePath()), this, this.fDeployer);
                this.fDeployer.setArchiveLocation(newFile);
                archiveCopied = true;
            }
            catch (Exception e) {
                coverageTool.setErrorStatus("Coverage measurmetn is failed. An error occurred when annotation for coverage: " + e.getMessage());
            }
        }
        this.fDeployer.deploy(this.getBasePath(), this);
        if (archiveCopied) {
            ArchiveUtil.deleteArchive(newFile);
        }
        this.isDeployed = true;
    }

    private void configureDeployer() {
        HashMap<String, String> options = new HashMap<String, String>();
        Collection<String> keys = ExtensionRegistry.getPossibleConfigurationOptions(this.fDeployer.getClass(), true);
        for (String key : keys) {
            String value = this.getDeploymentOption(key);
            if (value == null) {
                value = this.fGlobalConfiguration.get(key);
            }
            options.put(key, value);
        }
        ExtensionRegistry.configureDeployer(this.fDeployer, options);
    }

    public void undeploy() throws DeploymentException {
        this.fDeployer.undeploy(this.getBasePath(), this);
        this.isDeployed = false;
    }

    public boolean isDeployed() {
        return this.isDeployed;
    }

    public void setXMLDeploymentOption(String name, String stringValue) {
        this.fXMLDeploymentOptions.add(new DeploymentOption(name, stringValue));
    }

    public String getDeploymentOption(String key) {
        if (key == null) {
            return null;
        }
        for (DeploymentOption option : this.fXMLDeploymentOptions) {
            if (!key.equals(option.getKey())) continue;
            return option.getValue();
        }
        return null;
    }

    public IBPELDeployer getDeployer() {
        return this.fDeployer;
    }

    public void setGlobalConfiguration(Map<String, String> globalConfiguration) {
        this.fGlobalConfiguration = globalConfiguration != null ? globalConfiguration : new HashMap<String, String>();
        this.configureDeployer();
    }

    public void setPartners(Map<String, Partner> partners) {
        this.fPartners = partners;
    }

    public Map<String, Partner> getPartners() {
        return this.fPartners;
    }

    public void setDeploymentURL(String url) {
        this.fDeploymentURL = url;
    }

    public String getDeploymentURL() {
        return this.fDeploymentURL;
    }

    public Map<Partner, PartnerLink> getLinkMapping(Partner[] partners, PartnerLink[] partnerLinks) {
        HashMap<Partner, PartnerLink> linkMap = new HashMap<Partner, PartnerLink>();
        block0: for (Partner p : partners) {
            for (PartnerLink pl : partnerLinks) {
                if (!p.getName().equals(pl.getName())) continue;
                linkMap.put(p, pl);
                continue block0;
            }
        }
        return linkMap;
    }

    public void cleanUpAfterTestCase() throws Exception {
        this.fDeployer.cleanUpAfterTestCase();
    }
}

