/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.model;

import java.io.File;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import net.bpelunit.framework.exception.SpecificationException;
import net.bpelunit.framework.model.AbstractPartner;
import net.bpelunit.framework.model.test.data.SOAPOperationCallIdentifier;
import net.bpelunit.framework.model.test.data.SOAPOperationDirectionIdentifier;

public class Partner
extends AbstractPartner {
    private String fPathToWSDL;
    private String fPathToPartnerWSDL;
    private Definition fWSDLDefinition;
    private Definition fPartnerWSDLDefinition;

    public Partner(String name, String testBasePath, String wsdlName, String partnerWSDLName, String baseURL) throws SpecificationException {
        super(name, testBasePath, baseURL);
        this.fPathToWSDL = testBasePath + wsdlName;
        this.fWSDLDefinition = this.loadWsdlDefinition(this.fPathToWSDL);
        if (partnerWSDLName != null && !"".equals(partnerWSDLName)) {
            this.fPathToPartnerWSDL = testBasePath + partnerWSDLName;
            this.fPartnerWSDLDefinition = this.loadWsdlDefinition(this.fPathToPartnerWSDL);
        }
    }

    private Definition loadWsdlDefinition(String wsdlFileName) throws SpecificationException {
        if (!new File(wsdlFileName).exists()) {
            throw new SpecificationException("Cannot read WSDL file for partner " + this.getName() + ": File \"" + wsdlFileName + "\" not found.");
        }
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            return reader.readWSDL(wsdlFileName);
        }
        catch (WSDLException e) {
            throw new SpecificationException("Error while reading WSDL for partner " + this.getName() + " from file \"" + wsdlFileName + "\".", e);
        }
    }

    public SOAPOperationCallIdentifier getOperation(QName service, String port, String operationName, SOAPOperationDirectionIdentifier direction) throws SpecificationException {
        Service serviceDef = this.fWSDLDefinition.getService(service);
        Definition definition = this.fWSDLDefinition;
        if (serviceDef == null && this.fPartnerWSDLDefinition != null) {
            serviceDef = this.fPartnerWSDLDefinition.getService(service);
            definition = this.fPartnerWSDLDefinition;
        }
        return new SOAPOperationCallIdentifier(definition, service, port, operationName, direction);
    }
}

