/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.annotation.metrics.linkcoverage;

import java.util.Iterator;
import java.util.List;
import net.bpelunit.framework.coverage.annotation.metrics.IMetricHandler;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.BpelXMLTools;
import net.bpelunit.framework.coverage.exceptions.BpelException;
import net.bpelunit.framework.coverage.receiver.MarkersRegisterForArchive;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.filter.ElementFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkMetricHandler
implements IMetricHandler {
    public static final String METRIC_NAME = "LinkMetric";
    public static final String LINK_TAG = "link";
    public static final String LINKS_TAG = "links";
    private static final String SOURCE_TAG = "source";
    private static final String TARGET_TAG = "target";
    private static final String TARGETS_TAG = "targets";
    private static final String TRANSITION_CONDITION = "transitionCondition";
    private static final String ATTRIBUTE_LINKNAME = "linkName";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String COPY_LINK_POSTFIX = "_copy";
    private static final String COPY_LINK_NEGIERT_POSTFIX = "_negiert";
    public static final String NEGATIV_LINK_LABEL = "negativLinks";
    public static final String POSITIV_LINK_LABEL = "positivLinks";
    private MarkersRegisterForArchive markersRegistry;

    public LinkMetricHandler(MarkersRegisterForArchive markersRegistry) {
        this.markersRegistry = markersRegistry;
    }

    public static String getNextPositivLinkMarker() {
        return "positivLinks_" + BpelXMLTools.count++;
    }

    public static String getNextNegativLinkMarker() {
        return "negativLinks_" + BpelXMLTools.count++;
    }

    @Override
    public void insertMarkersForMetric(List<Element> processElements) throws BpelException {
        Iterator<Element> iter = processElements.iterator();
        while (iter.hasNext()) {
            this.loggingOfLinks2(iter.next(), BpelXMLTools.process_element);
        }
    }

    private void loggingOfLinks2(Element link, Element processElement) {
        Element sourceElement = this.searchSourceElement2(link, processElement);
        String transitionCondition = this.checkTransitionCondition(sourceElement);
        if (!(transitionCondition.equals("") || transitionCondition.equals("true()") || transitionCondition.equals("false()"))) {
            this.createMarkerForLink2(link, sourceElement, transitionCondition);
        }
    }

    private void createMarkerForLink2(Element link, Element sourceElement, String transitionCondition) {
        Element sourceActivity = null;
        if (BpelXMLTools.getProcessNamespace().equals(BpelXMLTools.NAMESPACE_BPEL_2_0)) {
            sourceActivity = sourceElement.getParentElement().getParentElement();
        } else if (BpelXMLTools.getProcessNamespace().equals(BpelXMLTools.NAMESPACE_BPEL_1_1)) {
            sourceActivity = sourceElement.getParentElement();
        }
        Element enclosedFlow = BpelXMLTools.encloseElementInFlow(sourceActivity);
        Element new_link = this.insertPostivLink(enclosedFlow, sourceElement, link, transitionCondition);
        this.insertLoggingMarker(new_link, enclosedFlow, true);
        new_link = this.insertNegativLink(enclosedFlow, sourceElement, link, transitionCondition);
        this.insertLoggingMarker(new_link, enclosedFlow, false);
    }

    private String checkTransitionCondition(Element sourceElement) {
        Namespace ns = BpelXMLTools.getProcessNamespace();
        String transitionCondition = "";
        if (ns.equals(BpelXMLTools.NAMESPACE_BPEL_2_0)) {
            Element transConElement = sourceElement.getChild(TRANSITION_CONDITION, ns);
            if (transConElement != null) {
                transitionCondition = transConElement.getText();
            }
        } else if (ns.equals(BpelXMLTools.NAMESPACE_BPEL_1_1) && (transitionCondition = sourceElement.getAttributeValue(TRANSITION_CONDITION)) == null) {
            transitionCondition = "";
        }
        return transitionCondition.trim();
    }

    private Element searchSourceElement2(Element link, Element processElement) {
        String attribut;
        Iterator iter = processElement.getDescendants(new ElementFilter(SOURCE_TAG, BpelXMLTools.getProcessNamespace()));
        Element source = null;
        String linkName = link.getAttributeValue(ATTRIBUTE_NAME);
        while (iter.hasNext() && ((attribut = (source = (Element)iter.next()).getAttributeValue(ATTRIBUTE_LINKNAME)) == null || !attribut.equals(linkName))) {
        }
        return source;
    }

    private Element insertPostivLink(Element flow, Element sourceElement, Element link, String transitionCondition) {
        Element link_copy = this.createLinkCopy(link, flow, COPY_LINK_POSTFIX);
        Element new_source_element = BpelXMLTools.createBPELElement(SOURCE_TAG);
        new_source_element.setAttribute(ATTRIBUTE_LINKNAME, link_copy.getAttributeValue(ATTRIBUTE_NAME));
        if (BpelXMLTools.getProcessNamespace().equals(BpelXMLTools.NAMESPACE_BPEL_2_0)) {
            Element transConditionElement = (Element)sourceElement.getChild(TRANSITION_CONDITION, BpelXMLTools.getProcessNamespace()).clone();
            new_source_element.addContent((Element)transConditionElement.clone());
        } else if (BpelXMLTools.getProcessNamespace().equals(BpelXMLTools.NAMESPACE_BPEL_1_1)) {
            new_source_element.setAttribute(TRANSITION_CONDITION, transitionCondition);
        }
        sourceElement.getParentElement().addContent(0, new_source_element);
        return link_copy;
    }

    private Element createLinkCopy(Element link, Element flow, String postfix) {
        Element link_copy = (Element)link.clone();
        link_copy.setAttribute(ATTRIBUTE_NAME, link.getAttributeValue(ATTRIBUTE_NAME) + postfix);
        Element links = flow.getChild(LINKS_TAG, BpelXMLTools.getProcessNamespace());
        if (links == null) {
            links = BpelXMLTools.createBPELElement(LINKS_TAG);
            flow.addContent(0, links);
        }
        links.addContent(link_copy);
        return link_copy;
    }

    private void insertLoggingMarker(Element new_link, Element enclosedFlow, boolean isPositivValueOfLink) {
        Comment logging;
        String marker;
        if (isPositivValueOfLink) {
            marker = LinkMetricHandler.getNextPositivLinkMarker();
            logging = new Comment("@coverageLabel" + marker);
        } else {
            marker = LinkMetricHandler.getNextNegativLinkMarker();
            logging = new Comment("@coverageLabel" + marker);
        }
        this.markersRegistry.registerMarker(marker);
        Element sequence = BpelXMLTools.createSequence();
        Element targetElement = BpelXMLTools.createBPELElement(TARGET_TAG);
        targetElement.setAttribute(ATTRIBUTE_LINKNAME, new_link.getAttributeValue(ATTRIBUTE_NAME));
        if (BpelXMLTools.getProcessNamespace().equals(BpelXMLTools.NAMESPACE_BPEL_2_0)) {
            Element targets = BpelXMLTools.createBPELElement(TARGETS_TAG);
            targets.addContent(targetElement);
            targetElement = targets;
        }
        sequence.addContent(targetElement);
        sequence.addContent(logging);
        enclosedFlow.addContent(sequence);
    }

    private Element insertNegativLink(Element flow, Element sourceElement, Element link, String transitionCondition) {
        Element link_copy = this.createLinkCopy(link, flow, COPY_LINK_NEGIERT_POSTFIX);
        Element new_source_element = BpelXMLTools.createBPELElement(SOURCE_TAG);
        new_source_element.setAttribute(ATTRIBUTE_LINKNAME, link_copy.getAttributeValue(ATTRIBUTE_NAME));
        if (BpelXMLTools.getProcessNamespace().equals(BpelXMLTools.NAMESPACE_BPEL_2_0)) {
            Element transConditionElement = (Element)sourceElement.getChild(TRANSITION_CONDITION, BpelXMLTools.getProcessNamespace()).clone();
            transConditionElement.setText("not(" + transConditionElement.getText() + ")");
            new_source_element.addContent(transConditionElement);
        } else if (BpelXMLTools.getProcessNamespace().equals(BpelXMLTools.NAMESPACE_BPEL_1_1)) {
            new_source_element.setAttribute(TRANSITION_CONDITION, "not(" + transitionCondition + ")");
        }
        sourceElement.getParentElement().addContent(0, new_source_element);
        return link_copy;
    }
}

