/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.coverage.annotation.metrics.activitycoverage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.bpelunit.framework.coverage.annotation.metrics.IMetricHandler;
import net.bpelunit.framework.coverage.annotation.tools.bpelxmltools.BpelXMLTools;
import net.bpelunit.framework.coverage.receiver.MarkersRegisterForArchive;
import org.apache.log4j.Logger;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityMetricHandler
implements IMetricHandler {
    public static int targetscount;
    private Logger logger = Logger.getLogger(this.getClass());
    private MarkersRegisterForArchive markersRegistry;

    public ActivityMetricHandler(MarkersRegisterForArchive markersRegistry) {
        this.markersRegistry = markersRegistry;
        this.logger = Logger.getLogger(this.getClass());
    }

    @Override
    public void insertMarkersForMetric(List<Element> activities) {
        for (Element activity : activities) {
            Element sequence = null;
            this.respectTargetActivities(activity, sequence);
            BpelXMLTools.ensureElementIsInSequence(activity);
            this.insertMarkerForActivity(activity);
        }
    }

    private void respectSourceActivities(Element element, Element sequence) {
        List<Element> sourceElements = this.getSourceElements(element);
        if (sourceElements.size() > 0) {
            if (sequence == null) {
                sequence = BpelXMLTools.encloseInSequence(element);
            }
            for (Element sourceElement : sourceElements) {
                sequence.addContent(0, sourceElement.detach());
            }
        }
    }

    private void respectTargetActivities(Element element, Element sequence) {
        List<Element> targetElements = this.getTargetElements(element);
        if (targetElements.size() > 0) {
            sequence = BpelXMLTools.encloseInSequence(element);
            for (Element targetElement : targetElements) {
                sequence.addContent(0, targetElement.detach());
            }
        }
    }

    private List<Element> getSourceElements(Element element) {
        ArrayList<Element> sourceElements = new ArrayList<Element>();
        Namespace bpelVersion = BpelXMLTools.getProcessNamespace();
        if (bpelVersion.equals(BpelXMLTools.NAMESPACE_BPEL_2_0)) {
            Element sourceElement = element.getChild("sources", bpelVersion);
            if (sourceElement != null) {
                sourceElements.add(sourceElement);
            }
        } else if (bpelVersion.equals(BpelXMLTools.NAMESPACE_BPEL_1_1)) {
            List list = element.getChildren("source", bpelVersion);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                sourceElements.add((Element)iter.next());
            }
        }
        return sourceElements;
    }

    private List<Element> getTargetElements(Element element) {
        ArrayList<Element> targetElements = new ArrayList<Element>();
        Namespace bpelVersion = BpelXMLTools.getProcessNamespace();
        if (bpelVersion.equals(BpelXMLTools.NAMESPACE_BPEL_2_0)) {
            Element targetElement = element.getChild("targets", bpelVersion);
            if (targetElement != null) {
                targetElements.add(targetElement);
            }
        } else if (bpelVersion.equals(BpelXMLTools.NAMESPACE_BPEL_1_1)) {
            List list = element.getChildren("target", bpelVersion);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                targetElements.add((Element)iter.next());
            }
        }
        return targetElements;
    }

    private void insertMarkerForActivity(Element element) {
        Element parent = element.getParentElement();
        String element_name = element.getName();
        String marker = element_name + '_' + BpelXMLTools.count++;
        this.markersRegistry.registerMarker(marker);
        Comment comment = new Comment("@coverageLabel" + marker);
        int index = parent.indexOf(element);
        if (element_name.equals("receive")) {
            parent.addContent(index + 1, comment);
        } else {
            parent.addContent(index, comment);
        }
    }
}

