/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.ws;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeoutException;
import net.bpelunit.framework.control.run.TestCaseRunner;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.exception.PartnerNotFoundException;
import net.bpelunit.framework.model.test.PartnerTrack;
import net.bpelunit.framework.model.test.wire.IncomingMessage;
import net.bpelunit.framework.model.test.wire.OutgoingMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.util.ByteArrayISO8859Writer;

public class WebServiceHandler
extends AbstractHttpHandler {
    private Logger wsLogger = Logger.getLogger(this.getClass());
    private static final long serialVersionUID = -2402788148972993151L;
    private TestCaseRunner fRunner;

    public void initialize(TestCaseRunner runner) {
        this.fRunner = runner;
    }

    public void deinitialize() {
        this.fRunner = null;
    }

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        String line;
        PartnerTrack key;
        this.wsLogger.info("Incoming request for path " + pathInContext);
        if (!request.getMethod().equals("POST")) {
            this.wsLogger.error("Got a non-POST request - rejecting message " + pathInContext);
            return;
        }
        String partnerName = WebServiceHandler.getPartnerName(pathInContext);
        if (this.fRunner == null) {
            this.wsLogger.error("Not initialized - rejecting message for URL " + pathInContext);
            return;
        }
        this.wsLogger.debug("Supposed partner name for this request: " + partnerName);
        try {
            key = this.fRunner.findPartnerTrackForName(partnerName);
        }
        catch (PartnerNotFoundException e1) {
            this.wsLogger.info(e1.getMessage());
            this.wsLogger.info("Rejecting message with 404.");
            return;
        }
        this.wsLogger.debug("A partner was found for the target URL: " + key);
        this.wsLogger.debug("Request method is: " + request.getMethod());
        BufferedReader reader = new BufferedReader(new InputStreamReader(request.getInputStream()));
        StringBuffer theRequest = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            theRequest.append(line);
        }
        this.wsLogger.debug("Incoming request payload is:\n" + theRequest.toString());
        IncomingMessage iMessage = new IncomingMessage();
        iMessage.setBody(theRequest.toString());
        try {
            this.wsLogger.debug("Posting incoming message to blackboard...");
            this.fRunner.putWSIncomingMessage(key, iMessage);
            this.wsLogger.debug("Waiting for framework to supply answer...");
            OutgoingMessage m2 = this.fRunner.getWSOutgoingMessage(key);
            this.wsLogger.debug("Got answer from framework, now sending...");
            int code = m2.getCode();
            String body = m2.getBody();
            this.wsLogger.debug("Answer is:\n" + body);
            for (String option : m2.getProtocolOptionNames()) {
                response.addField(option, m2.getProtocolOption(option));
            }
            this.sendResponse(response, code, body);
            this.wsLogger.debug("Posting \"message sent\" to framework...");
            this.fRunner.putWSOutgoingMessageSent(m2);
            this.wsLogger.info("Done handling request, result OK. " + code);
        }
        catch (TimeoutException e) {
            this.wsLogger.error("Timeout while waiting for framework to supply answer to incoming message");
            this.wsLogger.error("This most likely indicates a bug in the framework.");
            this.wsLogger.error("Sending fault.");
            this.sendResponse(response, 500, BPELUnitUtil.generateGenericSOAPFault());
        }
        catch (InterruptedException e) {
            this.wsLogger.error("Interrupted while waiting for framework for incoming message or answer.");
            this.wsLogger.error("This most likely indicates another error occurred.");
            this.wsLogger.error("Sending fault.");
            this.sendResponse(response, 500, BPELUnitUtil.generateGenericSOAPFault());
        }
    }

    private static String getPartnerName(String path) {
        String stringToTest = path;
        stringToTest = StringUtils.removeEnd(stringToTest, "/");
        stringToTest = StringUtils.substringAfterLast(stringToTest, "/");
        return stringToTest;
    }

    private void sendResponse(HttpResponse response, int code, String body) throws IOException {
        response.setContentType("text/xml");
        response.setStatus(code);
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(2048);
        writer.write(body);
        writer.flush();
        response.setContentLength(writer.size());
        writer.writeTo(response.getOutputStream());
        writer.destroy();
    }
}

