/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.ws;

import net.bpelunit.framework.BPELUnitRunner;
import net.bpelunit.framework.control.run.TestCaseRunner;
import net.bpelunit.framework.control.ws.WebServiceHandler;
import net.bpelunit.framework.coverage.receiver.MarkersServiceHandler;
import org.apache.log4j.Logger;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.NotFoundHandler;

public class LocalHTTPServer {
    private HttpServer fServer;
    private WebServiceHandler fHandler;
    private Logger wsLogger = Logger.getLogger(this.getClass());
    private MarkersServiceHandler fHandler2;
    private SocketListener listener2 = null;

    public LocalHTTPServer(int portNumber, String rootPath) {
        this.fServer = new HttpServer();
        SocketListener listener = new SocketListener();
        listener.setPort(portNumber);
        this.fServer.addListener(listener);
        HttpContext context = new HttpContext();
        context.setContextPath(rootPath);
        this.wsLogger.info("!!!!ROOTPATH " + rootPath);
        context.setResourceBase("");
        this.fHandler = new WebServiceHandler();
        context.addHandler(this.fHandler);
        context.addHandler(new NotFoundHandler());
        this.fServer.addContext(context);
        if (BPELUnitRunner.measureTestCoverage()) {
            this.listener2 = new SocketListener();
            this.listener2.setPort(7778);
            this.listener2.setBufferSize(20000);
            this.listener2.setBufferReserve(1024);
            this.fServer.addListener(this.listener2);
            HttpContext context2 = new HttpContext();
            context2.setContextPath("/coverage/");
            context2.setResourceBase("");
            this.fHandler2 = new MarkersServiceHandler();
            context2.addHandler(this.fHandler2);
            context2.addHandler(new NotFoundHandler());
            this.fServer.addContext(context2);
        }
    }

    public void startTest(TestCaseRunner runner) {
        this.fHandler.initialize(runner);
    }

    public void startServer() throws Exception {
        Logger.getLogger(this.getClass()).info("Starting local HTTP Server...");
        this.fServer.start();
        Logger.getLogger(this.getClass()).info("Local HTTP server was started.");
    }

    public void stopServer() throws InterruptedException {
        this.wsLogger.info("Connections=" + this.fServer.getConnections());
        this.wsLogger.info("ConnectionsOpen=" + this.fServer.getConnectionsOpen());
        this.wsLogger.info("ConnectionsRequests=" + this.fServer.getRequests());
        if (this.listener2 != null) {
            this.wsLogger.info("ACCEPTQUESIZE=" + this.listener2.getAcceptQueueSize());
        }
        this.fServer.stop(true);
    }

    public void stopTest(TestCaseRunner runner) {
        this.fHandler.deinitialize();
    }
}

