/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.soap;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import net.bpelunit.framework.control.ext.ISOAPEncoder;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.exception.SOAPEncodingException;
import net.bpelunit.framework.model.test.data.SOAPOperationCallIdentifier;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RPCLiteralEncoder
implements ISOAPEncoder {
    private static final String RPC_WRAPPER_NAMESPACE_PREFIX = "rpcwrappernsprefix";

    public SOAPMessage construct(SOAPOperationCallIdentifier operation, Element literalData, QName faultCode, String faultString) throws SOAPEncodingException {
        try {
            SOAPBody body;
            if (operation.isFault()) {
                throw new SOAPEncodingException("RPC style cannot be used with SOAP faults: check section 3.6 of the WSDL 1.1 standard");
            }
            MessageFactory mFactory = BPELUnitUtil.getMessageFactoryInstance();
            SOAPFactory sFactory = SOAPFactory.newInstance();
            SOAPMessage message = mFactory.createMessage();
            SOAPBody data = body = message.getSOAPBody();
            String bodyNamespace = operation.getBodyNamespace();
            Element firstElement = this.getFirstElementChild(literalData);
            SOAPElement newWrapper = sFactory.createElement(operation.getName(), RPC_WRAPPER_NAMESPACE_PREFIX, bodyNamespace);
            NodeList list = firstElement != null && bodyNamespace.equals(firstElement.getNamespaceURI()) && operation.getName().equals(firstElement.getLocalName()) ? firstElement.getChildNodes() : literalData.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!(node instanceof Element)) continue;
                Element actual = (Element)list.item(i);
                newWrapper.addChildElement(sFactory.createElement(actual));
            }
            data.addChildElement(newWrapper);
            return message;
        }
        catch (SOAPException e) {
            throw new SOAPEncodingException("A SOAPException occurred in the DocumentLiteralEncoder while encoding to operation " + operation, e);
        }
    }

    public Element deconstruct(SOAPOperationCallIdentifier operation, SOAPMessage message) throws SOAPEncodingException {
        try {
            SOAPBody body = message.getSOAPBody();
            if (operation.isFault()) {
                throw new SOAPEncodingException("rpc style cannot be used with SOAP faults: check section 3.6 of the WSDL 1.1 standard");
            }
            SOAPBody data = body;
            SOAPElement rpcWrapper = null;
            Iterator childElements = data.getChildElements();
            while (childElements.hasNext()) {
                Object current = childElements.next();
                if (!(current instanceof SOAPElement)) continue;
                rpcWrapper = (SOAPElement)current;
                break;
            }
            if (rpcWrapper == null) {
                throw new SOAPEncodingException("Incoming SOAP message for operation " + operation + " does not have a RPC Wrapper element.");
            }
            Element rawRoot = BPELUnitUtil.generateDummyElementNode();
            Iterator i = rpcWrapper.getChildElements();
            while (i.hasNext()) {
                Object current = i.next();
                if (!(current instanceof SOAPElement)) continue;
                SOAPElement element = (SOAPElement)current;
                rawRoot.appendChild(rawRoot.getOwnerDocument().importNode((Node)element, true));
            }
            return rawRoot;
        }
        catch (SOAPException e) {
            throw new SOAPEncodingException("A SOAPException occurred in the RPCLiteralEncoder while decoding for operation " + operation);
        }
    }

    private Element getFirstElementChild(Node literalData) {
        for (Node firstElement = literalData.getFirstChild(); firstElement != null; firstElement = firstElement.getNextSibling()) {
            if (!(firstElement instanceof Element)) continue;
            return (Element)firstElement;
        }
        return null;
    }
}

