/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.framework.control.datasource;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.bpelunit.framework.control.datasource.DataSourceHelper;
import net.bpelunit.framework.control.datasource.DataSourceUtil;
import net.bpelunit.framework.control.datasource.VelocityDataSource;
import net.bpelunit.framework.control.ext.IDataSource;
import net.bpelunit.framework.control.util.ExtensionRegistry;
import net.bpelunit.framework.exception.DataSourceException;
import net.bpelunit.framework.exception.SpecificationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VelocityDataSourceTest {
    private static final String SOURCE_TYPE = "velocity";

    @Before
    public void setUp() throws Exception {
        ExtensionRegistry.loadRegistry(new File("src/main/resources/conf", "extensions.xml").toURI().toURL(), false);
    }

    @Test
    public void testMetaData() throws Exception {
        List<String> messages = DataSourceHelper.validateDataSourceAnnotation(VelocityDataSource.class);
        Assert.assertEquals((String)messages.toString(), (long)0L, (long)messages.size());
        messages = DataSourceHelper.validateMethodAnnotations(VelocityDataSource.class);
        Assert.assertEquals((String)messages.toString(), (long)0L, (long)messages.size());
        Assert.assertTrue((boolean)DataSourceHelper.isValidConfigurationOption(new VelocityDataSource(), "iteratedVars"));
    }

    @Test
    public void canBeCreated() throws Exception {
        ExtensionRegistry.createNewDataSourceForType(SOURCE_TYPE);
    }

    @Test
    public void iteratedVarsPropertyIsRequired() throws SpecificationException {
        try {
            this.createDataSourceFromString(null, "#set($x=[1,2,3])");
            Assert.fail((String)"A DataSourceException was expected");
        }
        catch (DataSourceException ex) {
            Assert.assertTrue((String)"The exception message should indicate that the required iterated_vars property is missing", (boolean)ex.getMessage().contains("iteratedVars"));
        }
    }

    @Test
    public void iteratedVarsPropertyCannotBeEmpty() throws SpecificationException {
        try {
            this.createDataSourceFromString("   ", "#set($x=[1,2,3])");
            Assert.fail((String)"A DataSourceException was expected");
        }
        catch (DataSourceException ex) {
            Assert.assertTrue((String)"The exception message should indicate that the required iterated_vars property cannot be empty", (boolean)ex.getMessage().contains("empty"));
        }
    }

    @Test
    public void missingIteratedVariablesAreReported() throws SpecificationException {
        String variableName = "myvar";
        try {
            this.createDataSourceFromString("myvar", "");
            Assert.fail((String)"A DataSourceException was expected");
        }
        catch (DataSourceException ex) {
            Assert.assertTrue((String)"The exception message should indicate that the iterated variable x is not set in its contents", (boolean)ex.getMessage().contains("myvar"));
        }
    }

    @Test
    public void mismatchingLengthsOfIteratedVariablesAreReported() throws SpecificationException {
        try {
            this.createDataSourceFromString("x y", "#set($x=[1,2,3])\n#set($y=[1,2])");
            Assert.fail((String)"A DataSourceException was expected");
        }
        catch (DataSourceException ex) {
            Assert.assertTrue((String)"The exception message should indicate that the iterated variables have mismatching lengths", (boolean)ex.getMessage().contains("length"));
        }
    }

    @Test
    public void emptyIteratedVariablesAreReported() throws SpecificationException {
        try {
            this.createDataSourceFromString("x y", "#set($x=[])\n#set($y=[])");
            Assert.fail((String)"A DataSourceException was expected");
        }
        catch (DataSourceException ex) {
            Assert.assertTrue((String)"The exception message should indicate that iterated variables cannot have 0 elements", (boolean)ex.getMessage().contains("at least one element"));
        }
    }

    @Test
    public void iteratedVariablesWithWrongTypesAreReported() throws SpecificationException {
        try {
            this.createDataSourceFromString("x myvar", "#set($x=[1,2,3])\n#set($myvar={'foo':1,'bar':2})");
            Assert.fail((String)"A DataSourceException was expected");
        }
        catch (DataSourceException ex) {
            Assert.assertTrue((String)"The exception message should indicate that one of the iterated variables has a wrong type", (boolean)ex.getMessage().contains("does not contain a list literal"));
        }
    }

    @Test
    public void unknownPropertiesAreReported() throws SpecificationException {
        try {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("iteratedVars", "x");
            props.put("badprop", "nobodyexpectsthespanishinquisition");
            IDataSource ds = ExtensionRegistry.createNewDataSourceForType(SOURCE_TYPE);
            DataSourceUtil.initializeDataSource(ds, DataSourceUtil.getStreamForDataSource("#set($x=[1,2,3])", null, null), props);
            Assert.fail((String)"A DataSourceException was expected.");
        }
        catch (DataSourceException ex) {
            Assert.assertTrue((String)"The exception message should indicate that an unknown property was used.", (boolean)ex.getMessage().contains("Property"));
        }
    }

    @Test
    public void invalidRowsAreReported() throws Exception {
        IDataSource ds = this.createDataSourceFromString("x", "#set($x=[1,2])");
        try {
            ds.setRow(5);
            Assert.fail((String)"Invalid row indexes should be reported");
        }
        catch (DataSourceException dataSourceException) {
            // empty catch block
        }
    }

    @Test
    public void validContentsWorkAsExpected() throws Exception {
        IDataSource ds = this.createDataSourceFromString("x y", "#set($x=[1,2,3])\n#set($y=[2,4,6])\n#set($z=3)");
        Assert.assertEquals((long)3L, (long)ds.getNumberOfRows());
        List<String> fieldNames = Arrays.asList(ds.getFieldNames());
        Assert.assertEquals((long)3L, (long)fieldNames.size());
        Assert.assertTrue((boolean)fieldNames.contains("x"));
        Assert.assertTrue((boolean)fieldNames.contains("y"));
        Assert.assertTrue((boolean)fieldNames.contains("z"));
        int[] x = new int[]{1, 2, 3};
        int[] y = new int[]{2, 4, 6};
        int z = 3;
        for (int iRow = 0; iRow < ds.getNumberOfRows(); ++iRow) {
            ds.setRow(iRow);
            Assert.assertEquals((Object)x[iRow], (Object)ds.getValueFor("x"));
            Assert.assertEquals((Object)y[iRow], (Object)ds.getValueFor("y"));
            Assert.assertEquals((Object)3, (Object)ds.getValueFor("z"));
        }
    }

    @Test
    public void nestedListLiteralsWork() throws Exception {
        IDataSource ds = this.createDataSourceFromString("lines", "#set($lines=[[],['A'],['A','B'],['A','B','C']])");
        String[] fieldNames = ds.getFieldNames();
        Assert.assertEquals((long)1L, (long)fieldNames.length);
        Assert.assertEquals((Object)"lines", (Object)fieldNames[0]);
        String[][] expectedRows = new String[][]{new String[0], {"A"}, {"A", "B"}, {"A", "B", "C"}};
        Assert.assertEquals((long)expectedRows.length, (long)ds.getNumberOfRows());
        for (int iRow = 0; iRow < ds.getNumberOfRows(); ++iRow) {
            ds.setRow(iRow);
            List actualLines = (List)ds.getValueFor("lines");
            String[] expectedLines = expectedRows[iRow];
            Assert.assertEquals((long)expectedLines.length, (long)actualLines.size());
            for (int iLine = 0; iLine < expectedLines.length; ++iLine) {
                Assert.assertEquals((Object)expectedLines[iLine], actualLines.get(iLine));
            }
        }
    }

    private IDataSource createDataSourceFromString(String variables, String contents) throws DataSourceException, SpecificationException {
        HashMap<String, String> props = new HashMap<String, String>();
        if (variables != null) {
            props.put("iteratedVars", variables);
        }
        IDataSource ds = ExtensionRegistry.createNewDataSourceForType(SOURCE_TYPE);
        return DataSourceUtil.initializeDataSource(ds, DataSourceUtil.getStreamForDataSource(contents, null, null), props);
    }
}

