/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.utils.datasourceinliner;

import java.io.File;
import java.io.IOException;
import net.bpelunit.framework.BPELUnitRunner;
import net.bpelunit.framework.control.datasource.DataSourceUtil;
import net.bpelunit.framework.control.ext.IDataSource;
import net.bpelunit.framework.exception.DataSourceException;
import net.bpelunit.framework.xml.suite.XMLSetUp;
import net.bpelunit.framework.xml.suite.XMLTestCase;
import net.bpelunit.framework.xml.suite.XMLTestCasesSection;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.framework.xml.suite.XMLTestSuiteDocument;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class Inliner {
    public XMLTestSuiteDocument inlineDataSources(XMLTestSuiteDocument xmlOldSuiteDoc, File bptsDir, BPELUnitRunner runner) throws XmlException, DataSourceException {
        XMLTestSuiteDocument newDoc = (XMLTestSuiteDocument)xmlOldSuiteDoc.copy();
        XMLTestSuite xmlNewSuite = newDoc.getTestSuite();
        XMLTestCasesSection xmlNewCases = this.removeAllTestCases(xmlNewSuite);
        if (xmlNewSuite.isSetSetUp()) {
            xmlNewSuite.unsetSetUp();
        }
        XMLTestSuite xmlOldSuite = xmlOldSuiteDoc.getTestSuite();
        XMLTestCasesSection xmlOldCases = xmlOldSuite.getTestCases();
        String globalSetup = this.getGlobalSetUp(xmlOldSuite);
        for (XMLTestCase xmlOldCase : xmlOldCases.getTestCaseList()) {
            IDataSource dataSource = DataSourceUtil.createDataSource((XMLTestSuite)xmlOldSuite, (XMLTestCase)xmlOldCase, (File)bptsDir, (BPELUnitRunner)runner);
            String localSetup = this.getLocalSetUp(xmlOldCase);
            int nRows = dataSource != null ? dataSource.getNumberOfRows() : 1;
            for (int i = 0; i < nRows; ++i) {
                String expandedSetup = this.computeExpandedSetUp(globalSetup, localSetup, dataSource, i);
                XMLTestCase xmlNewCase = this.createExpandedTestCase(xmlOldCase, dataSource != null ? i : -1, expandedSetup);
                xmlNewCases.addNewTestCase().set((XmlObject)xmlNewCase);
            }
        }
        return newDoc;
    }

    public void inlineFile(File fSource, File fDestination, BPELUnitRunner runner) throws XmlException, IOException, DataSourceException {
        XMLTestSuiteDocument originalBpts = XMLTestSuiteDocument.Factory.parse((File)fSource);
        XMLTestSuiteDocument inlinedDoc = this.inlineDataSources(originalBpts, fSource.getParentFile(), runner);
        inlinedDoc.save(fDestination);
    }

    private XMLTestCase createExpandedTestCase(XMLTestCase original, int row, String setup) {
        XMLTestCase xmlNewCase = (XMLTestCase)original.copy();
        if (row >= 0) {
            xmlNewCase.setName(String.format("%s (Row %d)", original.getName(), row + 1));
        }
        if (xmlNewCase.isSetSetUp()) {
            xmlNewCase.unsetSetUp();
        }
        if (setup.trim().length() > 0) {
            XMLSetUp xmlNewSetUp = xmlNewCase.addNewSetUp();
            xmlNewSetUp.setScript(setup);
        }
        return xmlNewCase;
    }

    private String computeExpandedSetUp(String globalSetup, String localSetup, IDataSource dataSource, int row) throws DataSourceException {
        return globalSetup + "\n" + localSetup + "\n" + this.renderRowAsVelocity(dataSource, row);
    }

    private XMLTestCasesSection removeAllTestCases(XMLTestSuite xmlNewSuite) {
        XMLTestCasesSection xmlNewTestCases = xmlNewSuite.getTestCases();
        xmlNewTestCases.setTestCaseArray(new XMLTestCase[0]);
        return xmlNewTestCases;
    }

    private String getLocalSetUp(XMLTestCase xmlOldCase) {
        if (xmlOldCase.isSetSetUp() && xmlOldCase.getSetUp().isSetScript()) {
            return xmlOldCase.getSetUp().getScript();
        }
        return "";
    }

    private String getGlobalSetUp(XMLTestSuite xmlOldSuite) {
        if (xmlOldSuite.isSetSetUp() && xmlOldSuite.getSetUp().isSetScript()) {
            return xmlOldSuite.getSetUp().getScript();
        }
        return "";
    }

    private String renderRowAsVelocity(IDataSource dataSource, int row) throws DataSourceException {
        if (dataSource == null) {
            return "";
        }
        dataSource.setRow(row);
        StringBuffer sbuf = new StringBuffer();
        for (String fieldName : dataSource.getFieldNames()) {
            sbuf.append(String.format("#set( $%s = ", fieldName));
            this.renderValueAsVelocity(sbuf, dataSource.getValueFor(fieldName));
            sbuf.append(" )\n");
        }
        return sbuf.toString();
    }

    private void renderValueAsVelocity(StringBuffer sbuf, Object value) {
        if (value instanceof String) {
            sbuf.append("'" + (String)value + "'");
        } else if (value instanceof Iterable) {
            sbuf.append("[");
            boolean bFirst = true;
            for (Object elem : (Iterable)value) {
                if (!bFirst) {
                    sbuf.append(", ");
                }
                this.renderValueAsVelocity(sbuf, elem);
                bFirst = false;
            }
            sbuf.append("]");
        } else {
            sbuf.append(value.toString());
        }
    }
}

