/*
 * Decompiled with CFR 0.152.
 */
package net.bndy.cache;

import java.util.ArrayList;
import java.util.List;
import net.bndy.cache.AbstractCache;
import net.bndy.cache.Server;
import net.bndy.lib.CollectionHelper;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

public class RedisCache
extends AbstractCache {
    private ShardedJedisPool shardedJedisPool;
    private List<Server> servers = new ArrayList<Server>();

    public RedisCache(String servers) {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        ArrayList<JedisShardInfo> jedisShardInfoList = new ArrayList<JedisShardInfo>();
        for (String server : servers.split("[,;|]")) {
            int separatorIndex = server.lastIndexOf(":");
            String host = server.substring(0, separatorIndex);
            int port = Integer.parseInt(server.substring(separatorIndex + 1));
            Server server1 = new Server(host, port);
            this.servers.add(server1);
            JedisShardInfo jedisShardInfo = new JedisShardInfo(host, port);
            jedisShardInfoList.add(jedisShardInfo);
        }
        this.shardedJedisPool = new ShardedJedisPool((GenericObjectPoolConfig)jedisPoolConfig, jedisShardInfoList);
    }

    @Override
    public void set(Object data) {
        try (ShardedJedis jedis = null;){
            jedis = this.shardedJedisPool.getResource();
            jedis.set(this.getKey(data), this.getJson(data));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(Object data, long exp) {
        String key = this.getKey(data);
        try (ShardedJedis jedis = null;){
            jedis = this.shardedJedisPool.getResource();
            if (jedis.exists(key).booleanValue()) {
                jedis.set(this.getKey(data), this.getJson(data), "XX", "EX", exp);
            } else {
                jedis.set(this.getKey(data), this.getJson(data), "NX", "EX", exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String key) {
        try (ShardedJedis jedis = null;){
            jedis = this.shardedJedisPool.getResource();
            if (jedis.exists(key).booleanValue()) {
                String string = jedis.get(key);
                return string;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(String key, Class<T> clazz) {
        try (ShardedJedis jedis = null;){
            jedis = this.shardedJedisPool.getResource();
            if (jedis.exists(key).booleanValue()) {
                String json = jedis.get(key);
                T t = this.deserialize(json, clazz);
                return t;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int del(String ... keys) {
        int result = 0;
        try (ShardedJedis jedis = null;){
            jedis = this.shardedJedisPool.getResource();
            for (String key : keys) {
                jedis.del(key);
                ++result;
            }
            int n = result;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delAll() {
        Server masterServer = (Server)CollectionHelper.first(this.servers);
        try (Jedis jedis = null;){
            jedis = new Jedis(masterServer.getHost(), masterServer.getPort());
            int result = jedis.dbSize().intValue();
            jedis.flushDB();
            int n = result;
            return n;
        }
    }
}

