/*
 * Decompiled with CFR 0.152.
 */
package net.bndy.cache;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import net.bndy.cache.Cache;
import net.bndy.cache.CacheKey;
import net.bndy.lib.AnnotationHelper;
import net.bndy.lib.CollectionHelper;
import net.bndy.lib.JsonHelper;
import net.bndy.lib.ReflectionHelper;
import net.bndy.lib.StringHelper;

public abstract class AbstractCache
implements Cache {
    protected String getKey(Object data) {
        Field fieldKey = (Field)CollectionHelper.first((Collection)ReflectionHelper.getAllFields(data.getClass()), field -> AnnotationHelper.getFieldAnnotation(CacheKey.class, data.getClass(), (String)field.getName()) != null);
        if (fieldKey == null) {
            throw new Error("No cache key (@CacheKey) defined in " + data.getClass().getCanonicalName());
        }
        try {
            return data.getClass().getCanonicalName() + "#" + fieldKey.get(data);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String getJson(Object data) {
        try {
            return JsonHelper.toString((Object)data);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected <T> T deserialize(String json, Class<T> clazz) {
        if (StringHelper.isNullOrWhiteSpace((String)json)) {
            return null;
        }
        try {
            return (T)StringHelper.toJson((String)json, clazz);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

