/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.ArrayList;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.WebContentAssignmentDAO;
import net.blugrid.core.dao.WebContentDAO;
import net.blugrid.core.model.EmailWebContent;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.ObjectResponse;
import net.blugrid.core.model.Token;
import net.blugrid.core.model.WebContent;
import net.blugrid.core.model.WebContentAssignment;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class WebContentDAOImpl
implements WebContentDAO {
    private static final Logger logger = Logger.getLogger(WebContentDAOImpl.class);
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;
    @Autowired
    private WebContentAssignmentDAO webcontentassignmentdao;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public WebContent post(Token token, WebContent webcontent) {
        WebContent webcontentuuid = new WebContent();
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outwebcontentuuid as webcontentuuid from proc_post_webcontent(   :insessiontoken::t_pgpmessage,   :inwebcontentuuid::t_uuid,  :inwebcontentname::t_name,  :inwebcontenttemplateiduuid::t_uuid,  :initemuuid::t_uuid,  :inblogarticleuuid::t_uuid,  :inwebpageuuid::t_uuid,  :insequence::t_identity,  :inmodeldata::t_json,   :instatus::t_status  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)token.getid_token());
        parameters.addValue("inwebcontentuuid", (Object)webcontent.getWebcontentuuid());
        parameters.addValue("inwebcontentname", (Object)webcontent.getWebcontentname());
        if (webcontent.getWebcontenttemplate() != null) {
            parameters.addValue("inwebcontenttemplateiduuid", (Object)webcontent.getWebcontenttemplate().getWebcontenttemplateuuid());
        } else {
            parameters.addValue("inwebcontenttemplateiduuid", (Object)webcontent.getWebcontenttemplateuuid());
        }
        parameters.addValue("initemuuid", (Object)webcontent.getItemuuid());
        parameters.addValue("inblogarticleuuid", (Object)webcontent.getBlogarticleuuid());
        parameters.addValue("inwebpageuuid", (Object)webcontent.getWebpageuuid());
        parameters.addValue("insequence", (Object)webcontent.getSequence());
        parameters.addValue("inmodeldata", webcontent.getModeldata());
        parameters.addValue("instatus", (Object)webcontent.getStatus());
        if (parameters.getValue("inwebcontenttemplateiduuid") != null) {
            webcontentuuid = (WebContent)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(WebContent.class));
            webcontent.setWebcontentuuid(webcontentuuid.getWebcontentuuid());
            if (webcontent.getWebcontentassignment() != null) {
                webcontent.getWebcontentassignment().setWebcontentuuid(webcontent.getWebcontentuuid());
                ObjectResponse<WebContentAssignment> response = this.webcontentassignmentdao.postWebContetAssignment(token, webcontent.getWebcontentassignment());
                webcontent.setWebcontentassignment((WebContentAssignment)response.getData());
            }
        } else {
            logger.error((Object)"Missing webcontenttemplateiduuid. Webcontent not saved");
        }
        return webcontent;
    }

    @Override
    public EmailWebContent postEmailWebContent(Token token, EmailWebContent webcontent) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outwebcontentuuid as webcontentuuid from proc_post_emailwebcontent(   :insessiontoken::t_pgpmessage,   :inwebcontentuuid::t_uuid,  :inwebcontentname::t_name,  :inwebcontenttemplateiduuid::t_uuid,  :inmodeldata::t_json,   :initemuuid::t_uuid,  :inmessageuuid::t_uuid,  :insequence::t_identity,  :instatus::t_status  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)token.getid_token());
        parameters.addValue("inwebcontentuuid", (Object)webcontent.getWebcontentuuid());
        parameters.addValue("inwebcontentname", (Object)webcontent.getWebcontentname());
        parameters.addValue("inwebcontenttemplateiduuid", (Object)webcontent.getWebcontenttemplate().getWebcontenttemplateuuid());
        parameters.addValue("initemuuid", (Object)webcontent.getItemuuid());
        parameters.addValue("inmodeldata", webcontent.getModeldata());
        parameters.addValue("inmessageuuid", (Object)webcontent.getMessageuuid());
        parameters.addValue("insequence", (Object)webcontent.getSequence());
        parameters.addValue("instatus", (Object)webcontent.getStatus());
        EmailWebContent webcontentuuid = (EmailWebContent)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(EmailWebContent.class));
        webcontent.setWebcontentuuid(webcontentuuid.getWebcontentuuid());
        if (webcontentuuid.getWebcontentuuid() != null && webcontent.getWebcontentassignment() != null) {
            webcontent.getWebcontentassignment().setWebcontentuuid(webcontentuuid.getWebcontentuuid());
            ObjectResponse<WebContentAssignment> wcaResponse = this.webcontentassignmentdao.postWebContetAssignment(token, webcontent.getWebcontentassignment());
            webcontent.setWebcontentassignment((WebContentAssignment)wcaResponse.getData());
        }
        return webcontent;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_webcontent(    :token::t_pgpmessage,    NULL::t_uuid,    NULL::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getAllWebpageWebcontent(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_webpagewebcontent(   :token::t_pgpmessage  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getAllEmailTemplateWebContent(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_emailtemplatewebcontent(   :token::t_pgpmessage  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        ArrayList webcontentlist = new ArrayList();
        WebContent webcontent = new WebContent();
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json  FROM proc_view_webcontent(    :token::t_pgpmessage,    NULL::t_uuid \n,    :uuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("uuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public WebContent updateModelData(Token token, UUID uuid, String modeldata) {
        WebContent webcontent = new WebContent();
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outwebcontentuuid as webcontentuuid  FROM proc_post_webcontent(    :token::t_pgpmessage,    :inwebcontentuuid::t_uuid \n,    :inmodeldata::t_json  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inwebcontentuuid", (Object)uuid.toString());
        parameters.addValue("inmodeldata", (Object)modeldata);
        webcontent = (WebContent)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(WebContent.class));
        return webcontent;
    }
}

