/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.List;
import javax.sql.DataSource;
import net.blugrid.core.dao.WebContentAssignmentDAO;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.ObjectResponse;
import net.blugrid.core.model.Token;
import net.blugrid.core.model.WebContentAssignment;
import net.blugrid.core.utils.PostgresqlJson;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class WebContentAssignmentDAOImpl
implements WebContentAssignmentDAO {
    private static final Logger logger = Logger.getLogger(WebContentAssignmentDAOImpl.class);
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public ObjectResponse<WebContentAssignment> postWebContetAssignment(Token token, WebContentAssignment webcontentassignment) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson as json   FROM proc_post_webcontentassignment(   :insessiontoken::t_pgpmessage,   :inwebcontentassignmentuuid::t_uuid,  :inwebcontentassignmenttype::t_webcontentassignmenttype,  :initemuuid::t_uuid,   :initemuuidlist::UUID[],   :initemcategoryuuid::t_uuid,   :initemcategoryuuidlist::UUID[],   :inblogarticleuuid::t_uuid,   :inblogarticleuuidlist::UUID[],   :inpositionuuid::t_uuid,   :inpositionuuidlist::UUID[],   :inwebcontentuuid::t_uuid,   :inwebpageuuid::t_uuid,   :instatus::t_status  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)token.getid_token());
        parameters.addValue("inwebcontentassignmentuuid", (Object)webcontentassignment.getWebcontentassignmentuuid());
        parameters.addValue("inwebcontentassignmenttype", (Object)webcontentassignment.getWebcontentassignmenttype());
        parameters.addValue("initemuuid", (Object)webcontentassignment.getItemuuid());
        parameters.addValue("initemuuidlist", (Object)PostgresqlJson.UUIDListToArray((List)webcontentassignment.getItemuuidlist()));
        parameters.addValue("initemcategoryuuid", (Object)webcontentassignment.getItemcategoryuuid());
        parameters.addValue("initemcategoryuuidlist", (Object)PostgresqlJson.UUIDListToArray((List)webcontentassignment.getItemcategoryuuidlist()));
        parameters.addValue("inblogarticleuuid", (Object)webcontentassignment.getBlogarticleuuid());
        parameters.addValue("inblogarticleuuidlist", (Object)PostgresqlJson.UUIDListToArray((List)webcontentassignment.getBlogarticleuuidlist()));
        parameters.addValue("inpositionuuid", (Object)webcontentassignment.getPositionuuid());
        parameters.addValue("inpositionuuidlist", (Object)PostgresqlJson.UUIDListToArray((List)webcontentassignment.getPositionuuidlist()));
        parameters.addValue("inwebcontentuuid", (Object)webcontentassignment.getWebcontentuuid());
        parameters.addValue("inwebpageuuid", (Object)webcontentassignment.getWebpageuuid());
        parameters.addValue("instatus", (Object)webcontentassignment.getStatus());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        Type type = new TypeToken<ObjectResponse<WebContentAssignment>>(){}.getType();
        ObjectResponse response = (ObjectResponse)new Gson().fromJson(json.getJson(), type);
        return response;
    }
}

