/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.ArrayList;
import javax.sql.DataSource;
import net.blugrid.core.dao.NoteDAO;
import net.blugrid.core.model.Competition;
import net.blugrid.core.model.Event;
import net.blugrid.core.model.Item;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Note;
import net.blugrid.core.model.Party;
import net.blugrid.core.model.Token;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class NoteDAOImpl
implements NoteDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_note(   :token::t_pgpmessage ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public Note post(Token Token2, Note note) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outnoteuuid AS noteuuid FROM proc_post_note(   :insessiontoken::t_pgpmessage,  :innoteuuid::t_uuid,  :inpartyuuid::t_uuid,   :innotetitle::t_descriptionshort,   :innoteconent::t_text,   :instatus::t_status,   :inpartyuuidlist::text[],   :initemuuidlist::text[],   :ineventuuidlist::text[],   :incompetitionuuidlist::text[]  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)Token2.getid_token());
        parameters.addValue("innoteuuid", (Object)note.getNoteuuid());
        if (note.getCreator().getPartyuuid() != null) {
            parameters.addValue("inpartyuuid", (Object)note.getCreator().getPartyuuid().toString());
        } else {
            parameters.addValue("inpartyuuid", null);
        }
        parameters.addValue("innotetitle", (Object)note.getNotetitle());
        parameters.addValue("innoteconent", (Object)note.getNotecontent());
        parameters.addValue("instatus", (Object)note.getStatus());
        ArrayList<String> slist = new ArrayList<String>();
        for (int j = 0; j < note.getNotepartyreferences().size(); ++j) {
            String uuidstr = ((Party)note.getNotepartyreferences().get(j)).getPartyuuid().toString();
            slist.add(uuidstr);
        }
        String str = ((Object)slist).toString();
        str = str.replace("[", "{");
        str = str.replace("]", "}");
        parameters.addValue("inpartyuuidlist", (Object)str);
        slist.clear();
        for (int j = 0; j < note.getNoteitemreferences().size(); ++j) {
            String uuidstr = ((Item)note.getNoteitemreferences().get(j)).getItemuuid().toString();
            slist.add(uuidstr);
        }
        String str2 = ((Object)slist).toString();
        str2 = str2.replace("[", "{");
        str2 = str2.replace("]", "}");
        parameters.addValue("initemuuidlist", (Object)str2);
        slist.clear();
        for (int j = 0; j < note.getNoteeventreferences().size(); ++j) {
            String uuidstr = ((Event)note.getNoteeventreferences().get(j)).getEventuuid().toString();
            slist.add(uuidstr);
        }
        String str3 = ((Object)slist).toString();
        str3 = str3.replace("[", "{");
        str3 = str3.replace("]", "}");
        parameters.addValue("ineventuuidlist", (Object)str3);
        slist.clear();
        for (int j = 0; j < note.getNotecompetitionreferences().size(); ++j) {
            String uuidstr = ((Competition)note.getNotecompetitionreferences().get(j)).getCompetitionuuid().toString();
            slist.add(uuidstr);
        }
        String str4 = ((Object)slist).toString();
        str4 = str4.replace("[", "{");
        str4 = str4.replace("]", "}");
        parameters.addValue("incompetitionuuidlist", (Object)str4);
        Note uuid = (Note)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(Note.class));
        note.setNoteuuid(uuid.getNoteuuid());
        return note;
    }
}

