/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.EmailAddressDAO;
import net.blugrid.core.model.EmailAddress;
import net.blugrid.core.model.Token;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EmailAddressDAOImpl
implements EmailAddressDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public EmailAddress postPartyEmailAddress(Token token, EmailAddress emailaddress, UUID partyuuid) {
        EmailAddress response = new EmailAddress();
        response = emailaddress;
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outemailuuid as emailuuid FROM proc_post_party_emailaddress (  :sessiontoken::t_pgpmessage,  :partyuuid::t_uuid,  :contactpurposetypecode::t_contactpurposetype,  :emailuuid::t_uuid,  :emailaddress::t_emailaddress,  :status::t_status ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("sessiontoken", (Object)token.getid_token());
        parameters.addValue("partyuuid", (Object)partyuuid);
        parameters.addValue("emailuuid", (Object)emailaddress.getEmailuuid());
        parameters.addValue("contactpurposetypecode", (Object)emailaddress.getContactpurposetypecode());
        parameters.addValue("emailaddress", (Object)emailaddress.getEmailaddress());
        parameters.addValue("status", (Object)emailaddress.getStatus());
        EmailAddress em = (EmailAddress)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(EmailAddress.class));
        emailaddress.setEmailuuid(em.getEmailuuid());
        return response;
    }

    @Override
    public EmailAddress postWebsitEmailAddress(Token token, EmailAddress emailaddress, UUID deviceuuid) {
        EmailAddress response = new EmailAddress();
        response = emailaddress;
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outemailuuid as emailuuid FROM proc_post_website_emailaddress (  :sessiontoken::t_pgpmessage,  :indeviceuuid::t_uuid,  :contactpurposetypecode::t_contactpurposetype,  :emailuuid::t_uuid,  :emailaddress::t_emailaddress,  :status::t_status ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("sessiontoken", (Object)token.getid_token());
        parameters.addValue("indeviceuuid", (Object)deviceuuid);
        parameters.addValue("emailuuid", (Object)emailaddress.getEmailuuid());
        parameters.addValue("contactpurposetypecode", (Object)emailaddress.getContactpurposetypecode());
        parameters.addValue("emailaddress", (Object)emailaddress.getEmailaddress());
        parameters.addValue("status", (Object)emailaddress.getStatus());
        EmailAddress em = (EmailAddress)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(EmailAddress.class));
        emailaddress.setEmailuuid(em.getEmailuuid());
        return response;
    }
}

