/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.CustomerReviewDAO;
import net.blugrid.core.model.CustomerReview;
import net.blugrid.core.model.CustomerReviewResponse;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.PostgresqlJson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CustomerReviewDAOImpl
implements CustomerReviewDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public CustomerReviewResponse post(Token token, CustomerReview customerreview) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json FROM proc_post_customerreview (  :sessiontoken::t_pgpmessage,  :incustomerreviewuuid::t_uuid,  :inpartyuuid::t_uuid,  :initemuuid::t_uuid,  :inreviewbody::t_html,  :inreviewrating::t_shortcount,  :inbestrating::t_shortcount,  :inworstrating::t_shortcount,  :inpublishedtimestamp::t_timestamp,  :inpublishedflag::t_flag,  :inreviewedtimestamp::t_timestamp,  :inreviewedflag::t_flag,  :status::t_status ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("sessiontoken", (Object)token.getid_token());
        parameters.addValue("incustomerreviewuuid", (Object)customerreview.getCustomerreviewuuid());
        parameters.addValue("inpartyuuid", (Object)customerreview.getPartyuuid());
        parameters.addValue("initemuuid", (Object)customerreview.getItemuuid());
        parameters.addValue("inreviewbody", (Object)customerreview.getReviewbody());
        parameters.addValue("inreviewrating", (Object)customerreview.getReviewrating());
        parameters.addValue("inbestrating", (Object)customerreview.getBestrating());
        parameters.addValue("inworstrating", (Object)customerreview.getBestrating());
        parameters.addValue("inpublishedtimestamp", (Object)customerreview.getPublishedtimestamp());
        parameters.addValue("inpublishedflag", (Object)customerreview.getPublishedflag());
        parameters.addValue("inreviewedtimestamp", (Object)customerreview.getReviewedtimestamp());
        parameters.addValue("inreviewedflag", (Object)customerreview.getReviewedflag());
        parameters.addValue("status", (Object)customerreview.getStatus());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        CustomerReviewResponse response = PostgresqlJson.jsonToCustomerReviewResponse((String)json.getJson());
        return response;
    }

    @Override
    public List<CustomerReview> postCustomerReviewList(Token token, List<CustomerReview> customerreviewList) {
        ArrayList<CustomerReview> response = new ArrayList<CustomerReview>();
        for (CustomerReview customerreview : customerreviewList) {
            CustomerReviewResponse resp = this.post(token, customerreview);
            if (!resp.getStatus().equalsIgnoreCase("OK")) continue;
            response.add(resp.getCustomerreview());
        }
        return response;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_customerreview(    :token::t_pgpmessage,    NULL::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_customerreview(    :token::t_pgpmessage,    :incustomerreviewuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("incustomerreviewuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }
}

