/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import javax.sql.DataSource;
import net.blugrid.core.dao.AdvertisementDAO;
import net.blugrid.core.model.Advertisement;
import net.blugrid.core.model.AdvertisementResponse;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.PostgresqlJson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AdvertisementDAOImpl
implements AdvertisementDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public AdvertisementResponse post(Token token, Advertisement advertisement) {
        AdvertisementResponse response = new AdvertisementResponse();
        if (advertisement.getAdvertisingsettuuid() == null) {
            response.setStatus("ERROR");
            response.setSource("AdvertisementDAOImpl");
            response.setMessage("No Advertising Set UUID.");
        } else {
            NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
            String sql = "SELECT outjson AS json from proc_post_audience(    :token::t_pgpmessage,    :inadvertisementuuid::t_uuid,   :inadvertisementname::t_name,    :inadvertisementtype::t_advertisementtype,    :inadvertisingsetuuid::t_uuid,    :inmessageuuid::t_uuid,    :instatus::t_status  ) ";
            MapSqlParameterSource parameters = new MapSqlParameterSource();
            parameters.addValue("token", (Object)token.getid_token());
            if (advertisement.getAdvertismentuuid() != null) {
                parameters.addValue("inadvertisementuuid", (Object)advertisement.getAdvertismentuuid());
            } else {
                parameters.addValue("inadvertisementuuid", null);
            }
            parameters.addValue("inadvertisementname", (Object)advertisement.getAdvertisementname());
            parameters.addValue("inadvertisementname", (Object)advertisement.getAdvertisementname());
            parameters.addValue("inadvertisementname", (Object)advertisement.getAdvertisementname());
            parameters.addValue("instatus", (Object)advertisement.getStatus());
            JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
            response = PostgresqlJson.jsonToAdvertisementResponse((JsonData)json);
        }
        return response;
    }
}

