/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.opentracing.faces.phase;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;

public class TracingPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private final transient ThreadLocal<Span> rootSpan = new ThreadLocal();
    private final transient ThreadLocal<Scope> rootScope = new ThreadLocal();
    private final transient ThreadLocal<Span> currentSpan = new ThreadLocal();
    private final transient ThreadLocal<Scope> currentScope = new ThreadLocal();
    private static final String TRACER_KEY = TracingPhaseListener.class.getName() + ".Tracer";

    public void beforePhase(PhaseEvent event) {
        Tracer tracer = this.getTracer();
        Span activeSpan = tracer.activeSpan();
        if (activeSpan == null) {
            activeSpan = tracer.buildSpan("Faces Lifecycle").start();
            Scope root = tracer.scopeManager().activate(activeSpan, false);
            this.rootScope.set(root);
            this.rootSpan.set(activeSpan);
        }
        Span span = tracer.buildSpan(event.getPhaseId().getName()).start();
        Scope scope = tracer.scopeManager().activate(span, false);
        this.currentScope.set(scope);
        this.currentSpan.set(span);
    }

    public void afterPhase(PhaseEvent event) {
        this.currentScope.get().close();
        this.currentScope.remove();
        this.currentSpan.get().finish();
        this.currentSpan.remove();
        if (event.getPhaseId() == PhaseId.RENDER_RESPONSE && this.rootSpan.get() != null) {
            this.rootScope.get().close();
            this.rootScope.remove();
            this.rootSpan.get().finish();
            this.rootSpan.remove();
        }
    }

    private Tracer getTracer() {
        Map request = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
        return (Tracer)request.computeIfAbsent(TRACER_KEY, ignore -> this.resolveTracer());
    }

    private Tracer resolveTracer() {
        Instance tracerInstance = CDI.current().getBeanManager().createInstance().select(Tracer.class, new Annotation[0]);
        if (!tracerInstance.isUnsatisfied()) {
            return (Tracer)tracerInstance.get();
        }
        return TracerResolver.resolveTracer();
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

