/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest.api;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.integrationtest.Assertions;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTest;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTestExtension;
import net.bis5.mattermost.client4.integrationtest.TestHelper;
import net.bis5.mattermost.model.ContentType;
import net.bis5.mattermost.model.IncomingWebhook;
import net.bis5.mattermost.model.OutgoingWebhook;
import net.bis5.mattermost.model.OutgoingWebhookList;
import net.bis5.mattermost.model.TriggerWhen;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={MattermostClientTestExtension.class})
class WebhooksApiTest
implements MattermostClientTest {
    private TestHelper th;
    private MattermostClient client;

    WebhooksApiTest() {
    }

    @Override
    public void setHelper(TestHelper helper) {
        this.th = helper;
    }

    @BeforeEach
    void setup() {
        this.client = this.createClient();
        this.th.changeClient(this.client).initBasic();
    }

    @AfterEach
    void tearDown() {
        this.th.logout();
        this.client.close();
    }

    @Test
    void createIncomingWebhook() {
        this.th.logout().loginTeamAdmin();
        String channelId = this.th.basicChannel().getId();
        String displayName = "webhook" + this.th.newId();
        String description = "description" + this.th.newId();
        IncomingWebhook webhook = new IncomingWebhook();
        webhook.setChannelId(channelId);
        webhook.setDisplayName(displayName);
        webhook.setDescription(description);
        ApiResponse response = Assertions.assertNoError(this.client.createIncomingWebhook(webhook));
        webhook = (IncomingWebhook)response.readEntity();
        MatcherAssert.assertThat((Object)webhook.getId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)webhook.getChannelId(), (Matcher)CoreMatchers.is((Object)channelId));
        MatcherAssert.assertThat((Object)webhook.getDisplayName(), (Matcher)CoreMatchers.is((Object)displayName));
        MatcherAssert.assertThat((Object)webhook.getDescription(), (Matcher)CoreMatchers.is((Object)description));
    }

    @Test
    void listIncomingWebhooks() {
        this.th.logout().loginTeamAdmin();
        String channelId = this.th.basicChannel().getId();
        IncomingWebhook webhook1 = new IncomingWebhook();
        webhook1.setChannelId(channelId);
        IncomingWebhook webhook2 = new IncomingWebhook();
        webhook2.setChannelId(channelId);
        webhook1 = (IncomingWebhook)Assertions.assertNoError(this.client.createIncomingWebhook(webhook1)).readEntity();
        webhook2 = (IncomingWebhook)Assertions.assertNoError(this.client.createIncomingWebhook(webhook2)).readEntity();
        this.th.loginSystemAdmin();
        ApiResponse response = Assertions.assertNoError(this.client.getIncomingWebhooks());
        List webhooks = (List)response.readEntity();
        MatcherAssert.assertThat((Object)webhooks.size(), (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2))));
        MatcherAssert.assertThat(webhooks.stream().map(IncomingWebhook::getId).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItems((Object[])new String[]{webhook1.getId(), webhook2.getId()}));
    }

    @Test
    void listIncomingWebhooksForTeam() {
        this.th.logout().loginTeamAdmin();
        String channelId = this.th.basicChannel().getId();
        String teamId = this.th.basicTeam().getId();
        IncomingWebhook webhook1 = new IncomingWebhook();
        webhook1.setChannelId(channelId);
        IncomingWebhook webhook2 = new IncomingWebhook();
        webhook2.setChannelId(channelId);
        webhook1 = (IncomingWebhook)Assertions.assertNoError(this.client.createIncomingWebhook(webhook1)).readEntity();
        webhook2 = (IncomingWebhook)Assertions.assertNoError(this.client.createIncomingWebhook(webhook2)).readEntity();
        ApiResponse response = Assertions.assertNoError(this.client.getIncomingWebhooksForTeam(teamId));
        List webhooks = (List)response.readEntity();
        MatcherAssert.assertThat((Object)webhooks.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(webhooks.stream().map(IncomingWebhook::getId).collect(Collectors.toSet()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{webhook1.getId(), webhook2.getId()}));
    }

    @Test
    void getIncomingWebhook() {
        this.th.logout().loginTeamAdmin();
        String channelId = this.th.basicChannel().getId();
        IncomingWebhook webhook = new IncomingWebhook();
        webhook.setChannelId(channelId);
        webhook = (IncomingWebhook)Assertions.assertNoError(this.client.createIncomingWebhook(webhook)).readEntity();
        String webhookId = webhook.getId();
        ApiResponse response = Assertions.assertNoError(this.client.getIncomingWebhook(webhookId));
        IncomingWebhook responseWebhook = (IncomingWebhook)response.readEntity();
        MatcherAssert.assertThat((Object)responseWebhook, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)responseWebhook.getId(), (Matcher)CoreMatchers.is((Object)webhookId));
    }

    @Test
    void updateIncomingWebhook() {
        this.th.logout().loginTeamAdmin();
        String channelId = this.th.basicChannel().getId();
        IncomingWebhook webhook = new IncomingWebhook();
        webhook.setChannelId(channelId);
        webhook.setDisplayName(this.th.newRandomString(32));
        webhook.setDescription(this.th.newRandomString(32));
        webhook = (IncomingWebhook)Assertions.assertNoError(this.client.createIncomingWebhook(webhook)).readEntity();
        String newDisplayName = "new" + webhook.getDisplayName();
        String newDescription = "new" + webhook.getDescription();
        String newChannelId = this.th.basicChannel2().getId();
        webhook.setDisplayName(newDisplayName);
        webhook.setDescription(newDescription);
        webhook.setChannelId(newChannelId);
        ApiResponse response = Assertions.assertNoError(this.client.updateIncomingWebhook(webhook));
        IncomingWebhook updatedWebhook = (IncomingWebhook)response.readEntity();
        MatcherAssert.assertThat((Object)updatedWebhook.getDisplayName(), (Matcher)CoreMatchers.is((Object)webhook.getDisplayName()));
        MatcherAssert.assertThat((Object)updatedWebhook.getDescription(), (Matcher)CoreMatchers.is((Object)webhook.getDescription()));
        MatcherAssert.assertThat((Object)updatedWebhook.getChannelId(), (Matcher)CoreMatchers.is((Object)webhook.getChannelId()));
    }

    @Test
    void deleteIncomingWebhook() {
        this.th.logout().loginTeamAdmin();
        String channelId = this.th.basicChannel().getId();
        IncomingWebhook webhook = new IncomingWebhook();
        webhook.setChannelId(channelId);
        webhook.setDisplayName(this.th.newRandomString(32));
        webhook.setDescription(this.th.newRandomString(32));
        webhook = (IncomingWebhook)Assertions.assertNoError(this.client.createIncomingWebhook(webhook)).readEntity();
        ApiResponse deleteResult = Assertions.assertNoError(this.client.deleteIncomingWebhook(webhook.getId()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)deleteResult.readEntity()));
    }

    @Test
    void createOutgoingWebhook() {
        this.th.logout().loginTeamAdmin();
        String teamId = this.th.basicTeam().getId();
        String channelId = this.th.basicChannel().getId();
        String description = this.th.newRandomString(32);
        String displayName = this.th.newRandomString(32);
        String triggerWord = "trigger";
        TriggerWhen triggerWhen = TriggerWhen.CONTAINS;
        String callbackUrl = "http://callback-url";
        ContentType contentType = ContentType.FORM;
        OutgoingWebhook webhook = new OutgoingWebhook();
        webhook.setTeamId(teamId);
        webhook.setChannelId(channelId);
        webhook.setDescription(description);
        webhook.setDisplayName(displayName);
        webhook.setTriggerWords(Arrays.asList(triggerWord));
        webhook.setTriggerWhen(triggerWhen);
        webhook.setCallbackUrls(Arrays.asList(callbackUrl));
        webhook.setContentType(contentType);
        ApiResponse response = Assertions.assertNoError(this.client.createOutgoingWebhook(webhook));
        OutgoingWebhook created = (OutgoingWebhook)response.readEntity();
        MatcherAssert.assertThat((Object)created.getId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)created.getTeamId(), (Matcher)CoreMatchers.is((Object)webhook.getTeamId()));
        MatcherAssert.assertThat((Object)created.getChannelId(), (Matcher)CoreMatchers.is((Object)webhook.getChannelId()));
        MatcherAssert.assertThat((Object)created.getDescription(), (Matcher)CoreMatchers.is((Object)webhook.getDescription()));
        MatcherAssert.assertThat((Object)created.getDisplayName(), (Matcher)CoreMatchers.is((Object)webhook.getDisplayName()));
        MatcherAssert.assertThat((Object)created.getTriggerWords(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])webhook.getTriggerWords().toArray()));
        MatcherAssert.assertThat((Object)created.getTriggerWhen(), (Matcher)CoreMatchers.is((Object)webhook.getTriggerWhen()));
        MatcherAssert.assertThat((Object)created.getCallbackUrls(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])webhook.getCallbackUrls().toArray()));
        MatcherAssert.assertThat((Object)created.getContentType(), (Matcher)CoreMatchers.is((Object)webhook.getContentType()));
    }

    @Test
    void listOutgoingWebhooks() {
        String teamId = this.th.basicTeam().getId();
        String displayName = this.th.newRandomString(32);
        List<String> callbackUrls = Arrays.asList("http://callback-url");
        this.th.logout().loginTeamAdmin();
        OutgoingWebhook webhook1 = new OutgoingWebhook();
        webhook1.setTeamId(teamId);
        webhook1.setDisplayName(displayName);
        webhook1.setTriggerWords(Arrays.asList("trigger" + this.th.newRandomString(10)));
        webhook1.setCallbackUrls(callbackUrls);
        webhook1 = (OutgoingWebhook)Assertions.assertNoError(this.client.createOutgoingWebhook(webhook1)).readEntity();
        OutgoingWebhook webhook2 = new OutgoingWebhook();
        webhook2.setTeamId(teamId);
        webhook2.setDisplayName(displayName);
        webhook2.setTriggerWords(Arrays.asList("trigger" + this.th.newRandomString(10)));
        webhook2.setCallbackUrls(callbackUrls);
        webhook2 = (OutgoingWebhook)Assertions.assertNoError(this.client.createOutgoingWebhook(webhook2)).readEntity();
        this.th.loginSystemAdmin();
        ApiResponse response = Assertions.assertNoError(this.client.getOutgoingWebhooks());
        List webhooks = (List)response.readEntity();
        MatcherAssert.assertThat(webhooks.stream().map(OutgoingWebhook::getId).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItems((Object[])new String[]{webhook1.getId(), webhook2.getId()}));
    }

    @Test
    void listOutgoingWebhooksForTeam() {
        this.th.logout().loginTeamAdmin();
        String teamId = this.th.basicTeam().getId();
        String displayName = this.th.newRandomString(32);
        List<String> triggerWords = Arrays.asList("trigger");
        List<String> callbackUrls = Arrays.asList("http://callback-url");
        OutgoingWebhook webhook = new OutgoingWebhook();
        webhook.setTeamId(teamId);
        webhook.setDisplayName(displayName);
        webhook.setTriggerWords(triggerWords);
        webhook.setCallbackUrls(callbackUrls);
        webhook = (OutgoingWebhook)Assertions.assertNoError(this.client.createOutgoingWebhook(webhook)).readEntity();
        ApiResponse response = Assertions.assertNoError(this.client.getOutgoingWebhooksForTeam(teamId));
        List webhooks = (List)response.readEntity();
        MatcherAssert.assertThat(webhooks.stream().map(OutgoingWebhook::getId).collect(Collectors.toSet()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{webhook.getId()}));
    }

    @Test
    void listOutgoingWebhooksForChannel() {
        this.th.logout().loginTeamAdmin();
        String teamId = this.th.basicTeam().getId();
        String channelId = this.th.basicChannel().getId();
        String displayName = this.th.newRandomString(32);
        List<String> callbackUrls = Arrays.asList("http://callback-url");
        OutgoingWebhook webhook = new OutgoingWebhook();
        webhook.setTeamId(teamId);
        webhook.setChannelId(channelId);
        webhook.setDisplayName(displayName);
        webhook.setTriggerWords(Arrays.asList("trigger" + this.th.newRandomString(10)));
        webhook.setCallbackUrls(callbackUrls);
        webhook = (OutgoingWebhook)Assertions.assertNoError(this.client.createOutgoingWebhook(webhook)).readEntity();
        OutgoingWebhook otherChannelHook = new OutgoingWebhook();
        otherChannelHook.setTeamId(teamId);
        otherChannelHook.setChannelId(this.th.basicChannel2().getId());
        otherChannelHook.setDisplayName(displayName);
        otherChannelHook.setTriggerWords(Arrays.asList("trigger" + this.th.newRandomString(10)));
        otherChannelHook.setCallbackUrls(callbackUrls);
        otherChannelHook = (OutgoingWebhook)Assertions.assertNoError(this.client.createOutgoingWebhook(otherChannelHook)).readEntity();
        OutgoingWebhook noChannelHook = new OutgoingWebhook();
        noChannelHook.setTeamId(teamId);
        noChannelHook.setDisplayName(displayName);
        noChannelHook.setTriggerWords(Arrays.asList("trigger" + this.th.newRandomString(10)));
        noChannelHook.setCallbackUrls(callbackUrls);
        noChannelHook = (OutgoingWebhook)Assertions.assertNoError(this.client.createOutgoingWebhook(noChannelHook)).readEntity();
        ApiResponse response = Assertions.assertNoError(this.client.getOutgoingWebhooksForChannel(channelId));
        List webhooks = (List)response.readEntity();
        MatcherAssert.assertThat(webhooks.stream().map(OutgoingWebhook::getId).collect(Collectors.toSet()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{webhook.getId()}));
    }

    @Test
    void getOutgoingWebhook() {
        this.th.logout().loginTeamAdmin();
        OutgoingWebhook webhook = new OutgoingWebhook();
        webhook.setTeamId(this.th.basicTeam().getId());
        webhook.setDisplayName(this.th.newRandomString(32));
        webhook.setTriggerWords(Arrays.asList("trigger"));
        webhook.setCallbackUrls(Arrays.asList("http://callback-url"));
        webhook = (OutgoingWebhook)Assertions.assertNoError(this.client.createOutgoingWebhook(webhook)).readEntity();
        String webhookId = webhook.getId();
        ApiResponse response = Assertions.assertNoError(this.client.getOutgoingWebhook(webhookId));
        OutgoingWebhook responseWebhook = (OutgoingWebhook)response.readEntity();
        MatcherAssert.assertThat((Object)responseWebhook.getId(), (Matcher)CoreMatchers.is((Object)webhookId));
    }

    @Test
    void deleteOutgoingWebhook() {
        this.th.logout().loginTeamAdmin();
        OutgoingWebhook webhook = new OutgoingWebhook();
        webhook.setTeamId(this.th.basicTeam().getId());
        webhook.setDisplayName(this.th.newRandomString(32));
        webhook.setTriggerWords(Arrays.asList("trigger"));
        webhook.setCallbackUrls(Arrays.asList("http://callback-url"));
        webhook = (OutgoingWebhook)Assertions.assertNoError(this.client.createOutgoingWebhook(webhook)).readEntity();
        String webhookId = webhook.getId();
        ApiResponse response = Assertions.assertNoError(this.client.deleteOutgoingWebhook(webhookId));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(((OutgoingWebhookList)this.client.getOutgoingWebhooksForTeam(this.th.basicTeam().getId()).readEntity()).stream().map(OutgoingWebhook::getId).collect(Collectors.toSet()), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)webhookId)));
    }

    @Test
    void updateOutgoingWebhook() {
        this.th.logout().loginTeamAdmin();
        OutgoingWebhook webhook = new OutgoingWebhook();
        webhook.setTeamId(this.th.basicTeam().getId());
        webhook.setDisplayName(this.th.newRandomString(32));
        webhook.setTriggerWords(Arrays.asList("trigger"));
        webhook.setCallbackUrls(Arrays.asList("http://callback-url"));
        webhook = (OutgoingWebhook)Assertions.assertNoError(this.client.createOutgoingWebhook(webhook)).readEntity();
        webhook.setChannelId(this.th.basicChannel().getId());
        webhook.setDisplayName("update" + webhook.getDisplayName());
        webhook.setDescription("update");
        ApiResponse response = Assertions.assertNoError(this.client.updateOutgoingWebhook(webhook));
        OutgoingWebhook updated = (OutgoingWebhook)response.readEntity();
        MatcherAssert.assertThat((Object)updated.getId(), (Matcher)CoreMatchers.is((Object)webhook.getId()));
        MatcherAssert.assertThat((Object)updated.getChannelId(), (Matcher)CoreMatchers.is((Object)webhook.getChannelId()));
        MatcherAssert.assertThat((Object)updated.getDisplayName(), (Matcher)CoreMatchers.is((Object)webhook.getDisplayName()));
        MatcherAssert.assertThat((Object)updated.getDescription(), (Matcher)CoreMatchers.is((Object)webhook.getDescription()));
    }

    @Test
    void regenerateOutgoingWebhookToken() {
        this.th.logout().loginTeamAdmin();
        OutgoingWebhook webhook = new OutgoingWebhook();
        webhook.setTeamId(this.th.basicTeam().getId());
        webhook.setDisplayName(this.th.newRandomString(32));
        webhook.setTriggerWords(Arrays.asList("trigger"));
        webhook.setCallbackUrls(Arrays.asList("http://callback-url"));
        webhook = (OutgoingWebhook)Assertions.assertNoError(this.client.createOutgoingWebhook(webhook)).readEntity();
        String currentToken = webhook.getToken();
        ApiResponse response = Assertions.assertNoError(this.client.regenOutgoingHookToken(webhook.getId()));
        OutgoingWebhook updated = (OutgoingWebhook)response.readEntity();
        String newToken = updated.getToken();
        MatcherAssert.assertThat((Object)newToken, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)currentToken)));
    }
}

