/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest.api;

import jakarta.ws.rs.core.Response;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.Pager;
import net.bis5.mattermost.client4.integrationtest.Assertions;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTest;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTestExtension;
import net.bis5.mattermost.client4.integrationtest.TestHelper;
import net.bis5.mattermost.client4.model.UsersOrder;
import net.bis5.mattermost.model.Audit;
import net.bis5.mattermost.model.Audits;
import net.bis5.mattermost.model.AuthService;
import net.bis5.mattermost.model.Channel;
import net.bis5.mattermost.model.Config;
import net.bis5.mattermost.model.Role;
import net.bis5.mattermost.model.Session;
import net.bis5.mattermost.model.SessionList;
import net.bis5.mattermost.model.Status;
import net.bis5.mattermost.model.StatusType;
import net.bis5.mattermost.model.SwitchRequest;
import net.bis5.mattermost.model.Team;
import net.bis5.mattermost.model.User;
import net.bis5.mattermost.model.UserAccessToken;
import net.bis5.mattermost.model.UserAccessTokenList;
import net.bis5.mattermost.model.UserAutocomplete;
import net.bis5.mattermost.model.UserList;
import net.bis5.mattermost.model.UserPatch;
import net.bis5.mattermost.model.UserSearch;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsEmptyIterable;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={MattermostClientTestExtension.class})
class UsersApiTest
implements MattermostClientTest {
    private TestHelper th;
    private MattermostClient client;

    UsersApiTest() {
    }

    @Override
    public void setHelper(TestHelper helper) {
        this.th = helper;
    }

    @BeforeEach
    void setup() {
        this.client = this.createClient();
        this.th.changeClient(this.client).initBasic();
    }

    @AfterEach
    void tearDown() {
        this.th.logout();
        this.client.close();
    }

    @Test
    void createUser() {
        User user = new User();
        user.setEmail(this.th.generateTestEmail());
        user.setUsername(this.th.generateTestUsername());
        user.setPassword("The_Passw0rd");
        ApiResponse response = Assertions.assertNoError(this.client.createUser(user));
        User created = (User)response.readEntity();
        MatcherAssert.assertThat((Object)created.getEmail(), (Matcher)CoreMatchers.is((Object)user.getEmail()));
        MatcherAssert.assertThat((Object)created.getUsername(), (Matcher)CoreMatchers.is((Object)user.getUsername()));
    }

    @Test
    void getUsers() {
        ApiResponse response = Assertions.assertNoError(this.client.getUsers(Pager.of((int)0, (int)60), null));
        List users = (List)response.readEntity();
        MatcherAssert.assertThat((Object)users, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)IsEmptyIterable.emptyIterable())));
    }

    @Test
    void getUsers_InChannel() {
        this.th.loginBasic();
        Channel channel = this.th.createPublicChannel();
        Assertions.assertNoError(this.client.addChannelMember(channel.getId(), this.th.basicUser2().getId()));
        ApiResponse response = Assertions.assertNoError(this.client.getUsersInChannel(channel.getId(), Pager.of((int)0, (int)60), null));
        List users = (List)response.readEntity();
        MatcherAssert.assertThat(users.stream().map(User::getId).collect(Collectors.toSet()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{this.th.basicUser().getId(), this.th.basicUser2().getId()}));
    }

    @Test
    void getUsers_InChannel_Order() {
        this.th.logout().loginSystemAdmin();
        User user1 = this.th.createUser("order1_" + this.th.newId());
        this.th.linkUserToTeam(user1, this.th.basicTeam());
        User user2 = this.th.createUser("order2_" + this.th.newId());
        this.th.linkUserToTeam(user2, this.th.basicTeam());
        User user3 = this.th.createUser("order3_" + this.th.newId());
        this.th.linkUserToTeam(user3, this.th.basicTeam());
        User user4 = this.th.createUser("order4_" + this.th.newId());
        this.th.linkUserToTeam(user4, this.th.basicTeam());
        Status status = new Status();
        status.setStatus(StatusType.ONLINE.getCode());
        status.setUserId(user4.getId());
        Assertions.assertNoError(this.client.updateUserStatus(user4.getId(), status));
        status.setStatus(StatusType.AWAY.getCode());
        status.setUserId(user3.getId());
        Assertions.assertNoError(this.client.updateUserStatus(user3.getId(), status));
        status.setStatus(StatusType.DND.getCode());
        status.setUserId(user2.getId());
        Assertions.assertNoError(this.client.updateUserStatus(user2.getId(), status));
        status.setStatus(StatusType.OFFLINE.getCode());
        status.setUserId(user1.getId());
        Assertions.assertNoError(this.client.updateUserStatus(user1.getId(), status));
        this.th.logout().loginAs(user1);
        List<String> expectedIdsByUsername = Arrays.asList(user1.getId(), user2.getId(), user3.getId(), user4.getId());
        List<String> expectedIdsByStatus = Arrays.asList(user4.getId(), user3.getId(), user2.getId(), user1.getId());
        Channel channel = this.th.createPublicChannel();
        Assertions.assertNoError(this.client.addChannelMember(channel.getId(), user2.getId()));
        Assertions.assertNoError(this.client.addChannelMember(channel.getId(), user3.getId()));
        Assertions.assertNoError(this.client.addChannelMember(channel.getId(), user4.getId()));
        UserList usersByUsername = (UserList)Assertions.assertNoError(this.client.getUsersInChannel(channel.getId(), UsersOrder.InChannel.NONE, Pager.defaultPager())).readEntity();
        List ids = usersByUsername.stream().map(User::getId).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertIterableEquals(expectedIdsByUsername, ids);
        UserList usersByStatus = (UserList)Assertions.assertNoError(this.client.getUsersInChannel(channel.getId(), UsersOrder.InChannel.STATUS, Pager.defaultPager())).readEntity();
        ids = usersByStatus.stream().map(User::getId).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertIterableEquals(expectedIdsByStatus, ids);
    }

    @Test
    void getUsers_NotInChannel() {
        HashSet<String> notInChannelUserIds = new HashSet<String>(Arrays.asList(this.th.basicUser().getId(), this.th.basicUser2().getId(), this.th.teamAdminUser().getId()));
        this.th.loginBasic();
        Channel channel = this.th.createPublicChannel();
        notInChannelUserIds.remove(this.th.basicUser().getId());
        ApiResponse response = Assertions.assertNoError(this.client.getUsersNotInChannel(this.th.basicTeam().getId(), channel.getId(), Pager.of((int)0, (int)60), null));
        List users = (List)response.readEntity();
        MatcherAssert.assertThat(users.stream().map(User::getId).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItems((Object[])notInChannelUserIds.toArray(new String[0])));
    }

    @Test
    void getUsers_InTeam() {
        User notInTeamUser = this.th.loginSystemAdmin().createUser();
        HashSet<String> inTeamUserIds = new HashSet<String>(Arrays.asList(this.th.basicUser().getId(), this.th.basicUser2().getId(), this.th.teamAdminUser().getId()));
        this.th.loginBasic();
        ApiResponse response = Assertions.assertNoError(this.client.getUsersInTeam(this.th.basicTeam().getId(), Pager.of((int)0, (int)60), null));
        List users = (List)response.readEntity();
        Set userIds = users.stream().map(User::getId).collect(Collectors.toSet());
        MatcherAssert.assertThat(userIds, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItems((Object[])new String[]{notInTeamUser.getId()})));
        MatcherAssert.assertThat(userIds, (Matcher)CoreMatchers.hasItems((Object[])inTeamUserIds.toArray(new String[0])));
    }

    @Test
    void getUsers_InTeam_Order() {
        this.th.logout().loginSystemAdmin();
        User user1 = this.th.createUser("order1_" + this.th.newId());
        this.th.logout().loginAs(user1);
        Team team = this.th.createTeam();
        User user2 = this.th.createUser("order2_" + this.th.newId());
        User user3 = this.th.createUser("order3_" + this.th.newId());
        this.th.linkUserToTeam(user2, team);
        this.th.linkUserToTeam(user3, team);
        List<String> expectedIdsByCreateAt = Arrays.asList(user3.getId(), user2.getId(), user1.getId());
        List<String> expectedIdsByUsername = Arrays.asList(user1.getId(), user2.getId(), user3.getId());
        UserList users = (UserList)Assertions.assertNoError(this.client.getUsersInTeam(team.getId(), UsersOrder.InTeam.CREATE_AT, Pager.defaultPager())).readEntity();
        List ids = users.stream().map(User::getId).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertIterableEquals(expectedIdsByCreateAt, ids);
        users = (UserList)Assertions.assertNoError(this.client.getUsersInTeam(team.getId(), UsersOrder.InTeam.NONE, Pager.defaultPager())).readEntity();
        ids = users.stream().map(User::getId).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertIterableEquals(expectedIdsByUsername, ids);
    }

    @Test
    void getUsers_NotInTeam() {
        this.th.loginBasic();
        HashSet<String> inTeamUserIds = new HashSet<String>(Arrays.asList(this.th.basicUser().getId(), this.th.basicUser2().getId(), this.th.systemAdminUser().getId(), this.th.teamAdminUser().getId()));
        ApiResponse response = Assertions.assertNoError(this.client.getUsersNotInTeam(this.th.basicTeam().getId(), Pager.of((int)0, (int)60), null));
        List users = (List)response.readEntity();
        MatcherAssert.assertThat(users.stream().map(User::getId).collect(Collectors.toSet()), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItems((Object[])inTeamUserIds.toArray(new String[0]))));
    }

    @Test
    void getUsers_WithoutTeam() {
        User withoutTeamUser = this.th.loginSystemAdmin().createUser();
        this.th.loginSystemAdmin();
        ApiResponse response = Assertions.assertNoError(this.client.getUsersWithoutTeam(Pager.of((int)0, (int)60), null));
        List users = (List)response.readEntity();
        MatcherAssert.assertThat(users.stream().map(User::getId).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItem((Object)withoutTeamUser.getId()));
    }

    @Test
    void getUsersByIds() {
        ApiResponse response = Assertions.assertNoError(this.client.getUsersByIds(new String[]{this.th.basicUser().getId(), this.th.basicUser2().getId()}));
        List users = (List)response.readEntity();
        MatcherAssert.assertThat(users.stream().map(User::getId).collect(Collectors.toSet()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{this.th.basicUser().getId(), this.th.basicUser2().getId()}));
    }

    @Test
    void getUsersByUsernames() {
        ApiResponse response = Assertions.assertNoError(this.client.getUsersByUsernames(new String[]{this.th.basicUser().getUsername(), this.th.basicUser2().getUsername()}));
        List users = (List)response.readEntity();
        MatcherAssert.assertThat(users.stream().map(User::getId).collect(Collectors.toSet()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{this.th.basicUser().getId(), this.th.basicUser2().getId()}));
    }

    @Test
    void searchUsers() {
        UserSearch criteria = UserSearch.builder().term(this.th.basicUser().getUsername()).teamId(this.th.basicTeam().getId()).build();
        ApiResponse response = Assertions.assertNoError(this.client.searchUsers(criteria));
        List users = (List)response.readEntity();
        MatcherAssert.assertThat(users.stream().map(User::getUsername).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItem((Object)this.th.basicUser().getUsername()));
    }

    @Test
    void autocompleteUsers() {
        ApiResponse response = Assertions.assertNoError(this.client.autocompleteUsers(this.th.basicUser().getUsername(), null));
        UserAutocomplete autocompleteUsers = (UserAutocomplete)response.readEntity();
        MatcherAssert.assertThat(autocompleteUsers.getUsers().stream().map(User::getId).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItem((Object)this.th.basicUser().getId()));
    }

    @Test
    void autocompleteUsers_InTeam() {
        ApiResponse response = Assertions.assertNoError(this.client.autocompleteUsersInTeam(this.th.basicTeam().getId(), this.th.basicUser().getUsername(), null));
        UserAutocomplete autocompleteUsers = (UserAutocomplete)response.readEntity();
        MatcherAssert.assertThat(autocompleteUsers.getUsers().stream().map(User::getId).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItem((Object)this.th.basicUser().getId()));
    }

    @Test
    void autocompleteUsers_InChannel() {
        Channel channel = this.th.createPublicChannel();
        ApiResponse response = Assertions.assertNoError(this.client.autocompleteUsersInChannel(this.th.basicTeam().getId(), channel.getId(), null, null));
        UserAutocomplete autocompleteUsers = (UserAutocomplete)response.readEntity();
        MatcherAssert.assertThat(autocompleteUsers.getUsers().stream().map(User::getId).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItem((Object)this.th.basicUser().getId()));
        MatcherAssert.assertThat(autocompleteUsers.getOutOfChannel().stream().map(User::getId).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItem((Object)this.th.basicUser2().getId()));
    }

    @Test
    void getUser() {
        String userId = this.th.basicUser().getId();
        ApiResponse response = Assertions.assertNoError(this.client.getUser(userId, null));
        User user = (User)response.readEntity();
        MatcherAssert.assertThat((Object)user.getId(), (Matcher)CoreMatchers.is((Object)userId));
    }

    @Test
    void updateUser() {
        User user = this.th.basicUser();
        String firstName = "newFirst" + user.getFirstName();
        String lastName = "newLast" + user.getLastName();
        user.setFirstName(firstName);
        user.setLastName(lastName);
        ApiResponse response = Assertions.assertNoError(this.client.updateUser(user));
        user = (User)response.readEntity();
        MatcherAssert.assertThat((Object)user.getFirstName(), (Matcher)CoreMatchers.is((Object)firstName));
        MatcherAssert.assertThat((Object)user.getLastName(), (Matcher)CoreMatchers.is((Object)lastName));
    }

    @Test
    void deactivateUser() {
        this.th.loginSystemAdmin();
        String userId = this.th.basicUser().getId();
        ApiResponse response = Assertions.assertNoError(this.client.deleteUser(userId));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void patchUser() {
        UserPatch patch = new UserPatch();
        String firstName = "newFirst" + this.th.basicUser().getFirstName();
        String lastName = "newLast" + this.th.basicUser().getLastName();
        patch.setFirstName(firstName);
        patch.setLastName(lastName);
        ApiResponse response = Assertions.assertNoError(this.client.patchUser(this.th.basicUser().getId(), patch));
        User user = (User)response.readEntity();
        MatcherAssert.assertThat((Object)user.getFirstName(), (Matcher)CoreMatchers.is((Object)firstName));
        MatcherAssert.assertThat((Object)user.getLastName(), (Matcher)CoreMatchers.is((Object)lastName));
    }

    @Test
    void patchEmailForCurrentUserWithPassword() {
        this.th.logout().loginSystemAdmin();
        UserPatch patch = new UserPatch();
        patch.setEmail("newemail" + this.th.systemAdminUser().getId() + "@inbucket.local");
        patch.setPassword(this.th.systemAdminUser().getPassword());
        try {
            ApiResponse response = Assertions.assertNoError(this.client.patchUser("me", patch));
            org.junit.jupiter.api.Assertions.assertEquals((Object)patch.getEmail(), (Object)((User)response.readEntity()).getEmail());
        }
        finally {
            patch.setEmail(this.th.systemAdminUser().getEmail());
            this.client.patchUser("me", patch);
        }
    }

    @Test
    void patchEmailForOtherUserWithoutPassword() {
        this.th.logout().loginSystemAdmin();
        UserPatch patch = new UserPatch();
        patch.setEmail("newemail" + this.th.basicUser().getId() + "@inbucket.local");
        try {
            ApiResponse response = Assertions.assertNoError(this.client.patchUser(this.th.basicUser().getId(), patch));
            org.junit.jupiter.api.Assertions.assertEquals((Object)patch.getEmail(), (Object)((User)response.readEntity()).getEmail());
        }
        finally {
            patch.setEmail(this.th.systemAdminUser().getEmail());
            this.client.patchUser(this.th.basicUser().getId(), patch);
        }
    }

    @Test
    void updateUserRoles() {
        this.th.loginSystemAdmin();
        ApiResponse response = Assertions.assertNoError(this.client.updateUserRoles(this.th.basicUser().getId(), new Role[]{Role.SYSTEM_ADMIN, Role.SYSTEM_USER}));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void updateUserActiveStatus() {
        this.th.logout().loginSystemAdmin();
        ApiResponse response = Assertions.assertNoError(this.client.updateUserActive(this.th.basicUser().getId(), false));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void getUserProfileImage() throws FileNotFoundException, IOException {
        ApiResponse response = Assertions.assertNoError(this.client.getProfileImage(this.th.basicUser().getId(), null));
        byte[] image = (byte[])response.readEntity();
        Path tempFile = Files.createTempFile("mm", ".png", new FileAttribute[0]);
        System.out.println(tempFile);
        try (FileOutputStream fout = new FileOutputStream(tempFile.toFile());){
            fout.write(image);
        }
    }

    @Test
    void setUserProfileImage() throws URISyntaxException, IOException {
        Path image = this.th.getResourcePath("/noto-emoji_u1f310.png");
        ApiResponse response = Assertions.assertNoError(this.client.setProfileImage(this.th.basicUser().getId(), image));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void deleteUserProfileImage() throws URISyntaxException, IOException {
        Path image = this.th.getResourcePath("/noto-emoji_u1f6a7.png");
        ApiResponse uploadResult = Assertions.assertNoError(this.client.setProfileImage(this.th.basicUser().getId(), image));
        if (Assertions.isNotSupportVersion("5.6.0", uploadResult)) {
            return;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)uploadResult.readEntity()));
        ApiResponse deleteResult = Assertions.assertNoError(this.client.deleteProfileImage(this.th.basicUser().getId()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)deleteResult.readEntity()));
    }

    @Test
    void getUserByName() {
        String username = this.th.basicUser().getUsername();
        ApiResponse response = Assertions.assertNoError(this.client.getUserByUsername(username, null));
        User user = (User)response.readEntity();
        MatcherAssert.assertThat((Object)user.getId(), (Matcher)CoreMatchers.is((Object)this.th.basicUser().getId()));
    }

    @Test
    void resetPassword() {
        Assertions.assertStatus(this.client.resetPassword(this.th.newRandomString(64), "The_Passw0rd".concat("_Modify")), Response.Status.BAD_REQUEST);
    }

    @Test
    void updateUserMfa() {
        Assertions.assertStatus(this.client.updateUserMfa(this.th.basicUser().getId(), "code", true), Response.Status.NOT_IMPLEMENTED);
    }

    @Test
    void generateMfaSecret() {
        this.th.loginSystemAdmin();
        Assertions.assertStatus(this.client.generateMfaSecret(this.th.basicUser().getId()), Response.Status.NOT_IMPLEMENTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void checkMfa() {
        this.th.logout().loginSystemAdmin();
        ApiResponse configResponse = this.client.getConfig();
        Config config = (Config)configResponse.readEntity();
        if (Assertions.isRemovedVersion("6.0.0", configResponse)) {
            return;
        }
        if (Assertions.isSupportVersion("5.9.0", configResponse)) {
            config.getServiceSettings().setDisableLegacyMfa(false);
            Assertions.assertNoError(this.client.updateConfig(config));
        }
        try {
            this.th.logout().loginBasic();
            boolean mfaRequired = this.client.checkUserMfa(this.th.basicUser().getId());
            MatcherAssert.assertThat((Object)mfaRequired, (Matcher)CoreMatchers.is((Object)false));
        }
        finally {
            if (Assertions.isSupportVersion("5.9.0", configResponse)) {
                this.th.logout().loginSystemAdmin();
                config = (Config)this.client.getConfig().readEntity();
                config.getServiceSettings().setDisableLegacyMfa(true);
                Assertions.assertNoError(this.client.updateConfig(config));
            }
        }
    }

    @Test
    void checkMfaThrowsExceptionDisableLegacyMfa() {
        this.th.logout().loginSystemAdmin();
        ApiResponse configResponse = this.client.getConfig();
        if (Assertions.isNotSupportVersion("5.9.0", configResponse)) {
            return;
        }
        Config config = (Config)configResponse.readEntity();
        config.getServiceSettings().setDisableLegacyMfa(true);
        Assertions.assertNoError(this.client.updateConfig(config));
        try {
            org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> this.client.checkUserMfa(this.th.basicUser().getId()));
        }
        finally {
            this.th.logout().loginSystemAdmin();
            config = (Config)this.client.getConfig().readEntity();
            config.getServiceSettings().setDisableLegacyMfa(false);
            Assertions.assertNoError(this.client.updateConfig(config));
        }
    }

    @Test
    void updateUserPassword() {
        String userId = this.th.basicUser().getId();
        String currentPassword = this.th.basicUser().getPassword();
        String newPassword = "new" + currentPassword;
        ApiResponse response = Assertions.assertNoError(this.client.updateUserPassword(userId, currentPassword, newPassword));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void sendPasswordResetEmail() {
        String email = this.th.basicUser().getEmail();
        ApiResponse response = Assertions.assertNoError(this.client.sendPasswordResetEmail(email));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void getUserByEmail() {
        String email = this.th.basicUser().getEmail();
        ApiResponse response = Assertions.assertNoError(this.client.getUserByEmail(email, null));
        User user = (User)response.readEntity();
        MatcherAssert.assertThat((Object)user.getId(), (Matcher)CoreMatchers.is((Object)this.th.basicUser().getId()));
    }

    @Test
    void getUserSessions() {
        String userId = this.th.basicUser().getId();
        ApiResponse response = Assertions.assertNoError(this.client.getSessions(userId, null));
        List sessions = (List)response.readEntity();
        MatcherAssert.assertThat((Object)sessions.stream().findAny().map(Session::getUserId).get(), (Matcher)CoreMatchers.is((Object)userId));
    }

    @Test
    void revokeUserSession() {
        ApiResponse response = Assertions.assertNoError(this.client.getSessions(this.th.basicUser().getId(), null));
        Session session = (Session)((SessionList)response.readEntity()).stream().findAny().get();
        ApiResponse response2 = Assertions.assertNoError(this.client.revokeSession(session.getUserId(), session.getId()));
        boolean result = (Boolean)response2.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void attachMobileDevice() {
        ApiResponse response = Assertions.assertNoError(this.client.attachDeviceId(this.th.newId()));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void getAudits() {
        ApiResponse response = Assertions.assertNoError(this.client.getUserAudits(this.th.basicUser().getId(), Pager.of((int)0, (int)50), null));
        Audits audits = (Audits)response.readEntity();
        MatcherAssert.assertThat((Object)audits.stream().findAny().map(Audit::getId).get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    @Test
    void verifyEmail() {
        Assertions.assertStatus(this.client.verifyUserEmail(this.th.newId()), Response.Status.BAD_REQUEST);
    }

    @Test
    void sendVerificationEmail() {
        ApiResponse response = Assertions.assertNoError(this.client.sendVerificationEmail(this.th.basicUser().getEmail()));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void switchLoginMethod() {
        SwitchRequest request = new SwitchRequest();
        request.setCurrentService(AuthService.Email);
        request.setNewService(AuthService.GitLab);
        request.setEmail(this.th.basicUser().getEmail());
        request.setCurrentPassword(this.th.basicUser().getPassword());
        request.setPassword(this.th.basicUser().getPassword());
        this.th.loginBasic();
        Assertions.assertStatus(this.client.switchAccountType(request), Response.Status.NOT_IMPLEMENTED);
    }

    private void setupUserAccessTokenRolesForNormalUser(String userId) {
        this.th.logout().loginSystemAdmin();
        Assertions.assertNoError(this.client.updateUserRoles(userId, new Role[]{Role.SYSTEM_USER_ACCESS_TOKEN, Role.SYSTEM_USER}));
        this.th.logout().loginBasic();
    }

    @Test
    void createUserAccessToken() {
        String userId = this.th.basicUser().getId();
        this.setupUserAccessTokenRolesForNormalUser(userId);
        String description = userId + "_UserAccessTokenDesc";
        UserAccessToken token = (UserAccessToken)Assertions.assertNoError(this.client.createUserAccessToken(userId, description)).readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((Object)userId, (Object)token.getUserId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)description, (Object)token.getDescription());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)token.getToken());
    }

    @Test
    void getUserAccessTokens() {
        String userId = this.th.basicUser().getId();
        this.setupUserAccessTokenRolesForNormalUser(userId);
        String description1 = this.th.newRandomString(32);
        UserAccessToken token1 = (UserAccessToken)Assertions.assertNoError(this.client.createUserAccessToken(userId, description1)).readEntity();
        String description2 = this.th.newRandomString(32);
        UserAccessToken token2 = (UserAccessToken)Assertions.assertNoError(this.client.createUserAccessToken(userId, description2)).readEntity();
        UserAccessTokenList tokens = (UserAccessTokenList)Assertions.assertNoError(this.client.getUserAccessTokens(userId)).readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)tokens.size());
        MatcherAssert.assertThat(tokens.stream().map(UserAccessToken::getId).collect(Collectors.toSet()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{token1.getId(), token2.getId()}));
    }

    @Test
    void getUserAccessTokensAllUsers() {
        String userId = this.th.basicUser().getId();
        this.setupUserAccessTokenRolesForNormalUser(userId);
        String description = userId + "_UserAccessTokenDesc";
        UserAccessToken token = (UserAccessToken)Assertions.assertNoError(this.client.createUserAccessToken(userId, description)).readEntity();
        this.th.logout().loginSystemAdmin();
        UserAccessTokenList tokens = (UserAccessTokenList)Assertions.assertNoError(this.client.getUserAccessTokensAllUsers()).readEntity();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)tokens.stream().map(UserAccessToken::getId).collect(Collectors.toSet()).contains(token.getId()));
    }

    @Test
    void revokeUserAccessToken() {
        String userId = this.th.basicUser().getId();
        this.setupUserAccessTokenRolesForNormalUser(userId);
        String description = userId;
        UserAccessToken uat = (UserAccessToken)Assertions.assertNoError(this.client.createUserAccessToken(userId, description)).readEntity();
        ApiResponse revokeResponse = Assertions.assertNoError(this.client.revokeUserAccessToken(uat.getId()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)revokeResponse.readEntity()));
    }

    @Test
    void getUserAccessToken() {
        String userId = this.th.basicUser().getId();
        this.setupUserAccessTokenRolesForNormalUser(userId);
        String description = userId;
        UserAccessToken uat = (UserAccessToken)Assertions.assertNoError(this.client.createUserAccessToken(userId, description)).readEntity();
        UserAccessToken received = (UserAccessToken)Assertions.assertNoError(this.client.getUserAccessToken(uat.getId())).readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((Object)uat.getId(), (Object)received.getId());
        org.junit.jupiter.api.Assertions.assertNull((Object)received.getToken());
    }

    @Test
    void disableUserAccessToken() {
        String userId = this.th.basicUser().getId();
        this.setupUserAccessTokenRolesForNormalUser(userId);
        String description = userId;
        UserAccessToken uat = (UserAccessToken)Assertions.assertNoError(this.client.createUserAccessToken(userId, description)).readEntity();
        ApiResponse disableResponse = Assertions.assertNoError(this.client.disableUserAccessToken(uat.getId()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)disableResponse.readEntity()));
    }

    @Test
    void enableUserAccessToken() {
        String userId = this.th.basicUser().getId();
        this.setupUserAccessTokenRolesForNormalUser(userId);
        String description = userId;
        UserAccessToken uat = (UserAccessToken)Assertions.assertNoError(this.client.createUserAccessToken(userId, description)).readEntity();
        Assertions.assertNoError(this.client.disableUserAccessToken(uat.getId()));
        uat = (UserAccessToken)Assertions.assertNoError(this.client.getUserAccessToken(uat.getId())).readEntity();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)uat.isActive());
        ApiResponse enableResponse = Assertions.assertNoError(this.client.enableUserAccessToken(uat.getId()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)enableResponse.readEntity()));
    }

    @Test
    void searchTokens() {
        this.setupUserAccessTokenRolesForNormalUser(this.th.basicUser().getId());
        this.setupUserAccessTokenRolesForNormalUser(this.th.basicUser2().getId());
        this.setupUserAccessTokenRolesForNormalUser(this.th.teamAdminUser().getId());
        this.client.createUserAccessToken(this.th.basicUser().getId(), this.th.basicUser().getId()).readEntity();
        this.th.logout().loginBasic2();
        UserAccessToken user2TokenA = (UserAccessToken)this.client.createUserAccessToken(this.th.basicUser2().getId(), this.th.basicUser2().getId()).readEntity();
        UserAccessToken user2TokenB = (UserAccessToken)this.client.createUserAccessToken(this.th.basicUser2().getId(), this.th.basicUser2().getId()).readEntity();
        this.th.logout().loginSystemAdmin();
        String term = this.th.basicUser2().getUsername();
        UserAccessTokenList foundTokens = (UserAccessTokenList)Assertions.assertNoError(this.client.searchTokens(term)).readEntity();
        MatcherAssert.assertThat(foundTokens.stream().map(UserAccessToken::getId).collect(Collectors.toSet()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{user2TokenA.getId(), user2TokenB.getId()}));
    }

    @Test
    void revokeAllActiveSessionForUser() {
        User targetUser = this.th.basicUser2();
        try (MattermostClient theUserClient = this.createClient();){
            theUserClient.login(targetUser.getUsername(), targetUser.getPassword());
            Assertions.assertNoError(theUserClient.getUser("me"));
            this.th.logout().loginSystemAdmin();
            ApiResponse revokeResult = Assertions.assertNoError(this.client.revokeAllActiveSessionForUser(targetUser.getId()));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)revokeResult.readEntity()));
            Assertions.assertStatus(theUserClient.getUser("me"), Response.Status.UNAUTHORIZED);
        }
    }
}

