/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest.api;

import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.Pager;
import net.bis5.mattermost.client4.integrationtest.Assertions;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTest;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTestExtension;
import net.bis5.mattermost.client4.integrationtest.TestHelper;
import net.bis5.mattermost.model.Channel;
import net.bis5.mattermost.model.ChannelSearch;
import net.bis5.mattermost.model.Config;
import net.bis5.mattermost.model.Role;
import net.bis5.mattermost.model.Team;
import net.bis5.mattermost.model.TeamExists;
import net.bis5.mattermost.model.TeamInviteInfo;
import net.bis5.mattermost.model.TeamMember;
import net.bis5.mattermost.model.TeamPatch;
import net.bis5.mattermost.model.TeamSearch;
import net.bis5.mattermost.model.TeamStats;
import net.bis5.mattermost.model.TeamType;
import net.bis5.mattermost.model.TeamUnread;
import net.bis5.mattermost.model.User;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={MattermostClientTestExtension.class})
class TeamsApiTest
implements MattermostClientTest {
    private TestHelper th;
    private MattermostClient client;

    TeamsApiTest() {
    }

    @Override
    public void setHelper(TestHelper helper) {
        this.th = helper;
    }

    @BeforeEach
    void setup() {
        this.client = this.createClient();
        this.th.changeClient(this.client).initBasic();
    }

    @AfterEach
    void tearDown() {
        this.th.logout();
        this.client.close();
    }

    @Test
    void createTeam() {
        this.th.loginSystemAdmin();
        Team team = new Team();
        String teamName = this.th.generateTestTeamName();
        String teamDisplayName = "dn_" + teamName;
        team.setName(teamName);
        team.setDisplayName(teamDisplayName);
        team.setType(TeamType.OPEN);
        ApiResponse response = Assertions.assertNoError(this.client.createTeam(team));
        team = (Team)response.readEntity();
        MatcherAssert.assertThat((Object)team.getName(), (Matcher)CoreMatchers.is((Object)teamName));
        MatcherAssert.assertThat((Object)team.getDisplayName(), (Matcher)CoreMatchers.is((Object)teamDisplayName));
        MatcherAssert.assertThat((Object)team.getType(), (Matcher)CoreMatchers.is((Object)TeamType.OPEN));
        MatcherAssert.assertThat((Object)team.getId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    @Test
    void getTeams() {
        Team team = this.th.loginSystemAdmin().createTeam();
        Pager pager = Pager.of((int)0, (int)200);
        ApiResponse response = Assertions.assertNoError(this.client.getAllTeams(pager, null));
        List teams = (List)response.readEntity();
        if (teams.size() == 200) {
            List additionalTeams;
            while (!(additionalTeams = (List)(response = Assertions.assertNoError(this.client.getAllTeams(pager = pager.nextPage(), null))).readEntity()).isEmpty()) {
                teams.addAll(additionalTeams);
            }
        }
        MatcherAssert.assertThat(teams.stream().map(Team::getId).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItem((Object)team.getId()));
    }

    @Test
    void getTeam() {
        ApiResponse response = Assertions.assertNoError(this.client.getTeam(this.th.basicTeam().getId(), null));
        Team team = (Team)response.readEntity();
        MatcherAssert.assertThat((Object)team.getId(), (Matcher)CoreMatchers.is((Object)this.th.basicTeam().getId()));
    }

    @Test
    void updateTeam() {
        this.th.loginTeamAdmin();
        Team team = this.th.basicTeam();
        String teamId = team.getId();
        String newDispName = "new" + team.getDisplayName();
        team.setDisplayName(newDispName);
        ApiResponse response = Assertions.assertNoError(this.client.updateTeam(team));
        team = (Team)response.readEntity();
        MatcherAssert.assertThat((Object)team.getId(), (Matcher)CoreMatchers.is((Object)teamId));
        MatcherAssert.assertThat((Object)team.getDisplayName(), (Matcher)CoreMatchers.is((Object)newDispName));
    }

    @Test
    void deleteTeam_Soft() {
        this.th.loginSystemAdmin();
        ApiResponse response = Assertions.assertNoError(this.client.deleteTeam(this.th.basicTeam().getId()));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void deleteTeam_Permanent() {
        this.th.loginSystemAdmin();
        Config config = (Config)this.th.client().getConfig().readEntity();
        config.getServiceSettings().setEnableApiTeamDeletion(true);
        Assertions.assertNoError(this.th.client().updateConfig(config));
        config = (Config)this.th.client().getConfig().readEntity();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)config.getServiceSettings().isEnableApiTeamDeletion(), (String)"precondition");
        this.th.logout().loginTeamAdmin();
        ApiResponse response = Assertions.assertNoError(this.client.deleteTeam(this.th.basicTeam().getId(), true));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Disabled(value="Need to investigate why the api returns 200 instead of 401")
    void deleteTeam_Permanent_featureDisabled() {
        this.th.loginSystemAdmin();
        ApiResponse configResponse = this.th.client().getConfig();
        if (Assertions.isNotSupportVersion("5.25.4", configResponse)) {
            return;
        }
        Config config = (Config)this.th.client().getConfig().readEntity();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)config.getServiceSettings().isEnableApiTeamDeletion(), (String)"precondition");
        this.th.logout().loginTeamAdmin();
        Assertions.assertStatus(this.client.deleteTeam(this.th.basicTeam().getId(), true), Response.Status.UNAUTHORIZED);
    }

    @Test
    void patchTeam() {
        this.th.loginTeamAdmin();
        TeamPatch patch = new TeamPatch();
        String newDisplayName = "new" + this.th.basicTeam().getDisplayName();
        patch.setDisplayName(newDisplayName);
        ApiResponse response = Assertions.assertNoError(this.client.patchTeam(this.th.basicTeam().getId(), patch));
        Team team = (Team)response.readEntity();
        MatcherAssert.assertThat((Object)team.getDisplayName(), (Matcher)CoreMatchers.is((Object)newDisplayName));
    }

    @Test
    void getTeamByName() {
        String teamId = this.th.basicTeam().getId();
        String teamName = this.th.basicTeam().getName();
        ApiResponse response = Assertions.assertNoError(this.client.getTeamByName(teamName, null));
        Team team = (Team)response.readEntity();
        MatcherAssert.assertThat((Object)team.getId(), (Matcher)CoreMatchers.is((Object)teamId));
    }

    @Test
    void searchTeams() {
        TeamSearch search = new TeamSearch();
        search.setTerm(this.th.basicTeam().getName());
        ApiResponse response = Assertions.assertNoError(this.client.searchTeams(search));
        List teams = (List)response.readEntity();
        MatcherAssert.assertThat(teams.stream().map(Team::getId).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItem((Object)this.th.basicTeam().getId()));
    }

    @Test
    void teamExists_Exists() {
        ApiResponse response = Assertions.assertNoError(this.client.teamExists(this.th.basicTeam().getName(), null));
        TeamExists exists = (TeamExists)response.readEntity();
        MatcherAssert.assertThat((Object)exists.isExists(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void teamExists_NotExists() {
        ApiResponse response = Assertions.assertNoError(this.client.teamExists("fake" + this.th.generateTestTeamName(), null));
        TeamExists exists = (TeamExists)response.readEntity();
        MatcherAssert.assertThat((Object)exists.isExists(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    void getUsersTeams() {
        String userId = this.th.basicUser().getId();
        ApiResponse response = Assertions.assertNoError(this.client.getTeamsForUser(userId, null));
        List teams = (List)response.readEntity();
        MatcherAssert.assertThat(teams.stream().map(Team::getId).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItem((Object)this.th.basicTeam().getId()));
    }

    @Test
    void getTeamMembers() {
        ApiResponse response = Assertions.assertNoError(this.client.getTeamMembers(this.th.basicTeam().getId(), Pager.of((int)0, (int)60), null));
        List teamMembers = (List)response.readEntity();
        MatcherAssert.assertThat(teamMembers.stream().map(TeamMember::getUserId).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItems((Object[])new String[]{this.th.basicUser().getId(), this.th.basicUser2().getId()}));
    }

    @Test
    void addUserToTeam() {
        this.th.loginSystemAdmin();
        User user = this.th.createUser();
        this.th.loginTeamAdmin();
        TeamMember teamMemberToAdd = new TeamMember(this.th.basicTeam().getId(), user.getId());
        ApiResponse response = Assertions.assertNoError(this.client.addTeamMember(teamMemberToAdd));
        TeamMember teamMember = (TeamMember)response.readEntity();
        MatcherAssert.assertThat((Object)teamMember.getTeamId(), (Matcher)CoreMatchers.is((Object)teamMemberToAdd.getTeamId()));
        MatcherAssert.assertThat((Object)teamMember.getUserId(), (Matcher)CoreMatchers.is((Object)teamMemberToAdd.getUserId()));
    }

    @Test
    void addUserToTeamFromInvite() {
        this.th.logout().loginSystemAdmin();
        User noTeamUser = this.th.createUser();
        String inviteId = this.th.basicTeam().getInviteId();
        this.th.logout().loginAs(noTeamUser);
        ApiResponse response = Assertions.assertNoError(this.client.addTeamMemberFromInvite(null, inviteId));
        TeamMember teamMember = (TeamMember)response.readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.th.basicTeam().getId(), (Object)teamMember.getTeamId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)noTeamUser.getId(), (Object)teamMember.getUserId());
    }

    @Test
    void addMultipleUsersToTeam() {
        this.th.loginSystemAdmin();
        User user1 = this.th.createUser();
        User user2 = this.th.createUser();
        this.th.loginTeamAdmin();
        ApiResponse response = Assertions.assertNoError(this.client.addTeamMembers(this.th.basicTeam().getId(), new String[]{user1.getId(), user2.getId()}));
        List members = (List)response.readEntity();
        MatcherAssert.assertThat(members.stream().map(TeamMember::getUserId).collect(Collectors.toSet()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{user1.getId(), user2.getId()}));
    }

    @Test
    void getTeamMembersForUser() {
        ApiResponse response = Assertions.assertNoError(this.client.getTeamMembersForUser(this.th.basicUser().getId(), null));
        List members = (List)response.readEntity();
        MatcherAssert.assertThat(members.stream().map(TeamMember::getUserId).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItems((Object[])new String[]{this.th.basicUser().getId()}));
    }

    @Test
    void getTeamMember() {
        String teamId = this.th.basicTeam().getId();
        String userId = this.th.basicUser2().getId();
        ApiResponse response = Assertions.assertNoError(this.client.getTeamMember(teamId, userId, null));
        TeamMember member = (TeamMember)response.readEntity();
        MatcherAssert.assertThat((Object)member.getTeamId(), (Matcher)CoreMatchers.is((Object)teamId));
        MatcherAssert.assertThat((Object)member.getUserId(), (Matcher)CoreMatchers.is((Object)userId));
    }

    @Test
    void removeUserFromTeam() {
        this.th.loginTeamAdmin();
        String teamId = this.th.basicTeam().getId();
        String userId = this.th.basicUser2().getId();
        ApiResponse response = Assertions.assertNoError(this.client.removeTeamMember(teamId, userId));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void getTeamMembersByIds() {
        ApiResponse response = Assertions.assertNoError(this.client.getTeamMembersByIds(this.th.basicTeam().getId(), new String[]{this.th.basicUser().getId(), this.th.basicUser2().getId()}));
        List members = (List)response.readEntity();
        MatcherAssert.assertThat(members.stream().map(TeamMember::getUserId).collect(Collectors.toSet()), (Matcher)CoreMatchers.hasItems((Object[])new String[]{this.th.basicUser().getId(), this.th.basicUser2().getId()}));
    }

    @Test
    void getTeamStats() {
        ApiResponse response = Assertions.assertNoError(this.client.getTeamStats(this.th.basicTeam().getId(), null));
        TeamStats stats = (TeamStats)response.readEntity();
        MatcherAssert.assertThat((Object)stats.getTeamId(), (Matcher)CoreMatchers.is((Object)this.th.basicTeam().getId()));
    }

    @Test
    void setTeamIcon() throws URISyntaxException, IOException {
        this.th.logout().loginTeamAdmin();
        Path iconPath = this.th.getResourcePath("/noto-emoji_u1f6a7.png");
        String teamId = this.th.basicTeam().getId();
        ApiResponse response = Assertions.assertNoError(this.client.setTeamIcon(teamId, iconPath));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)response.readEntity()));
    }

    @Test
    void getTeamIcon() throws URISyntaxException, IOException {
        this.th.logout().loginTeamAdmin();
        Path iconPath = this.th.getResourcePath("/noto-emoji_u1f6a7.png");
        String teamId = this.th.basicTeam().getId();
        Assertions.assertNoError(this.client.setTeamIcon(teamId, iconPath));
        ApiResponse response = Assertions.assertNoError(this.client.getTeamIcon(teamId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Path)response.readEntity()).toFile().exists());
    }

    @Test
    void removeTeamIcon() throws URISyntaxException, IOException {
        this.th.logout().loginTeamAdmin();
        Path iconPath = this.th.getResourcePath("/noto-emoji_u1f6a7.png");
        String teamId = this.th.basicTeam().getId();
        Assertions.assertNoError(this.client.setTeamIcon(teamId, iconPath));
        ApiResponse response = Assertions.assertNoError(this.client.removeTeamIcon(teamId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)response.readEntity()));
    }

    @Test
    void updateTeamMemberRoles() {
        this.th.loginTeamAdmin();
        ApiResponse response = Assertions.assertNoError(this.client.updateTeamMemberRoles(this.th.basicTeam().getId(), this.th.basicUser().getId(), new Role[]{Role.TEAM_ADMIN}));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void getTeamUnreadsForUser() {
        ApiResponse response = Assertions.assertNoError(this.client.getTeamUnreadForUser(this.th.basicUser().getId(), null));
        List unreads = (List)response.readEntity();
        unreads.stream().findFirst().ifPresent(u -> MatcherAssert.assertThat((Object)u.getTeamId(), (Matcher)CoreMatchers.is((Object)this.th.basicTeam().getId())));
    }

    @Test
    void getTeamUnreadsForTeam() {
        ApiResponse response = Assertions.assertNoError(this.client.getTeamUnread(this.th.basicTeam().getId(), this.th.basicUser().getId()));
        TeamUnread unread = (TeamUnread)response.readEntity();
        MatcherAssert.assertThat((Object)unread.getTeamId(), (Matcher)CoreMatchers.is((Object)this.th.basicTeam().getId()));
    }

    @Test
    void tnviteUsersToTheTeamByEmail() {
        ApiResponse response = Assertions.assertNoError(this.client.inviteUsersToTeam(this.th.basicTeam().getId(), Collections.singletonList(this.th.generateTestEmail())));
        boolean result = (Boolean)response.readEntity();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Disabled
    void importTeamFromOtherApplication() {
    }

    @Test
    void getPublicChannels() {
        ApiResponse response = Assertions.assertNoError(this.client.getPublicChannelsForTeam(this.th.basicTeam().getId(), Pager.of((int)0, (int)60), null));
        List channels = (List)response.readEntity();
        MatcherAssert.assertThat((Object)((Channel)channels.stream().findAny().get()).getTeamId(), (Matcher)CoreMatchers.is((Object)this.th.basicTeam().getId()));
    }

    @Test
    void searchChannels() {
        ChannelSearch search = new ChannelSearch();
        search.setTerm(this.th.basicChannel().getName());
        ApiResponse response = Assertions.assertNoError(this.client.searchChannels(this.th.basicTeam().getId(), search));
        List channels = (List)response.readEntity();
        MatcherAssert.assertThat((Object)((Channel)channels.stream().findAny().get()).getTeamId(), (Matcher)CoreMatchers.is((Object)this.th.basicTeam().getId()));
    }

    @Test
    void getInviteInfo() {
        Team team = this.th.basicTeam();
        String inviteId = team.getInviteId();
        ApiResponse response = Assertions.assertNoError(this.client.getInviteInfo(inviteId));
        TeamInviteInfo inviteInfo = (TeamInviteInfo)response.readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((Object)team.getId(), (Object)inviteInfo.getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)team.getName(), (Object)inviteInfo.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)team.getDisplayName(), (Object)inviteInfo.getDisplayName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)team.getDescription(), (Object)inviteInfo.getDescription());
    }
}

