/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest.api;

import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.bis5.mattermost.client4.ApiResponse;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.integrationtest.Assertions;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTest;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTestExtension;
import net.bis5.mattermost.client4.integrationtest.TestHelper;
import net.bis5.mattermost.client4.model.AnalyticsCategory;
import net.bis5.mattermost.model.AnalyticsRow;
import net.bis5.mattermost.model.AnalyticsRows;
import net.bis5.mattermost.model.Team;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={MattermostClientTestExtension.class})
class SystemApiTest
implements MattermostClientTest {
    private TestHelper th;
    private MattermostClient client;

    SystemApiTest() {
    }

    @Override
    public void setHelper(TestHelper helper) {
        this.th = helper;
    }

    @BeforeEach
    void setup() {
        this.client = this.createClient();
        this.th.changeClient(this.client).initBasic();
    }

    @AfterEach
    void tearDown() {
        this.th.logout();
        this.client.close();
    }

    @Test
    void databaseRecycle() {
        this.th.logout().loginSystemAdmin();
        ApiResponse result = Assertions.assertNoError(this.client.databaseRecycle());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)result.readEntity()));
    }

    @Test
    void getAnalytics() {
        this.th.logout().loginSystemAdmin();
        AnalyticsRows analyticsRows = (AnalyticsRows)Assertions.assertNoError(this.client.getAnalytics()).readEntity();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)analyticsRows.isEmpty());
        MatcherAssert.assertThat((Object)((AnalyticsRow)analyticsRows.get(0)).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    @Test
    void getAnalyticsSpecifiedCategory() {
        this.th.logout().loginSystemAdmin();
        AnalyticsRows analyticsRows = (AnalyticsRows)Assertions.assertNoError(this.client.getAnalytics(AnalyticsCategory.EXTRA_COUNTS)).readEntity();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)analyticsRows.isEmpty());
        Set rowNames = analyticsRows.stream().map(AnalyticsRow::getName).map(String::toLowerCase).collect(Collectors.toSet());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)rowNames.contains("session_count"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)rowNames.contains("user_counts_with_posts_day"));
    }

    @Test
    void getAnalyticsSpecifiedTeam() {
        this.th.logout().loginSystemAdmin();
        Team basicTeam = this.th.basicTeam();
        AnalyticsRows analyticsRows = (AnalyticsRows)Assertions.assertNoError(this.client.getAnalytics(basicTeam.getId())).readEntity();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)analyticsRows.isEmpty());
        AnalyticsRow userCountRow = analyticsRows.stream().filter(r -> r.getName().equals("unique_user_count")).findAny().get();
        MatcherAssert.assertThat((Object)userCountRow.getValue().intValue(), (Matcher)CoreMatchers.is((Object)3));
        Team additionalTeam = this.th.createTeam();
        analyticsRows = (AnalyticsRows)Assertions.assertNoError(this.client.getAnalytics(additionalTeam.getId())).readEntity();
        userCountRow = analyticsRows.stream().filter(r -> r.getName().equals("unique_user_count")).findAny().get();
        MatcherAssert.assertThat((Object)userCountRow.getValue().intValue(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    void getOldClientConfig() {
        ApiResponse response = Assertions.assertNoError(this.client.getOldClientConfig());
        Map clientConfig = (Map)response.readEntity();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)clientConfig.containsKey("Version"));
    }

    @Test
    void getOldClientLicense() {
        ApiResponse response = Assertions.assertNoError(this.client.getOldClientLicense());
        Map clientLicense = (Map)response.readEntity();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)clientLicense.containsKey("IsLicensed"));
    }

    @Test
    void ping() {
        ApiResponse result = Assertions.assertNoError(this.client.getPing());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)result.readEntity()));
    }

    @Test
    void invalidateCache() {
        this.th.logout().loginSystemAdmin();
        ApiResponse result = Assertions.assertNoError(this.client.invalidateCaches());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)result.readEntity()));
    }

    @Test
    void reloadConfig() {
        this.th.logout().loginSystemAdmin();
        ApiResponse result = Assertions.assertNoError(this.client.reloadConfig());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)result.readEntity()));
    }

    @Test
    void testEmail() {
        this.th.logout().loginSystemAdmin();
        ApiResponse result = Assertions.assertNoError(this.client.testEmail());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)result.readEntity()));
    }

    @Test
    void uploadLicenseFile() throws IOException {
        Path licenseFile = Files.createTempFile(null, null, new FileAttribute[0]);
        licenseFile.toFile().deleteOnExit();
        this.th.logout().loginBasic();
        Assertions.assertStatus(this.client.uploadLicenseFile(licenseFile), Response.Status.FORBIDDEN);
        this.th.logout().loginSystemAdmin();
        Assertions.assertStatus(this.client.uploadLicenseFile(licenseFile), Response.Status.BAD_REQUEST);
    }

    @Test
    void removeLicense() {
        this.th.logout().loginBasic();
        Assertions.assertStatus(this.client.removeLicense(), Response.Status.FORBIDDEN);
        this.th.logout().loginSystemAdmin();
        Assertions.assertNoError(this.client.removeLicense());
    }
}

