/*
 * Decompiled with CFR 0.152.
 */
package net.bis5.mattermost.client4.integrationtest.api;

import java.util.Arrays;
import java.util.List;
import net.bis5.mattermost.client4.MattermostClient;
import net.bis5.mattermost.client4.integrationtest.Assertions;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTest;
import net.bis5.mattermost.client4.integrationtest.MattermostClientTestExtension;
import net.bis5.mattermost.client4.integrationtest.TestHelper;
import net.bis5.mattermost.model.ChannelView;
import net.bis5.mattermost.model.Status;
import net.bis5.mattermost.model.StatusList;
import net.bis5.mattermost.model.StatusType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={MattermostClientTestExtension.class})
class StatusApiTest
implements MattermostClientTest {
    private TestHelper th;
    private MattermostClient client;

    StatusApiTest() {
    }

    @Override
    public void setHelper(TestHelper helper) {
        this.th = helper;
    }

    @BeforeEach
    void setup() {
        this.client = this.createClient();
        this.th.changeClient(this.client).initBasic();
    }

    @AfterEach
    void tearDown() {
        this.th.logout();
        this.client.close();
    }

    @Test
    void getUserStatus() {
        String userId = this.th.basicUser().getId();
        Assertions.assertNoError(this.client.viewChannel(userId, new ChannelView(this.th.basicChannel().getId())));
        Status status = (Status)Assertions.assertNoError(this.client.getUserStatus(userId)).readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((Object)StatusType.ONLINE.getCode(), (Object)status.getStatus());
    }

    @Test
    void getUserStatusesByIds() {
        String loginUserId = this.th.basicUser().getId();
        Assertions.assertNoError(this.client.viewChannel(loginUserId, new ChannelView(this.th.basicChannel().getId())));
        String otherUserId = this.th.basicUser2().getId();
        List<String> userIds = Arrays.asList(loginUserId, otherUserId);
        StatusList statuses = (StatusList)Assertions.assertNoError(this.client.getUsersStatusesByIds(userIds)).readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)statuses.size());
        for (Status status : statuses) {
            if (status.getUserId().equals(loginUserId)) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)StatusType.ONLINE.getCode(), (Object)status.getStatus());
                continue;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)StatusType.OFFLINE.getCode(), (Object)status.getStatus());
        }
    }

    @Test
    void updateUserStatus() {
        String userId = this.th.basicUser().getId();
        Status newStatus = new Status();
        newStatus.setUserId(userId);
        newStatus.setStatus(StatusType.DND.getCode());
        newStatus = (Status)Assertions.assertNoError(this.client.updateUserStatus(userId, newStatus)).readEntity();
        org.junit.jupiter.api.Assertions.assertEquals((Object)StatusType.DND.getCode(), (Object)newStatus.getStatus());
    }
}

